/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.connection;

import com.openshift.client.InvalidCredentialsOpenShiftException;
import com.openshift.client.NotFoundOpenShiftException;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftTimeoutException;
import com.openshift.client.configuration.OpenShiftConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.core.OpenshiftCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;
import org.jboss.tools.openshift.express.internal.core.util.CollectionUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.viewer.NewConnectionMarker;
import org.jboss.tools.openshift.express.internal.ui.wizard.IConnectionAwareModel;

class ConnectionWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_CONNECTION = "selectedConnection";
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_REMEMBER_PASSWORD = "rememberPassword";
    public static final String PROPERTY_USE_DEFAULTSERVER = "useDefaultServer";
    public static final String PROPERTY_VALID = "valid";
    public static final String PROPERTY_CREATE_CONNECTION = "createConnection";
    private final IConnectionAwareModel wizardModel;
    private Connection selectedConnection;
    private final List<String> servers;
    private boolean isDefaultServer = true;
    private IStatus valid;
    private String host;
    private String username;
    private String password;
    private boolean isRememberPassword;
    private Connection newConnection;
    private boolean allowConnectionChange;

    ConnectionWizardPageModel(IConnectionAwareModel wizardModel, boolean allowConnectionChange) {
        this.wizardModel = wizardModel;
        this.allowConnectionChange = allowConnectionChange;
        this.selectedConnection = this.null2NewConnectionMarker(wizardModel.getConnection());
        this.servers = this.getServers(this.selectedConnection);
        this.updateFrom(this.selectedConnection);
    }

    private void updateFrom(Connection connection) {
        if (this.isCreateNewConnection(connection)) {
            this.setUsername(this.getDefaultUsername());
            this.setUseDefaultServer(true);
            this.setDefaultHost();
            this.setPassword(null);
        } else {
            this.setUsername(connection.getUsername());
            this.setHost(connection.getHost());
            this.setUseDefaultServer(connection.isDefaultHost());
            this.setRememberPassword(connection.isRememberPassword());
            this.setPassword(connection.getPassword());
        }
    }

    private boolean isCreateNewConnection(Connection connection) {
        return connection instanceof NewConnectionMarker;
    }

    protected String getDefaultUsername() {
        String username = OpenShiftPreferences.INSTANCE.getLastUsername();
        if (StringUtils.isEmpty((String)username)) {
            try {
                username = new OpenShiftConfiguration().getRhlogin();
            }
            catch (IOException e) {
                Logger.error("Could not load default user name from OpenShift configuration.", e);
            }
            catch (OpenShiftException e) {
                Logger.error("Could not load default user name from OpenShift configuration.", e);
            }
        }
        return username;
    }

    private Connection null2NewConnectionMarker(Connection connection) {
        if (connection == null) {
            return new NewConnectionMarker();
        }
        return connection;
    }

    public void setSelectedConnection(Connection connection) {
        if (Diffs.equals((Object)this.selectedConnection, (Object)connection)) {
            return;
        }
        this.updateFrom(connection);
        this.selectedConnection = connection;
        this.firePropertyChange(PROPERTY_SELECTED_CONNECTION, this.selectedConnection, this.selectedConnection);
    }

    public Connection getSelectedConnection() {
        return this.selectedConnection;
    }

    public List<Connection> getConnections() {
        if (this.allowConnectionChange) {
            List connections = CollectionUtils.toList((Object[])ConnectionsModelSingleton.getInstance().getConnections());
            connections.add(new NewConnectionMarker());
            return connections;
        }
        return Collections.singletonList(this.selectedConnection);
    }

    public boolean isUseDefaultServer() {
        return this.isDefaultServer;
    }

    public void setUseDefaultServer(boolean isDefaultServer) {
        if (this.isDefaultServer != isDefaultServer) {
            this.isDefaultServer = isDefaultServer;
            this.firePropertyChange(PROPERTY_USE_DEFAULTSERVER, this.isDefaultServer, this.isDefaultServer);
            if (isDefaultServer) {
                this.setDefaultHost();
            }
            this.resetValid();
        }
    }

    private List<String> getServers(Connection connection) {
        ArrayList<String> servers = new ArrayList<String>();
        HashSet<String> uniqueServers = new HashSet<String>();
        uniqueServers.add(this.getDefaultServer());
        servers.add(connection.getHost());
        return servers;
    }

    private String getDefaultServer() {
        try {
            return new OpenShiftConfiguration().getLibraServer();
        }
        catch (Exception e) {
            OpenShiftUIActivator.log(e);
            return null;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (!Diffs.equals((Object)this.username, (Object)username)) {
            this.username = username;
            this.firePropertyChange(PROPERTY_USERNAME, this.username, this.username);
            this.resetValid();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (!Diffs.equals((Object)password, (Object)this.password)) {
            this.password = password;
            this.firePropertyChange(PROPERTY_PASSWORD, this.password, this.password);
            this.resetValid();
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (!Diffs.equals((Object)this.host, (Object)host)) {
            this.host = host;
            this.firePropertyChange(PROPERTY_HOST, this.host, this.host);
            this.resetValid();
        }
    }

    private void setDefaultHost() {
        this.setHost(ConnectionUtils.getDefaultHostUrl());
    }

    public List<String> getServers() {
        return this.servers;
    }

    public boolean isRememberPassword() {
        return this.isRememberPassword;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.isRememberPassword = rememberPassword;
        this.firePropertyChange(PROPERTY_REMEMBER_PASSWORD, this.isRememberPassword, this.isRememberPassword);
    }

    private void resetValid() {
        this.setValid(null);
    }

    private void setValid(IStatus status) {
        this.valid = status;
        this.firePropertyChange(PROPERTY_VALID, this.valid, this.valid);
    }

    public IStatus getValid() {
        return this.valid;
    }

    public IStatus connect() {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                Connection connection = null;
                if (this.isCreateNewConnection() || this.isSelectedConnectionChanged()) {
                    connection = this.createConnection();
                } else {
                    connection = this.selectedConnection;
                    connection.setRememberPassword(this.isRememberPassword());
                }
                connection.connect();
                this.newConnection = connection;
            }
            catch (OpenShiftTimeoutException openShiftTimeoutException) {
                status = OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not reach host at {0}. Connection timeouted.", (Object)this.host));
            }
            catch (InvalidCredentialsOpenShiftException invalidCredentialsOpenShiftException) {
                status = OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"The credentials for user {0} are not valid", (Object)this.username));
            }
            catch (OpenShiftException e) {
                status = OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Unknown error, can not verify user {0} - see Error Log for details", (Object)this.username));
                OpenShiftUIActivator.log(e);
            }
        }
        catch (NotFoundOpenShiftException notFoundOpenShiftException) {
        }
        catch (Exception e) {
            status = OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Unknown error, can not verify user {0} - see Error Log for details", (Object)this.username));
            OpenShiftUIActivator.log(e);
        }
        this.setValid(status);
        return status;
    }

    private Connection createConnection() {
        String host = this.host;
        if (this.isDefaultServer) {
            return new Connection(this.username, this.password, this.isRememberPassword, OpenshiftCoreUIIntegration.getDefault().getSSLCertificateCallback());
        }
        return new Connection(this.username, this.password, host, this.isRememberPassword, OpenshiftCoreUIIntegration.getDefault().getSSLCertificateCallback());
    }

    private boolean isSelectedConnectionChanged() {
        return !this.password.equals(this.selectedConnection.getPassword());
    }

    public Connection getConnection() {
        return this.newConnection;
    }

    public boolean isCreateNewConnection() {
        return this.isCreateNewConnection(this.selectedConnection);
    }

    public void createOrUpdateConnection() {
        if (this.isCreateNewConnection()) {
            this.wizardModel.setConnection(this.newConnection);
            ConnectionsModelSingleton.getInstance().addConnection(this.newConnection);
        } else {
            if (this.selectedConnection != this.newConnection) {
                this.selectedConnection.update(this.newConnection);
            }
            this.wizardModel.setConnection(this.selectedConnection);
            ConnectionsModelSingleton.getInstance().fireConnectionChanged(this.selectedConnection);
        }
    }

    public void saveRecentConnection() {
        Connection connection = this.getConnection();
        if (connection != null) {
            ConnectionsModelSingleton.getInstance().setRecent(connection);
        }
    }
}

