/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.connection;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.OpenshiftUIMessages;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredStringValidator;
import org.jboss.tools.openshift.express.internal.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.express.internal.ui.explorer.AbstractLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUpdatingJob;
import org.jboss.tools.openshift.express.internal.ui.viewer.ConnectionColumLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.viewer.NewConnectionAwareConnectionComparer;
import org.jboss.tools.openshift.express.internal.ui.viewer.NewConnectionMarker;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.IConnectionAwareModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.connection.ConnectionWizardPageModel;

public class ConnectionWizardPage
extends AbstractOpenShiftWizardPage {
    protected static final String OPENSHIFT_EXPRESS_SIGNUP_URL = "https://openshift.redhat.com/app/user/new/express";
    private final ConnectionWizardPageModel pageModel;
    private Text connectionCompositeUsernameText;
    private Text connectionCompositePasswordText;
    private Text passwordCompositePasswordText;

    public ConnectionWizardPage(IWizard wizard, IConnectionAwareModel wizardModel) {
        this(wizard, wizardModel, true);
    }

    protected ConnectionWizardPage(IWizard wizard, IConnectionAwareModel wizardModel, boolean allowConnectionChange) {
        super("Sign in to OpenShift", "Please provide your OpenShift credentials.", "Server Connection", wizard);
        this.pageModel = new ConnectionWizardPageModel(wizardModel, allowConnectionChange);
        EGitUIUtils.ensureEgitUIIsStarted();
    }

    @Override
    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Link signupLink = new Link(container, 64);
        signupLink.setText("If you do not have an account on OpenShift, please sign up <a>here</a>.");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)signupLink);
        signupLink.addSelectionListener((SelectionListener)this.onSignupLinkClicked());
        Label fillerLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().span(2, 1).hint(-1, 6).applyTo((Control)fillerLabel);
        Label connectionLabel = new Label(container, 0);
        connectionLabel.setText("Connection:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)connectionLabel);
        Combo connectionCombo = new Combo(container, -1);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)connectionCombo);
        ComboViewer connectionComboViewer = new ComboViewer(connectionCombo);
        connectionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        connectionComboViewer.setLabelProvider((IBaseLabelProvider)new ConnectionColumLabelProvider());
        connectionComboViewer.setInput(this.pageModel.getConnections());
        connectionComboViewer.setComparer((IElementComparer)new NewConnectionAwareConnectionComparer());
        Binding selectedConnectionBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)connectionComboViewer)).validatingAfterGet(new IValidator(){

            public IStatus validate(Object value) {
                if (value == null) {
                    return ValidationStatus.cancel((String)"You have to select or create a new connection.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"selectedConnection", Connection.class).observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedConnectionBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Composite connectionWidgetsContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)connectionWidgetsContainer);
        StackLayout stackLayout = new StackLayout();
        connectionWidgetsContainer.setLayout((Layout)stackLayout);
        Composite connectionWidgets = this.createNewConnectionComposite(connectionWidgetsContainer, dbc);
        Composite passwordWidgets = this.createExistingConnectionComposite(connectionWidgetsContainer, dbc);
        this.showConnectionWidgets(this.pageModel.isCreateNewConnection(), passwordWidgets, connectionWidgets, stackLayout, connectionWidgetsContainer);
        BeanProperties.value((String)"selectedConnection").observe((Object)this.pageModel).addValueChangeListener(this.onNewConnectionSelected(passwordWidgets, connectionWidgets, stackLayout, connectionWidgetsContainer));
    }

    private IValueChangeListener onNewConnectionSelected(final Composite passwordWidget, final Composite connectionWidgets, final StackLayout stackLayout, final Composite container) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Connection selectedConnection = ConnectionWizardPage.this.pageModel.getSelectedConnection();
                boolean isNewConnection = selectedConnection instanceof NewConnectionMarker;
                ConnectionWizardPage.this.showConnectionWidgets(isNewConnection, passwordWidget, connectionWidgets, stackLayout, container);
            }
        };
    }

    private void showConnectionWidgets(boolean isNewConnection, Composite passwordWidgets, Composite connectionsWidgets, StackLayout stackLayout, Composite container) {
        Composite topControl = null;
        topControl = isNewConnection ? connectionsWidgets : passwordWidgets;
        stackLayout.topControl = topControl;
        container.layout();
    }

    private Composite createExistingConnectionComposite(Composite container, DataBindingContext dbc) {
        Composite passwordWidgets = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(passwordWidgets);
        Label passwordLabel = new Label(passwordWidgets, 0);
        passwordLabel.setText("&Password:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)passwordLabel);
        this.passwordCompositePasswordText = new Text(passwordWidgets, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.passwordCompositePasswordText);
        Binding passwordBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.passwordCompositePasswordText)).validatingAfterGet((IValidator)new RequiredStringValidator("password"))).to(BeanProperties.value((String)"password").observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)passwordBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Button rememberPasswordCheckBox = new Button(passwordWidgets, 32);
        rememberPasswordCheckBox.setText(OpenshiftUIMessages.OpenshiftWizardSavePassword);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)rememberPasswordCheckBox);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)rememberPasswordCheckBox)).to(BeanProperties.value((String)"rememberPassword").observe((Object)this.pageModel)).in(dbc);
        IObservableValue credentialsStatusObservable = BeanProperties.value((String)"valid", IStatus.class).observe((Object)this.pageModel);
        CredentialsValidator credentialsValidator = new CredentialsValidator(credentialsStatusObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)credentialsValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)credentialsValidator, (int)16512);
        return passwordWidgets;
    }

    private Composite createNewConnectionComposite(Composite container, DataBindingContext dbc) {
        Composite connectionWidgets = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(connectionWidgets);
        Button defaultServerCheckbox = new Button(connectionWidgets, 32);
        defaultServerCheckbox.setText("Use default server");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)defaultServerCheckbox);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)defaultServerCheckbox)).to(BeanProperties.value((String)"useDefaultServer").observe((Object)this.pageModel)).in(dbc);
        Label serverLabel = new Label(connectionWidgets, 0);
        serverLabel.setText("&Server:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)serverLabel);
        Combo serversCombo = new Combo(connectionWidgets, 2048);
        ComboViewer serverComboViewer = new ComboViewer(serversCombo);
        serverComboViewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        serverComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        serverComboViewer.setInput(this.pageModel.getServers());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)serversCombo);
        ISWTObservableValue serverObservable = WidgetProperties.text().observe((Widget)serversCombo);
        Binding serverBinding = ValueBindingBuilder.bind((IObservableValue)serverObservable).to(BeanProperties.value((String)"host").observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)serverBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        RequiredStringValidationProvider hostValidation = new RequiredStringValidationProvider((IObservableValue)serverObservable, "server");
        dbc.addValidationStatusProvider((ValidationStatusProvider)hostValidation);
        ControlDecorationSupport.create((ValidationStatusProvider)hostValidation, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)serversCombo)).notUpdatingParticipant()).to(BeanProperties.value((String)"useDefaultServer").observe((Object)this.pageModel)).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        Label rhLoginLabel = new Label(connectionWidgets, 0);
        rhLoginLabel.setText("&Username:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)rhLoginLabel);
        this.connectionCompositeUsernameText = new Text(connectionWidgets, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.connectionCompositeUsernameText);
        ISWTObservableValue usernameObservable = WidgetProperties.text((int)24).observe((Widget)this.connectionCompositeUsernameText);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)usernameObservable).converting((IConverter)new TrimmingStringConverter())).to(BeanProperties.value((String)"username").observe((Object)this.pageModel)).in(dbc);
        RequiredStringValidationProvider usernameValidation = new RequiredStringValidationProvider((IObservableValue)usernameObservable, "username");
        dbc.addValidationStatusProvider((ValidationStatusProvider)usernameValidation);
        ControlDecorationSupport.create((ValidationStatusProvider)usernameValidation, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label passwordLabel = new Label(connectionWidgets, 0);
        passwordLabel.setText("&Password:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)passwordLabel);
        this.connectionCompositePasswordText = new Text(connectionWidgets, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.connectionCompositePasswordText);
        ISWTObservableValue passwordObservable = WidgetProperties.text((int)24).observe((Widget)this.connectionCompositePasswordText);
        ValueBindingBuilder.bind((IObservableValue)passwordObservable).to(BeanProperties.value((String)"password").observe((Object)this.pageModel)).in(dbc);
        RequiredStringValidationProvider passwordValidation = new RequiredStringValidationProvider((IObservableValue)passwordObservable, "password");
        dbc.addValidationStatusProvider((ValidationStatusProvider)passwordValidation);
        ControlDecorationSupport.create((ValidationStatusProvider)passwordValidation, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Button rememberPasswordCheckBox = new Button(connectionWidgets, 32);
        rememberPasswordCheckBox.setText(OpenshiftUIMessages.OpenshiftWizardSavePassword);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)rememberPasswordCheckBox);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)rememberPasswordCheckBox)).to(BeanProperties.value((String)"rememberPassword").observe((Object)this.pageModel)).in(dbc);
        IObservableValue credentialsStatusObservable = BeanProperties.value((String)"valid", IStatus.class).observe((Object)this.pageModel);
        CredentialsValidator credentialsValidator = new CredentialsValidator(credentialsStatusObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)credentialsValidator);
        return connectionWidgets;
    }

    protected SelectionAdapter onSignupLinkClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserUtility().checkedCreateInternalBrowser(ConnectionWizardPage.OPENSHIFT_EXPRESS_SIGNUP_URL, ConnectionWizardPage.OPENSHIFT_EXPRESS_SIGNUP_URL, "org.jboss.tools.openshift.express.ui", OpenShiftUIActivator.getDefault().getLog());
                org.jboss.tools.openshift.express.internal.ui.utils.WizardUtils.close(ConnectionWizardPage.this.getWizard());
            }
        };
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        super.onPageActivated(dbc);
        this.setInitialFocus();
    }

    @Override
    protected void onPageDeactivated(DataBindingContext dbc) {
        this.pageModel.saveRecentConnection();
    }

    @Override
    protected void onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event, DataBindingContext dbc) {
        if (direction == AbstractOpenShiftWizardPage.Direction.BACKWARDS) {
            return;
        }
        event.doit = this.connect();
        if (!event.doit) {
            this.setInitialFocus();
        }
    }

    private void setInitialFocus() {
        if (this.pageModel.isCreateNewConnection()) {
            if (this.connectionCompositeUsernameText.getText().isEmpty()) {
                this.connectionCompositeUsernameText.setFocus();
            } else {
                this.connectionCompositePasswordText.setFocus();
                this.connectionCompositePasswordText.selectAll();
            }
        } else {
            this.passwordCompositePasswordText.setFocus();
            this.passwordCompositePasswordText.selectAll();
        }
    }

    public boolean connect() {
        try {
            WizardUtils.runInWizard((Job)new ConnectJob(), (DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDatabindingContext());
            return JobUtils.isOk((IStatus)this.pageModel.getValid());
        }
        catch (InterruptedException e) {
            Logger.error("Failed to authenticate on OpenShift", e);
            return false;
        }
        catch (InvocationTargetException e) {
            Logger.error("Failed to authenticate on OpenShift", e);
            return false;
        }
    }

    public Connection getConnection() {
        return this.pageModel.getConnection();
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    private class ConnectJob
    extends UIUpdatingJob {
        private IStatus connectionStatus;

        private ConnectJob() {
            super("Verifying user credentials...");
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            this.connectionStatus = ConnectionWizardPage.this.pageModel.connect();
            monitor.done();
            return Status.OK_STATUS;
        }

        @Override
        protected IStatus updateUI(IProgressMonitor monitor) {
            if (!JobUtils.isOk((IStatus)this.connectionStatus)) {
                return Status.OK_STATUS;
            }
            ConnectionWizardPage.this.pageModel.createOrUpdateConnection();
            return Status.OK_STATUS;
        }
    }

    class CredentialsValidator
    extends MultiValidator {
        private final IObservableValue credentialsStatusObservable;

        public CredentialsValidator(IObservableValue credentialsStatusObservable) {
            this.credentialsStatusObservable = credentialsStatusObservable;
        }

        protected IStatus validate() {
            IStatus credentialsValidityStatus = (IStatus)this.credentialsStatusObservable.getValue();
            if (credentialsValidityStatus != null) {
                return ConnectionWizardPage.this.pageModel.getValid();
            }
            return ValidationStatus.ok();
        }
    }

    class RequiredStringValidationProvider
    extends MultiValidator {
        private IObservableValue observableValue;
        private String name;

        public RequiredStringValidationProvider(IObservableValue value, String name) {
            this.observableValue = value;
            this.name = name;
        }

        protected IStatus validate() {
            if (!(this.observableValue.getValue() instanceof String)) {
                return ValidationStatus.cancel((String)("You have to provide a " + this.name));
            }
            String string = (String)this.observableValue.getValue();
            if (string.isEmpty()) {
                return ValidationStatus.cancel((String)("You have to provide a " + this.name));
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.observableValue);
            return targets;
        }
    }

    private class ServerLabelProvider
    extends AbstractLabelProvider {
        private ServerLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (!(element instanceof String)) {
                return null;
            }
            return (String)element;
        }
    }
}

