/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.template;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.util.Collections;
import java.util.Set;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.AbstractApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICartridgeApplicationTemplate;

public class CartridgeApplicationTemplate
extends AbstractApplicationTemplate
implements ICartridgeApplicationTemplate {
    private IStandaloneCartridge cartridge;

    public CartridgeApplicationTemplate(IStandaloneCartridge cartridge) {
        super(cartridge.getDisplayName(), cartridge.getDescription(), new IApplicationTemplate[0]);
        this.cartridge = cartridge;
    }

    @Override
    public ICartridge getStandaloneCartridge() {
        return this.cartridge;
    }

    @Override
    public Set<ICartridge> getAllCartridges() {
        return Collections.singleton(this.cartridge);
    }

    @Override
    public boolean canAddRemoveCartridges() {
        return true;
    }

    @Override
    public String getInitialGitUrl() {
        return null;
    }

    @Override
    public boolean isCodeAnything() {
        return this.cartridge.isDownloadable();
    }

    @Override
    public boolean isMatching(String expression) {
        if (super.isMatching(expression)) {
            return true;
        }
        if (this.cartridge == null) {
            return false;
        }
        return this.isMatching(StringUtils.toLowerCase((String)expression), StringUtils.toLowerCase((String)this.cartridge.getName()));
    }

    @Override
    public boolean isInitialGitUrlEditable() {
        return true;
    }
}

