/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.ui.WontOverwriteException;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.AbstractImportApplicationOperation;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.project.GeneralProjectImportOperation;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.project.MavenProjectImportOperation;

public class ImportNewProject
extends AbstractImportApplicationOperation {
    private File cloneDestination;

    public ImportNewProject(String projectName, IApplication application, String remoteName, File cloneDestination, List<IOpenShiftMarker> markers, Connection connection) {
        super(projectName, application, remoteName, markers, connection);
        this.cloneDestination = cloneDestination;
    }

    @Override
    public IProject execute(IProgressMonitor monitor) throws OpenShiftException, CoreException, InterruptedException, URISyntaxException, InvocationTargetException, IOException, NoWorkTreeException, GitAPIException {
        if (this.cloneDestinationExists()) {
            throw new WontOverwriteException(NLS.bind((String)"There's already a folder at {0}. The new OpenShift project would overwrite it. Please choose another destination to clone to.", (Object)this.getCloneDestination().getAbsolutePath()), new Object[0]);
        }
        File repositoryFolder = this.cloneRepository(this.getApplication(), this.getRemoteName(), this.cloneDestination, true, monitor);
        List<IProject> importedProjects = this.importProjectsFrom(repositoryFolder, monitor);
        this.connectToGitRepo(importedProjects, repositoryFolder, monitor);
        IProject project = this.getSettingsProject(importedProjects);
        this.addToModified((IResource)this.setupGitIgnore(project, monitor));
        this.addSettingsFile(project, monitor);
        this.addToModified(this.setupMarkers(project, monitor));
        return this.getSettingsProject(importedProjects);
    }

    private void mergeWithApplicationRepository(Repository repository, IApplication application, IProgressMonitor monitor) throws MalformedURLException, URISyntaxException, IOException, OpenShiftException, CoreException, InvocationTargetException {
        URIish uri = new URIish(application.getGitUrl());
        EGitUtils.addRemoteTo((String)"openshift", (URIish)uri, (Repository)repository);
        EGitUtils.mergeWithRemote((URIish)uri, (String)"refs/remotes/openshift/HEAD", (Repository)repository, (IProgressMonitor)monitor);
    }

    private List<IProject> importProjectsFrom(File folder, IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenProjectImportOperation mavenImport = new MavenProjectImportOperation(folder);
        List<IProject> importedProjects = Collections.emptyList();
        importedProjects = mavenImport.isMavenProject() ? mavenImport.importToWorkspace(monitor) : new GeneralProjectImportOperation(folder).importToWorkspace(monitor);
        return importedProjects;
    }

    private void connectToGitRepo(List<IProject> projects, File projectFolder, IProgressMonitor monitor) throws CoreException {
        for (IProject project : projects) {
            if (project == null) continue;
            EGitUtils.connect((IProject)project, (IProgressMonitor)monitor);
        }
    }

    protected File getCloneDestination() {
        return this.cloneDestination;
    }

    protected boolean cloneDestinationExists() {
        return this.cloneDestination != null && this.cloneDestination.exists();
    }
}

