/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.preferencevalue.StringPreferenceValue;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.util.ProjectUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.SelectProjectDialog;

public class SelectExistingProjectDialog
extends SelectProjectDialog {
    StringPreferenceValue showAllPreferences = new StringPreferenceValue("FILTER_ACCEPTABLE_PROJECTS", "org.jboss.tools.openshift.express.ui");
    private boolean showAll;

    public SelectExistingProjectDialog(String openShiftAppName, Shell shell) {
        super(shell);
        this.setMessage(NLS.bind((String)"Select an existing project for {0}.\nOnly non-shared projects or Git projects allowed.", (Object)openShiftAppName));
        this.showAll = this.getShowAllPreferences();
    }

    private boolean getShowAllPreferences() {
        boolean showAll = false;
        if (!StringUtils.isEmpty((String)this.showAllPreferences.get())) {
            showAll = Boolean.valueOf(this.showAllPreferences.get());
        }
        return showAll;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Button filterCheckbox = new Button(dialogArea, 32);
        filterCheckbox.setText("&Show all projects");
        filterCheckbox.setSelection(this.showAll);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)filterCheckbox);
        filterCheckbox.addSelectionListener(this.onFilterChecked());
        return dialogArea;
    }

    private SelectionListener onFilterChecked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (e.widget instanceof Button) {
                    SelectExistingProjectDialog.this.showAll = ((Button)e.widget).getSelection();
                    SelectExistingProjectDialog.this.showAllPreferences.store(String.valueOf(SelectExistingProjectDialog.this.showAll));
                    SelectExistingProjectDialog.this.setListElements(SelectExistingProjectDialog.this.getProjects());
                }
            }
        };
    }

    @Override
    protected boolean isValid(IProject project) {
        if (this.showAll) {
            return true;
        }
        if (!project.isAccessible()) {
            return false;
        }
        if (ProjectUtils.isInternalRSE((String)project.getName())) {
            return false;
        }
        return !this.isNonGitShared(project);
    }

    protected boolean isNonGitShared(IProject project) {
        return EGitUtils.isShared((IProject)project) && !EGitUtils.isSharedWithGit((IProject)project);
    }
}

