/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.IApplication;
import com.openshift.client.cartridge.ICartridge;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.IOpenShiftApplicationWizardModel;

public class GitCloningSettingsWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_APPLICATION_NAME = "applicationName";
    public static final String PROPERTY_NEW_PROJECT = "newProject";
    public static final String PROPERTY_REPO_PATH = "repositoryPath";
    public static final String PROPERTY_REMOTE_NAME = "remoteName";
    public static final String PROPERTY_USE_DEFAULT_REPO_PATH = "useDefaultRepoPath";
    public static final String PROPERTY_USE_DEFAULT_REMOTE_NAME = "useDefaultRemoteName";
    public static final String PROPERTY_HAS_REMOTEKEYS = "hasRemoteKeys";
    private IOpenShiftApplicationWizardModel wizardModel;
    private boolean useDefaultRepoPath = true;
    private boolean useDefaultRemoteName = true;
    private boolean hasRemoteKeys;

    public GitCloningSettingsWizardPageModel(IOpenShiftApplicationWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        wizardModel.addPropertyChangeListener(PROPERTY_APPLICATION_NAME, this.onWizardApplicationNameChanged());
        wizardModel.addPropertyChangeListener("projectName", this.onWizardProjectNameChanged());
        wizardModel.addPropertyChangeListener(PROPERTY_NEW_PROJECT, this.onWizardProjectNameChanged());
        this.setRepositoryPath(this.getDefaultRepositoryPath());
        this.setDefaultRemoteName();
    }

    private PropertyChangeListener onWizardApplicationNameChanged() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GitCloningSettingsWizardPageModel.this.firePropertyChange(GitCloningSettingsWizardPageModel.PROPERTY_APPLICATION_NAME, evt.getOldValue(), evt.getNewValue());
                if (GitCloningSettingsWizardPageModel.this.wizardModel.isNewProject() && GitCloningSettingsWizardPageModel.this.isUseDefaultRepoPath()) {
                    GitCloningSettingsWizardPageModel.this.setRepositoryPath(IOpenShiftApplicationWizardModel.DEFAULT_REPOSITORY_PATH);
                }
            }
        };
    }

    private PropertyChangeListener onWizardProjectNameChanged() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (GitCloningSettingsWizardPageModel.this.isUseDefaultRepoPath()) {
                    IProject project = GitCloningSettingsWizardPageModel.this.wizardModel.getProject();
                    if (project != null && project.exists()) {
                        GitCloningSettingsWizardPageModel.this.setRepositoryPath(project.getLocation().toOSString());
                    } else {
                        GitCloningSettingsWizardPageModel.this.setRepositoryPath(IOpenShiftApplicationWizardModel.DEFAULT_REPOSITORY_PATH);
                    }
                }
                GitCloningSettingsWizardPageModel.this.setDefaultRemoteName();
            }
        };
    }

    public boolean isNewProject() {
        return this.wizardModel.isNewProject();
    }

    public String getApplicationName() {
        return this.wizardModel.getApplicationName();
    }

    public String getRepositoryPath() {
        return this.wizardModel.getRepositoryPath();
    }

    public void setRepositoryPath(String repositoryPath) {
        this.firePropertyChange(PROPERTY_REPO_PATH, this.wizardModel.getRepositoryPath(), this.wizardModel.setRepositoryPath(repositoryPath));
    }

    private void resetRemoteName() {
        this.setRemoteName(null);
    }

    private void setDefaultRemoteName() {
        if (this.wizardModel.isNewProject()) {
            this.setRemoteName("origin");
        } else {
            this.setRemoteName("openshift");
        }
    }

    private String getDefaultRepositoryPath() {
        return EGitUIUtils.getEGitDefaultRepositoryPath();
    }

    public String getRemoteName() {
        return this.wizardModel.getRemoteName();
    }

    public void setRemoteName(String remoteName) {
        this.firePropertyChange(PROPERTY_REMOTE_NAME, this.wizardModel.getRemoteName(), this.wizardModel.setRemoteName(remoteName));
    }

    public boolean isCompatibleToApplicationCartridge(ICartridge cartridge) {
        IApplication application = this.wizardModel.getApplication();
        return application != null && application.getCartridge() != null && application.getCartridge().equals(cartridge);
    }

    public void setUseDefaultRepoPath(boolean useDefaultRepoPath) {
        this.useDefaultRepoPath = useDefaultRepoPath;
        this.firePropertyChange(PROPERTY_USE_DEFAULT_REPO_PATH, this.useDefaultRepoPath, this.useDefaultRepoPath);
        if (useDefaultRepoPath) {
            this.setRepositoryPath(this.getDefaultRepositoryPath());
        }
    }

    public boolean isUseDefaultRepoPath() {
        return this.useDefaultRepoPath;
    }

    public void setUseDefaultRemoteName(boolean useDefaultRemoteName) {
        this.useDefaultRemoteName = useDefaultRemoteName;
        this.firePropertyChange(PROPERTY_USE_DEFAULT_REMOTE_NAME, useDefaultRemoteName, this.useDefaultRemoteName);
        if (useDefaultRemoteName) {
            this.setDefaultRemoteName();
        } else {
            this.resetRemoteName();
        }
    }

    public boolean isUseDefaultRemoteName() {
        return this.useDefaultRemoteName;
    }

    public boolean getHasRemoteKeys() {
        return this.hasRemoteKeys;
    }

    public void setHasRemoteKeys(boolean hasRemoteKeys) {
        this.hasRemoteKeys = hasRemoteKeys;
        this.firePropertyChange(PROPERTY_HAS_REMOTEKEYS, this.hasRemoteKeys, this.hasRemoteKeys);
    }

    public Connection getConnection() {
        return this.wizardModel.getConnection();
    }

    public boolean isConnected() {
        return this.getConnection() != null && this.getConnection().isConnected();
    }

    public void reset() {
        this.setRemoteName(this.wizardModel.getRemoteName());
        this.setRepositoryPath(this.wizardModel.getRepositoryPath());
        this.setHasRemoteKeys(this.getHasRemoteKeys());
    }
}

