/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.property;

import com.openshift.client.IDomain;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftResourceLabelUtils;

public class DomainPropertySource
implements IPropertySource {
    private static final String PROPERTY_ID = "ID";
    private static final String PROPERTY_SUFFIX = "SUFFIX";
    private static final String PROPERTY_FULLNAME = "FULLNAME";
    private final IDomain domain;

    public DomainPropertySource(IDomain domain) {
        this.domain = domain;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new PropertyDescriptor((Object)PROPERTY_ID, "Id"), new PropertyDescriptor((Object)PROPERTY_SUFFIX, "Suffix"), new PropertyDescriptor((Object)PROPERTY_FULLNAME, "Full Name")};
    }

    public Object getPropertyValue(Object id) {
        if (PROPERTY_ID.equals(id)) {
            return this.domain.getId();
        }
        if (PROPERTY_SUFFIX.equals(id)) {
            return this.domain.getSuffix();
        }
        if (PROPERTY_FULLNAME.equals(id)) {
            return OpenShiftResourceLabelUtils.toString((IDomain)this.domain);
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

