/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.portforward;

import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.OpenShiftSSHOperationException;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.portforward.PortForwardingWizard;
import org.jboss.tools.openshift.express.internal.ui.portforward.PortForwardingWizardModel;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;

public class PortForwardingWizardPage
extends AbstractOpenShiftWizardPage {
    private final PortForwardingWizardModel wizardModel;
    private TableViewer viewer;
    private Button refreshButton;
    private Button startButton;
    private Button stopButton;

    public PortForwardingWizardPage(PortForwardingWizardModel wizardModel, PortForwardingWizard portForwardingWizard) {
        super("Application port forwarding", null, "IApplicationPortForwardingingPage", (IWizard)portForwardingWizard);
        this.wizardModel = wizardModel;
        this.setDescription(NLS.bind((String)"Please configure port forwarding for the {0} application", (Object)wizardModel.getApplication().getName()));
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(parent);
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        Composite tableContainer = new Composite(container, 0);
        this.viewer = this.createTable(tableContainer, dbc);
        GridDataFactory.fillDefaults().span(1, 3).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        this.refreshButton = new Button(container, 8);
        this.refreshButton.setText("Refresh");
        GridDataFactory.fillDefaults().hint(110, -1).align(4, 128).applyTo((Control)this.refreshButton);
        this.refreshButton.addSelectionListener(this.onRefreshPorts());
        this.startButton = new Button(container, 8);
        this.startButton.setText("Start All");
        this.startButton.setEnabled(this.wizardModel.hasForwardablePorts());
        GridDataFactory.fillDefaults().hint(110, -1).align(4, 128).applyTo((Control)this.startButton);
        this.startButton.addSelectionListener(this.onStartPortForwarding());
        this.stopButton = new Button(container, 8);
        this.stopButton.setText("Stop All");
        this.stopButton.setEnabled(false);
        GridDataFactory.fillDefaults().hint(110, -1).align(4, 128).applyTo((Control)this.stopButton);
        this.stopButton.addSelectionListener(this.onStopPortForwarding());
        Button useLocalIpAddressButton = new Button(container, 32);
        useLocalIpAddressButton.setText("Use '127.0.0.1' as the local address for all Services");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(false, false).applyTo((Control)useLocalIpAddressButton);
        IObservableValue useLocalIpAddressObservable = BeanProperties.value((String)"useDefaultLocalIpAddress").observe((Object)this.wizardModel);
        ISWTObservableValue useLocalIpAddressButtonSelection = WidgetProperties.selection().observe((Widget)useLocalIpAddressButton);
        dbc.bindValue((IObservableValue)useLocalIpAddressButtonSelection, useLocalIpAddressObservable);
        useLocalIpAddressObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                PortForwardingWizardPage.this.refreshViewerInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
            }
        });
        Button findFreesPortButton = new Button(container, 32);
        findFreesPortButton.setText("Find free ports for all Services");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(false, false).applyTo((Control)findFreesPortButton);
        IObservableValue findFreePortsButtonObservable = BeanProperties.value((String)"useFreePorts").observe((Object)this.wizardModel);
        ISWTObservableValue findFreePortsButtonSelection = WidgetProperties.selection().observe((Widget)findFreesPortButton);
        dbc.bindValue((IObservableValue)findFreePortsButtonSelection, findFreePortsButtonObservable);
        findFreePortsButtonObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                PortForwardingWizardPage.this.refreshViewerInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
            }
        });
        IObservableValue portForwardingStartedObservable = BeanProperties.value((String)"portForwarding").observe((Object)this.wizardModel);
        IObservableValue forwardablePortsExistObservable = BeanProperties.value((String)"forwardablePorts").observe((Object)this.wizardModel);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.startButton)).notUpdating(portForwardingStartedObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.startButton)).notUpdating(forwardablePortsExistObservable).converting((IConverter)new Converter(List.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof List) {
                    return !((List)fromObject).isEmpty();
                }
                return Boolean.FALSE;
            }
        })).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.stopButton)).notUpdating(portForwardingStartedObservable).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)useLocalIpAddressButton)).notUpdating(portForwardingStartedObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)findFreesPortButton)).notUpdating(portForwardingStartedObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
    }

    private SelectionListener onRefreshPorts() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new Job("Refreshing list of ports..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                if (!PortForwardingWizardPage.this.wizardModel.verifyApplicationSSHSession()) {
                                    return Status.CANCEL_STATUS;
                                }
                                PortForwardingWizardPage.this.wizardModel.refreshForwardablePorts();
                                PortForwardingWizardPage.this.refreshViewerInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
                            }
                            catch (OpenShiftSSHOperationException e) {
                                Logger.error("Failed to refresh list of ports", e);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)PortForwardingWizardPage.this.getContainer(), (DataBindingContext)PortForwardingWizardPage.this.getDataBindingContext());
                }
                catch (Exception exception) {}
            }
        };
    }

    private SelectionListener onStartPortForwarding() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new Job("Starting Port-forwarding..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            block7: {
                                try {
                                    if (!PortForwardingWizardPage.this.wizardModel.verifyApplicationSSHSession()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    PortForwardingWizardPage.this.wizardModel.startPortForwarding();
                                    PortForwardingWizardPage.this.refreshViewerInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
                                }
                                catch (OpenShiftSSHOperationException e) {
                                    return OpenShiftUIActivator.createErrorStatus("Failed to start port-forwarding.", e);
                                }
                                try {
                                    if (PortForwardingWizardPage.this.wizardModel.getApplication().isPortFowardingStarted()) {
                                        List<IApplicationPortForwarding> forwardablePorts = PortForwardingWizardPage.this.wizardModel.getForwardablePorts();
                                        for (IApplicationPortForwarding portfwd : forwardablePorts) {
                                            if (portfwd.isStarted(PortForwardingWizardPage.this.wizardModel.getApplication().getSSHSession())) continue;
                                            return OpenShiftUIActivator.createErrorStatus("Failed to start port-forwarding for one or more ports. See console for errors.");
                                        }
                                        break block7;
                                    }
                                    return OpenShiftUIActivator.createErrorStatus("Failed to start port-forwarding. See console for errors.");
                                }
                                catch (OpenShiftSSHOperationException openShiftSSHOperationException) {
                                    return OpenShiftUIActivator.createErrorStatus("Problem checking port forward status during start. See console for errors.");
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)PortForwardingWizardPage.this.getContainer(), (DataBindingContext)PortForwardingWizardPage.this.getDataBindingContext());
                }
                catch (Exception exception) {}
            }
        };
    }

    private SelectionListener onStopPortForwarding() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new Job("Stoppping Port-forwarding..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                if (!PortForwardingWizardPage.this.wizardModel.verifyApplicationSSHSession()) {
                                    return Status.CANCEL_STATUS;
                                }
                                PortForwardingWizardPage.this.wizardModel.stopPortForwarding();
                                PortForwardingWizardPage.this.refreshViewerInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
                            }
                            catch (OpenShiftSSHOperationException e) {
                                return OpenShiftUIActivator.createErrorStatus("Failed to stop port-forwarding.", e);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)PortForwardingWizardPage.this.getContainer(), (DataBindingContext)PortForwardingWizardPage.this.getDataBindingContext());
                }
                catch (Exception exception) {}
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer, DataBindingContext dbc) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableColumn("Service", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IApplicationPortForwarding port = (IApplicationPortForwarding)cell.getElement();
                cell.setText(port.getName());
            }
        }, viewer, tableLayout);
        this.createTableColumn("Local Address", 2, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IApplicationPortForwarding port = (IApplicationPortForwarding)cell.getElement();
                cell.setText(port.getLocalAddress());
            }
        }, viewer, tableLayout);
        this.createTableColumn("Local Port", 2, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IApplicationPortForwarding port = (IApplicationPortForwarding)cell.getElement();
                cell.setText(Integer.toString(port.getLocalPort()));
            }
        }, viewer, tableLayout);
        this.createTableColumn("Remote Address", 2, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IApplicationPortForwarding port = (IApplicationPortForwarding)cell.getElement();
                cell.setText(port.getRemoteAddress());
            }
        }, viewer, tableLayout);
        this.createTableColumn("Remote Port", 2, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IApplicationPortForwarding port = (IApplicationPortForwarding)cell.getElement();
                cell.setText(Integer.toString(port.getRemotePort()));
            }
        }, viewer, tableLayout);
        this.createTableColumn("Status", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IApplicationPortForwarding port = (IApplicationPortForwarding)cell.getElement();
                try {
                    boolean started = port.isStarted(PortForwardingWizardPage.this.wizardModel.getApplication().getSSHSession());
                    cell.setText(started ? "Started" : "Stopped");
                }
                catch (OpenShiftSSHOperationException openShiftSSHOperationException) {
                    cell.setText("Unknown");
                }
            }
        }, viewer, tableLayout);
        IObservableValue forwardablePortsModelObservable = BeanProperties.value((String)"forwardablePorts").observe((Object)this.wizardModel);
        ForwardablePortListValidator validator = new ForwardablePortListValidator(forwardablePortsModelObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        return viewer;
    }

    private void createTableColumn(String name, int weight, CellLabelProvider cellLabelProvider, TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(name);
        column.setLabelProvider(cellLabelProvider);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        Job j = new Job("Loading application's forwardable ports..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Checking Application SSH session...", 1);
                    PortForwardingWizardPage.this.wizardModel.verifyApplicationSSHSession();
                    monitor.worked(1);
                    monitor.beginTask("Retrieving ports...", 1);
                    PortForwardingWizardPage.this.wizardModel.loadForwardablePorts();
                    PortForwardingWizardPage.this.refreshViewerInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
                    monitor.worked(1);
                    return Status.OK_STATUS;
                }
                catch (OpenShiftSSHOperationException e) {
                    return OpenShiftUIActivator.createErrorStatus("Could not load forwardable ports for application ''{0}''", e, PortForwardingWizardPage.this.wizardModel.getApplication().getName());
                }
            }
        };
        try {
            WizardUtils.runInWizard((Job)j, (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDataBindingContext());
        }
        catch (Exception e) {
            Logger.error("Failed to load application's forwardable ports", e);
        }
    }

    private void refreshViewerInput(List<IApplicationPortForwarding> ports) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PortForwardingWizardPage.this.viewer.setInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
                }
                catch (Exception e) {
                    Logger.error("Failed to refresh table content with list of ports for selected application", e);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return true;
    }

    class ForwardablePortListValidator
    extends MultiValidator {
        private final IObservableValue viewerObservable;

        public ForwardablePortListValidator(IObservableValue viewerObservable) {
            this.viewerObservable = viewerObservable;
        }

        protected IStatus validate() {
            List ports = (List)this.viewerObservable.getValue();
            if (ports == null || ports.isEmpty()) {
                return ValidationStatus.error((String)"There are no available ports to forward for this application.\nYour application may be stopped.");
            }
            return Status.OK_STATUS;
        }
    }
}

