/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.OpenShiftException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;

public class LoadKeysJob
extends Job {
    private Connection user;
    private List<IOpenShiftSSHKey> keys = new ArrayList<IOpenShiftSSHKey>();

    public LoadKeysJob(Connection user) {
        super("Loading SSH keys... ");
        this.user = user;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.keys = this.user.getSSHKeys();
            return Status.OK_STATUS;
        }
        catch (OpenShiftException ex) {
            return OpenShiftUIActivator.createErrorStatus(OpenShiftExpressUIMessages.COULD_NOT_LOAD_SSH_KEYS, ex);
        }
    }

    public List<IOpenShiftSSHKey> getKeys() {
        return this.keys;
    }
}

