/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.client.cartridge.query.CartridgeNameQuery;
import com.openshift.client.cartridge.query.ICartridgeQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;

public class EmbedCartridgesJob
extends AbstractDelegatingMonitorJob {
    private List<ICartridge> selectedCartridges;
    private IApplication application;
    private List<IEmbeddedCartridge> addedCartridges;

    public EmbedCartridgesJob(List<ICartridge> selectedCartridges, IApplication application) {
        super(NLS.bind((String)OpenShiftExpressUIMessages.ADDING_REMOVING_CARTRIDGES, (Object)application.getName()));
        this.selectedCartridges = selectedCartridges;
        this.application = application;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            this.removeEmbeddedCartridges(this.getRemovedCartridges(this.selectedCartridges, this.application.getEmbeddedCartridges()), this.application, monitor);
            this.addedCartridges = this.addEmbeddedCartridges(this.getAddedCartridges(this.selectedCartridges, this.application.getEmbeddedCartridges()), this.application, monitor);
            return Status.OK_STATUS;
        }
        catch (OpenShiftException e) {
            return OpenShiftUIActivator.createErrorStatus("Could not embed cartridges for application {0}", e, this.application.getName());
        }
    }

    public List<IEmbeddedCartridge> getAddedCartridges() {
        return this.addedCartridges;
    }

    private void removeEmbeddedCartridges(List<ICartridge> cartridgesToRemove, IApplication application, IProgressMonitor monitor) throws OpenShiftException {
        if (cartridgesToRemove.isEmpty()) {
            return;
        }
        Collections.sort(cartridgesToRemove, new CartridgeAddRemovePriorityComparator());
        for (ICartridge cartridgeToRemove : cartridgesToRemove) {
            if (monitor.isCanceled()) {
                return;
            }
            IEmbeddedCartridge embeddedCartridge = application.getEmbeddedCartridge(cartridgeToRemove.getName());
            if (embeddedCartridge == null) continue;
            embeddedCartridge.destroy();
        }
    }

    private List<IEmbeddedCartridge> addEmbeddedCartridges(List<ICartridge> cartridgesToAdd, IApplication application, IProgressMonitor monitor) throws OpenShiftException {
        if (cartridgesToAdd.isEmpty() || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        Collections.sort(cartridgesToAdd, new CartridgeAddRemovePriorityComparator());
        return application.addEmbeddableCartridges(cartridgesToAdd.toArray(new ICartridge[cartridgesToAdd.size()]));
    }

    private List<ICartridge> getAddedCartridges(List<ICartridge> selectedCartridges, List<IEmbeddedCartridge> embeddedCartridges) {
        ArrayList<ICartridge> cartridgesToAdd = new ArrayList<ICartridge>();
        for (ICartridge cartridge : selectedCartridges) {
            if (embeddedCartridges.contains(cartridge)) continue;
            cartridgesToAdd.add(cartridge);
        }
        return cartridgesToAdd;
    }

    private List<ICartridge> getRemovedCartridges(List<ICartridge> selectedCartridges, List<IEmbeddedCartridge> embeddedCartridges) {
        ArrayList<ICartridge> cartridgesToRemove = new ArrayList<ICartridge>();
        for (ICartridge iCartridge : embeddedCartridges) {
            if (selectedCartridges.contains(iCartridge)) continue;
            cartridgesToRemove.add(iCartridge);
        }
        return cartridgesToRemove;
    }

    private static class CartridgeAddRemovePriorityComparator
    implements Comparator<ICartridge> {
        private static final ICartridgeQuery mySqlMatcher = new CartridgeNameQuery("mysql");
        private static final ICartridgeQuery postgresqlMatcher = new CartridgeNameQuery("postgresql");
        private static final ICartridgeQuery mongodbMatcher = new CartridgeNameQuery("mongodb");

        private CartridgeAddRemovePriorityComparator() {
        }

        @Override
        public int compare(ICartridge thisCartridge, ICartridge thatCartridge) {
            if (mySqlMatcher.matches(thisCartridge)) {
                return -1;
            }
            if (mySqlMatcher.matches(thatCartridge)) {
                return 1;
            }
            if (postgresqlMatcher.matches(thisCartridge)) {
                return -1;
            }
            if (postgresqlMatcher.matches(thatCartridge)) {
                return 1;
            }
            if (mongodbMatcher.matches(thisCartridge)) {
                return -1;
            }
            if (mongodbMatcher.matches(thatCartridge)) {
                return 1;
            }
            return 0;
        }
    }
}

