/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.explorer;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.openshift.express.core.IConnectionsModelListener;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.ui.OpenshiftUIMessages;
import org.jboss.tools.openshift.express.internal.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.connection.ConnectionWizard;

public class OpenShiftExplorerView
extends CommonNavigator
implements IConnectionsModelListener {
    private Control connectionsPane;
    private Control explanationsPane;
    private PageBook pageBook;

    protected Object getInitialInput() {
        return ConnectionsModelSingleton.getInstance();
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = super.createCommonViewer(parent);
        new OpenShiftExplorerContextsHandler(viewer);
        ConnectionsModelSingleton.getInstance().addListener((IConnectionsModelListener)this);
        return viewer;
    }

    public void dispose() {
        ConnectionsModelSingleton.getInstance().removeListener((IConnectionsModelListener)this);
        super.dispose();
    }

    public void refreshViewer(final Connection connection) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CommonViewer viewer = OpenShiftExplorerView.this.getCommonViewer();
                if (DisposeUtils.isDisposed((Viewer)viewer)) {
                    return;
                }
                if (connection != null) {
                    viewer.refresh((Object)connection);
                } else {
                    viewer.refresh();
                }
                OpenShiftExplorerView.this.showConnectionsOrExplanations(OpenShiftExplorerView.this.connectionsPane, OpenShiftExplorerView.this.explanationsPane);
            }
        });
    }

    public void connectionAdded(Connection connection) {
        this.refreshViewer(null);
    }

    public void connectionRemoved(Connection connection) {
        this.refreshViewer(null);
    }

    public void connectionChanged(Connection connection) {
        this.refreshViewer(connection);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.pageBook = new PageBook(parent, 0);
        super.createPartControl((Composite)this.pageBook);
        this.connectionsPane = this.getCommonViewer().getControl();
        this.explanationsPane = this.createExplanationPane(this.connectionsPane, this.pageBook, toolkit);
        this.showConnectionsOrExplanations(this.connectionsPane, this.explanationsPane);
    }

    private Control createExplanationPane(Control connectionsPane, PageBook pageBook, FormToolkit kit) {
        Form form = kit.createForm((Composite)pageBook);
        Composite composite = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Link link = new Link(composite, 0);
        link.setText(OpenshiftUIMessages.NoConnectionsAreAvailable);
        link.setBackground(pageBook.getDisplay().getSystemColor(25));
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)this.onExplanationClicked(connectionsPane, (Control)link));
        return form;
    }

    private SelectionAdapter onExplanationClicked(final Control connectionsPane, final Control explanationPane) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizard wizard = new ConnectionWizard();
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    OpenShiftExplorerView.this.showConnectionsOrExplanations(connectionsPane, explanationPane);
                }
            }
        };
    }

    private void showConnectionsOrExplanations(Control connectionsPane, Control explanationsPane) {
        if (ConnectionsModelSingleton.getInstance().getConnections().length < 1) {
            this.pageBook.showPage(explanationsPane);
        } else {
            this.pageBook.showPage(connectionsPane);
        }
    }

    private static class Contexts {
        private IContextActivation contextActivation;

        private Contexts() {
        }

        public void activate(String contextId) {
            this.deactivateCurrent();
            IContextService service = this.getService();
            this.contextActivation = service.activateContext(contextId);
        }

        public void deactivateCurrent() {
            if (this.contextActivation != null) {
                IContextService service = this.getService();
                service.deactivateContext(this.contextActivation);
            }
        }

        private IContextService getService() {
            return (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        }
    }

    private static class OpenShiftExplorerContextsHandler
    extends Contexts {
        private static final String CONNECTION_CONTEXT = "org.jboss.tools.openshift.explorer.context.connection";
        private static final String APPLICATION_CONTEXT = "org.jboss.tools.openshift.explorer.context.application";
        private static final String DOMAIN_CONTEXT = "org.jboss.tools.openshift.explorer.context.domain";

        OpenShiftExplorerContextsHandler(CommonViewer viewer) {
            viewer.getControl().addFocusListener((FocusListener)this.onFocusLost());
            viewer.addSelectionChangedListener(this.onSelectionChanged());
        }

        private FocusAdapter onFocusLost() {
            return new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    OpenShiftExplorerContextsHandler.this.deactivateCurrent();
                }
            };
        }

        private ISelectionChangedListener onSelectionChanged() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (UIUtils.isFirstElementOfType(IDomain.class, selection)) {
                        OpenShiftExplorerContextsHandler.this.activate(OpenShiftExplorerContextsHandler.DOMAIN_CONTEXT);
                    } else if (UIUtils.isFirstElementOfType(IApplication.class, selection)) {
                        OpenShiftExplorerContextsHandler.this.activate(OpenShiftExplorerContextsHandler.APPLICATION_CONTEXT);
                    } else if (UIUtils.isFirstElementOfType(Connection.class, selection)) {
                        OpenShiftExplorerContextsHandler.this.activate(OpenShiftExplorerContextsHandler.CONNECTION_CONTEXT);
                    }
                }
            };
        }
    }
}

