/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.databinding;

import java.io.File;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredStringValidator;

public class DirectoryValidator
extends RequiredStringValidator {
    public DirectoryValidator(String fieldName) {
        super(fieldName);
    }

    @Override
    public IStatus validateString(String value) {
        File directory = new File(value);
        if (!directory.isDirectory()) {
            return ValidationStatus.error((String)NLS.bind((String)"{0} is not a directory.", (Object)value));
        }
        if (!directory.exists()) {
            return ValidationStatus.error((String)NLS.bind((String)"The directory {0} does not exist.", (Object)directory));
        }
        return ValidationStatus.ok();
    }
}

