/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.console;

import com.openshift.client.IApplication;
import com.openshift.client.IGearGroup;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;

public class TailFilesWizardPageModel
extends ObservableUIPojo {
    private static final String DEFAULT_FILE_PATTERN = "-f -n 100 */logs/*";
    public static final String PROPERTY_FILE_PATTERN = "filePattern";
    public static final String PROPERTY_GEAR_GROUPS = "gearGroups";
    public static final String PROPERTY_SELECTED_GEAR_GROUPS = "selectedGearGroups";
    private final IApplication application;
    private String filePattern = "-f -n 100 */logs/*";
    private Collection<IGearGroup> gearGroups;
    private Collection<IGearGroup> selectedGearGroups;

    public TailFilesWizardPageModel(IApplication app) {
        this.application = app;
        this.setFilePattern(this.ensureValidDefault(OpenShiftPreferences.INSTANCE.getTailFileOptions(this.application)));
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
        this.firePropertyChange(PROPERTY_FILE_PATTERN, this.filePattern, this.filePattern);
        OpenShiftPreferences.INSTANCE.saveTailFileOptions(this.application, filePattern);
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void resetFilePattern() {
        this.setFilePattern(this.ensureValidDefault(null));
    }

    private String ensureValidDefault(String filePattern) {
        if (StringUtils.isEmpty((String)filePattern)) {
            return DEFAULT_FILE_PATTERN;
        }
        return filePattern;
    }

    public IApplication getApplication() {
        return this.application;
    }

    public void loadGearGroups() {
        this.setGearGroups(this.application.getGearGroups());
    }

    public Collection<IGearGroup> getGearGroups() {
        return this.gearGroups;
    }

    public void setGearGroups(Collection<IGearGroup> gearGroups) {
        this.gearGroups = gearGroups;
        this.firePropertyChange(PROPERTY_GEAR_GROUPS, this.gearGroups, this.gearGroups);
        HashSet<IGearGroup> selectedGearGroups = new HashSet<IGearGroup>();
        for (IGearGroup gearGroup : gearGroups) {
            for (ICartridge cartridge : gearGroup.getCartridges()) {
                if (!(cartridge instanceof IStandaloneCartridge)) continue;
                selectedGearGroups.add(gearGroup);
            }
        }
        this.setSelectedGearGroups(selectedGearGroups);
    }

    public Collection<IGearGroup> getSelectedGearGroups() {
        return this.selectedGearGroups;
    }

    public void setSelectedGearGroups(Collection<IGearGroup> selectedGearGroups) {
        this.selectedGearGroups = selectedGearGroups;
        this.firePropertyChange(PROPERTY_SELECTED_GEAR_GROUPS, this.selectedGearGroups, this.selectedGearGroups);
    }

    public void selectAllGears() {
        this.setSelectedGearGroups(new HashSet<IGearGroup>(this.getGearGroups()));
    }

    public void deselectAllGears() {
        this.setSelectedGearGroups(new HashSet<IGearGroup>());
    }
}

