/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.openshift.client.IApplication;
import com.openshift.client.IGear;
import com.openshift.client.IGearGroup;
import com.openshift.client.utils.Base64Coder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.express.internal.ui.console.GearGroupsUtils;
import org.jboss.tools.openshift.express.internal.ui.console.JschToEclipseLogger;
import org.jboss.tools.openshift.express.internal.ui.console.TailFilesWizard;
import org.jboss.tools.openshift.express.internal.ui.console.TailServerLogWorker;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;

public class TailFilesHandler
extends AbstractHandler
implements IConsoleListener {
    private Map<String, TailServerLogWorker> consoleWorkers = new HashMap<String, TailServerLogWorker>();

    public TailFilesHandler() {
        ConsoleUtils.registerConsoleListener(this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            Object selectedItem = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
            if (selectedItem instanceof IServer) {
                return this.execute((IServer)selectedItem, shell);
            }
            if (selectedItem instanceof IServerModule) {
                return this.execute(((IServerModule)selectedItem).getServer(), shell);
            }
            if (selectedItem instanceof IApplication) {
                return this.execute((IApplication)selectedItem, shell);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return OpenShiftUIActivator.createErrorStatus("Could not open OpenShift console", e);
        }
    }

    private IStatus execute(IApplication application, Shell shell) {
        TailFilesWizard wizard = new TailFilesWizard(application);
        if (WizardUtils.openWizardDialog((IWizard)wizard, (Shell)shell) == 0) {
            try {
                String host = new URL(application.getApplicationUrl()).getHost();
                for (IGearGroup gearGroup : wizard.getSelectedGearGroups()) {
                    Collection gears = gearGroup.getGears();
                    String cartridgeNames = GearGroupsUtils.getCartridgeDisplayNames(gearGroup);
                    for (IGear gear : gears) {
                        MessageConsole console = ConsoleUtils.findMessageConsole(TailFilesHandler.createConsoleId(host, gear.getId(), cartridgeNames));
                        ConsoleUtils.displayConsoleView((IConsole)console);
                        if (this.consoleWorkers.containsKey(console.getName())) continue;
                        this.launchTailServerJob(gear.getSshUrl(), wizard.getFilePattern(), console);
                    }
                }
            }
            catch (MalformedURLException e) {
                return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could tail files for application {0}", (Object)application.getName()), e);
            }
        }
        return Status.OK_STATUS;
    }

    private static String createConsoleId(String host, String gearId, String cartridgeNames) {
        return String.valueOf(host) + " [" + cartridgeNames + " on gear #" + gearId + "]";
    }

    private IStatus execute(final IServer server, final Shell shell) throws MalformedURLException {
        if (!OpenShiftServerUtils.isOpenShiftRuntime((IServerAttributes)server) || !OpenShiftServerUtils.isInOpenshiftBehaviourMode((IServer)server)) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Server {0} is not an OpenShift Server Adapter", (Object)server.getName()));
        }
        final LoadApplicationJob applicationJob = new LoadApplicationJob(server);
        new JobChainBuilder((Job)applicationJob).runWhenSuccessfullyDone((Job)new UIJob("Tail files"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IApplication application = applicationJob.getApplication();
                if (application == null) {
                    return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not retrieve application for server adapter {0}", (Object)server.getName()));
                }
                return TailFilesHandler.this.execute(application, shell);
            }
        }).schedule();
        return Status.OK_STATUS;
    }

    private void launchTailServerJob(final String sshUrl, final String filePattern, final MessageConsole console) {
        new Job("Launching Tail Logs Operation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TailServerLogWorker tailServerLogWorker = TailFilesHandler.this.startTailProcess(sshUrl, filePattern, console);
                    TailFilesHandler.this.consoleWorkers.put(console.getName(), tailServerLogWorker);
                    Thread thread = new Thread(tailServerLogWorker);
                    thread.start();
                }
                catch (IOException e) {
                    return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Failed to tail files from ''{0}''", (Object)sshUrl), e);
                }
                catch (URISyntaxException e) {
                    return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Failed to tail files from ''{0}''", (Object)sshUrl), e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private TailServerLogWorker startTailProcess(String sshUrl, String optionsAndFile, MessageConsole console) throws URISyntaxException, IOException {
        JSch.setLogger((Logger)new JschToEclipseLogger());
        SshSessionFactory sshSessionFactory = SshSessionFactory.getInstance();
        URI uri = new URI(sshUrl);
        uri.getHost();
        URIish urish = new URIish().setHost(uri.getHost()).setUser(uri.getUserInfo());
        RemoteSession remoteSession = sshSessionFactory.getSession(urish, CredentialsProvider.getDefault(), FS.DETECTED, 0);
        String command = new TailCommandBuilder(optionsAndFile).build();
        org.jboss.tools.openshift.express.internal.ui.utils.Logger.debug("ssh command to execute: " + command);
        Process process = remoteSession.exec(command, 0);
        return new TailServerLogWorker(console, process, remoteSession);
    }

    public void consolesAdded(IConsole[] consoles) {
    }

    public void consolesRemoved(IConsole[] consoles) {
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            String consoleName = console.getName();
            if (this.consoleWorkers.containsKey(consoleName)) {
                TailServerLogWorker worker = this.consoleWorkers.get(consoleName);
                worker.stop();
                this.consoleWorkers.remove(consoleName);
            }
            ++n2;
        }
    }

    private class TailCommandBuilder {
        private String options;
        private String file;

        public TailCommandBuilder(String optionsAndFile) {
            this.init(optionsAndFile);
        }

        private void init(String optionsAndFile) {
            if (!StringUtils.isEmpty((String)optionsAndFile)) {
                int filePatternStart = optionsAndFile.lastIndexOf(32);
                if (filePatternStart > -1) {
                    this.options = optionsAndFile.substring(0, filePatternStart);
                    this.file = optionsAndFile.substring(filePatternStart).trim();
                } else {
                    this.file = optionsAndFile;
                }
            }
        }

        public String build() {
            StringBuilder builder = new StringBuilder("tail");
            if (this.options != null) {
                builder.append(" --opts ").append(Base64Coder.encode((String)this.options));
            }
            if (this.file != null) {
                builder.append(' ').append(this.file);
            }
            return builder.toString();
        }
    }
}

