/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.command.AbstractApplicationHandler;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.job.RestartApplicationJob;

public class RestartApplicationHandler
extends AbstractApplicationHandler {
    @Override
    protected IStatus execute(IApplication application, Shell shell) {
        if (!this.promptUserToConfirm(application.getName(), shell)) {
            return OpenShiftUIActivator.createCancelStatus("Restarting application {0} was cancelled.", application.getName());
        }
        new RestartApplicationJob(application).schedule();
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus execute(LoadApplicationJob job, Shell shell) {
        if (!this.promptUserToConfirm(job.getApplicationName(), shell)) {
            return OpenShiftUIActivator.createCancelStatus("Restarting application {0} was cancelled.", job.getApplicationName());
        }
        new JobChainBuilder((Job)job).runWhenSuccessfullyDone((Job)new RestartApplicationJob(job)).schedule();
        return Status.OK_STATUS;
    }

    private boolean promptUserToConfirm(String applicationName, Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)"Restart Application", (String)NLS.bind((String)"You are about to restart application {0}.\n\nRestarting an application in production may be harmful. Are you sure that you want to restart your application?", (Object)applicationName));
    }

    @Override
    protected String getOperationName() {
        return "restart application";
    }
}

