/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DelegatingProgressMonitor
implements IProgressMonitor {
    List<IProgressMonitor> monitors = new ArrayList<IProgressMonitor>();

    public synchronized void add(IProgressMonitor monitor) {
        this.monitors.add(0, monitor);
    }

    public synchronized void remove(IProgressMonitor monitor) {
        this.monitors.remove(monitor);
    }

    public synchronized void subTask(String name) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.subTask(name);
        }
    }

    public synchronized void beginTask(String name, int totalWork) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.beginTask(name, totalWork);
        }
    }

    public synchronized void done() {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.done();
        }
    }

    public synchronized void internalWorked(double work) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.internalWorked(work);
        }
    }

    public synchronized boolean isCanceled() {
        for (IProgressMonitor monitor : this.monitors) {
            if (!monitor.isCanceled()) continue;
            return true;
        }
        return false;
    }

    public synchronized void setCanceled(boolean value) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.setCanceled(value);
        }
    }

    public synchronized void setTaskName(String name) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.setTaskName(name);
        }
    }

    public synchronized void worked(int work) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.worked(work);
        }
    }
}

