/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.preferences.SettingsPage;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.preferences.KBPreferencesMessages;

public class KBSettingsPreferencePage
extends SettingsPage {
    public static final String ID = "org.jboss.tools.jst.web.kb.propertyPages.KBSettingsPreferencePage";
    private IProject project;
    private boolean kbEnabled;
    private boolean initialState;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        GridLayout gridLayout = new GridLayout(1, false);
        root.setLayout((Layout)gridLayout);
        Label lable = new Label(root, 0);
        lable.setText(KBPreferencesMessages.KB_DESCRIPTION);
        Composite generalGroup = new Composite(root, 0);
        generalGroup.setLayoutData((Object)gd);
        gridLayout = new GridLayout(4, false);
        generalGroup.setLayout((Layout)gridLayout);
        this.initialState = this.isKBEnabled(this.project);
        IFieldEditor kbSupportCheckBox = IFieldEditorFactory.INSTANCE.createCheckboxEditor(KBPreferencesMessages.KB_SETTINGS_PREFERENCE_PAGE_KB_SUPPORT, KBPreferencesMessages.KB_SETTINGS_PREFERENCE_PAGE_KB_SUPPORT, this.initialState);
        kbSupportCheckBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (value instanceof Boolean) {
                    boolean v = (Boolean)value;
                    KBSettingsPreferencePage.this.setEnabledKBSuport(v);
                }
            }
        });
        this.kbEnabled = this.isKBEnabled(this.project);
        this.registerEditor(kbSupportCheckBox, generalGroup);
        this.validate();
        return root;
    }

    protected void performDefaults() {
        this.getEditor(KBPreferencesMessages.KB_SETTINGS_PREFERENCE_PAGE_KB_SUPPORT).setValue((Object)this.isKBEnabled(this.project));
        this.validate();
    }

    public boolean performOk() {
        if (this.isKBEnabled() != this.initialState) {
            if (this.isKBEnabled()) {
                this.addKBSupport(this.project);
            } else {
                this.removeKBSupport(this.project);
            }
        }
        return true;
    }

    private void addKBSupport(IProject project) {
        if (project == null) {
            return;
        }
        WebKbPlugin.enableKB(project, (IProgressMonitor)new NullProgressMonitor());
    }

    private void removeKBSupport(IProject project) {
        WebKbPlugin.disableKB(project);
    }

    private boolean isKBEnabled(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.jboss.tools.jst.web.kb.kbnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isKBEnabled() {
        return this.kbEnabled;
    }

    public void setEnabledKBSuport(boolean enabled) {
        this.kbEnabled = enabled;
        ((IFieldEditor)this.editorRegistry.get(KBPreferencesMessages.KB_SETTINGS_PREFERENCE_PAGE_KB_SUPPORT)).setValue((Object)enabled);
    }

    protected void validate() {
    }

    public void dispose() {
        super.dispose();
    }
}

