/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;

public abstract class WebValidator
extends KBValidator {
    private static final String JAVA_EXT = "java";
    protected IContainer[] webRootFolders;
    protected IProject currentProject;
    protected IResource[] currentSources;
    private boolean enabled = true;

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.webRootFolders = null;
        this.currentProject = null;
    }

    protected abstract boolean shouldValidateJavaSources();

    protected boolean shouldFileBeValidated(IFile file) {
        if (!file.isAccessible()) {
            return false;
        }
        IProject project = file.getProject();
        if (!file.isSynchronized(0)) {
            return false;
        }
        if (!project.equals((Object)this.currentProject)) {
            this.currentProject = project;
            this.enabled = this.isEnabled(project);
            if (!this.enabled) {
                return false;
            }
            if (this.webRootFolders != null && this.webRootFolders.length > 0 && !project.equals((Object)this.webRootFolders[0].getProject())) {
                this.webRootFolders = null;
            }
            if (this.webRootFolders == null) {
                this.webRootFolders = WebUtils.getWebRootFolders((IProject)project);
            }
            if (this.shouldValidateJavaSources()) {
                this.currentSources = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
            }
        }
        if (!this.enabled) {
            return false;
        }
        if (this.shouldValidateJavaSources()) {
            int i = 0;
            while (this.currentSources != null && i < this.currentSources.length) {
                if (this.currentSources[i].getLocation().isPrefixOf(file.getLocation())) {
                    if (JAVA_EXT.equalsIgnoreCase(file.getFileExtension())) {
                        return EclipseUtil.getCompilationUnit((IFile)file) != null;
                    }
                    return true;
                }
                ++i;
            }
            if (JAVA_EXT.equalsIgnoreCase(file.getFileExtension())) {
                return false;
            }
        }
        if (this.webRootFolders != null) {
            IContainer[] iContainerArray = this.webRootFolders;
            int n = this.webRootFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer webRootFolder = iContainerArray[n2];
                if (webRootFolder.getLocation().isPrefixOf(file.getLocation())) {
                    return true;
                }
                ++n2;
            }
            if (this.webRootFolders.length > 1) {
                return false;
            }
        }
        return true;
    }
}

