/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.JSF2ResourcesScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.MyFacesScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;

public class LibraryScanner
implements IFileScanner {
    public static final String FILE_SYSTEMS_PATH = "FileSystems";
    public static final String FILE_SYSTEM_JAR_PATH = "FileSystemJar";
    public static final String META_INF_PATH = "META-INF";
    public static final String JAR_SUFFIX = ".jar";
    public static final String ZIP_SUFFIX = ".zip";
    IPath sourcePath = null;

    @Override
    public boolean isRelevant(IFile f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(JAR_SUFFIX) || name.endsWith(ZIP_SUFFIX);
    }

    @Override
    public boolean isLikelyComponentSource(IFile f) {
        XModelObject o;
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        boolean result = false;
        if (model != null && (o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f)) != null) {
            if (o.getModelEntity().getName().equals(FILE_SYSTEM_JAR_PATH)) {
                result = this.isLikelyComponentSource(o);
            } else {
                ((FileSystemsImpl)o.getModel().getByPath(FILE_SYSTEMS_PATH)).updateOverlapped();
                o = EclipseResourceUtil.getObjectByResource((IResource)f);
                result = o != null && o.getModelEntity().getName().equals(FILE_SYSTEM_JAR_PATH);
            }
        }
        return result;
    }

    @Override
    public LoadedDeclarations parse(IFile f, IKbProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (!o.getModelEntity().getName().equals(FILE_SYSTEM_JAR_PATH)) {
            ((FileSystemsImpl)o.getModel().getByPath(FILE_SYSTEMS_PATH)).updateOverlapped();
            o = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (o == null || !o.getModelEntity().getName().equals(FILE_SYSTEM_JAR_PATH)) {
                return null;
            }
        }
        return this.parse(o, f.getFullPath(), sp);
    }

    public boolean isLikelyComponentSource(XModelObject o) {
        if (o == null) {
            return false;
        }
        return o.getChildByPath(META_INF_PATH) != null;
    }

    public LoadedDeclarations parse(XModelObject o, IPath path, IKbProject sp) throws ScannerException {
        LoadedDeclarations ds1;
        XModelObject p;
        if (o == null) {
            return null;
        }
        this.sourcePath = path;
        XModelObject metaInf = o.getChildByPath(META_INF_PATH);
        if (metaInf == null) {
            return null;
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        if (metaInf != null) {
            XModelObject[] tlds;
            XModelObject[] xModelObjectArray = tlds = metaInf.getChildren();
            int n = tlds.length;
            int n2 = 0;
            while (n2 < n) {
                IFileScanner s;
                Map<IPath, LoadedDeclarations> ds12;
                XModelObject tld = xModelObjectArray[n2];
                if ((LibraryScanner.isFaceletTaglibFile(tld) || LibraryScanner.isTLDFile(tld) || LibraryScanner.isFacesConfigFile(tld)) && (ds12 = ((XMLScanner)(s = new XMLScanner())).parse(tld, path, sp)) != null) {
                    ds.add((LoadedDeclarations)((Object)ds12));
                }
                if (tld.getFileType() == 2 && tld.getAttributeValue("name").equals("resources")) {
                    s = new JSF2ResourcesScanner();
                    ds12 = ((JSF2ResourcesScanner)s).parse(tld, path, sp, true);
                    if (ds12 != null && ds12.size() > 0) {
                        ds.add((LoadedDeclarations)ds12.values().iterator().next());
                    }
                } else if (LibraryScanner.isMyFacesMetadata(tld) && (ds12 = ((MyFacesScanner)(s = new MyFacesScanner())).parse(tld, path, sp)) != null) {
                    ds.add((LoadedDeclarations)((Object)ds12));
                }
                ++n2;
            }
        }
        if (o.getAttributeValue("name").indexOf("jsf-impl") >= 0 && (p = o.getChildByPath("com/sun/faces/metadata")) != null && p.getFileType() == 2 && (ds1 = this.parseInPackages(p, path, sp)) != null) {
            ds.add(ds1);
        }
        return ds;
    }

    public LoadedDeclarations parseInPackages(XModelObject o, IPath path, IKbProject sp) throws ScannerException {
        XModelObject[] tlds;
        LoadedDeclarations ds = new LoadedDeclarations();
        XModelObject[] xModelObjectArray = tlds = o.getChildren();
        int n = tlds.length;
        int n2 = 0;
        while (n2 < n) {
            LoadedDeclarations ds1;
            IFileScanner s;
            XModelObject tld = xModelObjectArray[n2];
            if (LibraryScanner.isFaceletTaglibFile(tld)) {
                s = new XMLScanner();
                ds1 = ((XMLScanner)s).parse(tld, path, sp);
                ds = this.add(ds, ds1);
            } else if (tld.getFileType() == 2) {
                LoadedDeclarations ds12 = this.parseInPackages(tld, path, sp);
                ds = this.add(ds, ds12);
            } else if (LibraryScanner.isMyFacesMetadata(tld)) {
                s = new MyFacesScanner();
                ds1 = ((MyFacesScanner)s).parse(tld, path, sp);
                ds = this.add(ds, ds1);
            }
            ++n2;
        }
        return ds;
    }

    private LoadedDeclarations add(LoadedDeclarations total, LoadedDeclarations addition) {
        if (addition == null || addition.isEmpty()) {
            return total;
        }
        if (total == null) {
            total = new LoadedDeclarations();
        }
        total.add(addition);
        return total;
    }

    public static boolean isTLDFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith("FileTLD");
    }

    public static boolean isFaceletTaglibFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith("FileFaceletTaglib");
    }

    public static boolean isFacesConfigFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith("FacesConfig");
    }

    public static boolean isCompositeComponentFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith(JSF2ResourcesScanner.ENT_COMPOSITE_COMPONENT);
    }

    public static boolean isMyFacesMetadata(XModelObject o) {
        return MyFacesScanner.METADATA_FILE_NAME.equals(o.getPathPart());
    }
}

