/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.proposal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.ICSSContainerSupport;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSClassProposalType
extends CustomProposalType {
    private static final ImageDescriptor IMAGE = WebKbPlugin.getImageDescriptor(WebKbPlugin.class, "EnumerationProposal.gif");
    static String ID = "cssclass";
    static String QUOTE_1 = "'";
    static String QUOTE_2 = "\"";
    Set<String> idList = new TreeSet<String>();

    @Override
    protected void init(IPageContext context) {
        ICSSContainerSupport cssSource;
        List<PageContextFactory.CSSStyleSheetDescriptor> descrs;
        this.idList.clear();
        if (context instanceof ICSSContainerSupport && (descrs = (cssSource = (ICSSContainerSupport)((Object)context)).getCSSStyleSheetDescriptors()) != null) {
            for (PageContextFactory.CSSStyleSheetDescriptor descr : descrs) {
                CSSStyleSheet sheet = descr.getStylesheet();
                if (sheet == null) continue;
                CSSRuleList rules = sheet.getCssRules();
                int i = 0;
                while (rules != null && i < rules.getLength()) {
                    CSSRule rule = rules.item(i);
                    this.idList.addAll(CSSClassProposalType.getClassNamesFromCSSRule(rule));
                    ++i;
                }
            }
        }
    }

    public static Set<String> getClassNamesFromCSSRule(CSSRule cssRule) {
        TreeSet<String> styleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (cssRule instanceof CSSMediaRule) {
            CSSMediaRule cssMediaRule = (CSSMediaRule)cssRule;
            CSSRuleList rules = cssMediaRule.getCssRules();
            int i = 0;
            while (rules != null && i < rules.getLength()) {
                CSSRule rule = rules.item(i);
                styleNames.addAll(CSSClassProposalType.getClassNamesFromCSSRule(rule));
                ++i;
            }
            return styleNames;
        }
        if (!(cssRule instanceof CSSStyleRule)) {
            return styleNames;
        }
        String selectorText = ((CSSStyleRule)cssRule).getSelectorText();
        if (selectorText != null) {
            String[] styles;
            String[] stringArray = styles = selectorText.trim().split(",");
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String styleText = stringArray[n2];
                String[] styleWords = styleText.trim().split(" ");
                if (styleWords != null) {
                    String[] stringArray2 = styleWords;
                    int n3 = styleWords.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] anotherStyleWords;
                        String styleWord = stringArray2[n4];
                        String[] stringArray3 = anotherStyleWords = styleWord.split(":");
                        int n5 = anotherStyleWords.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String name = stringArray3[n6];
                            if (!name.contains("(")) {
                                int ind;
                                String nameWithoutArgs = name;
                                if (name.indexOf(91) >= 0) {
                                    nameWithoutArgs = name.substring(0, name.indexOf("["));
                                }
                                if (nameWithoutArgs != null && nameWithoutArgs.indexOf(".") >= 0) {
                                    ind = (nameWithoutArgs = nameWithoutArgs.substring(nameWithoutArgs.indexOf(".") + 1)).indexOf(43);
                                    if (ind != -1) {
                                        nameWithoutArgs = nameWithoutArgs.substring(0, ind);
                                    }
                                    if ((ind = nameWithoutArgs.indexOf(62)) != -1) {
                                        nameWithoutArgs = nameWithoutArgs.substring(0, ind);
                                    }
                                    styleNames.add(nameWithoutArgs);
                                }
                                if (name.lastIndexOf(93) >= 0 && (nameWithoutArgs = name.substring(name.indexOf(93) + 1)) != null && nameWithoutArgs.indexOf(".") >= 0) {
                                    ind = (nameWithoutArgs = nameWithoutArgs.substring(nameWithoutArgs.indexOf(".") + 1)).indexOf(43);
                                    if (ind != -1) {
                                        nameWithoutArgs = nameWithoutArgs.substring(0, ind);
                                    }
                                    if ((ind = nameWithoutArgs.indexOf(62)) != -1) {
                                        nameWithoutArgs = nameWithoutArgs.substring(0, ind);
                                    }
                                    styleNames.add(nameWithoutArgs);
                                }
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return styleNames;
    }

    @Override
    public TextProposal[] getProposals(KbQuery query) {
        String v = query.getStringQuery();
        int predicateLength = 0;
        while (predicateLength < v.length() && (v.charAt(predicateLength) == '\"' || v.charAt(predicateLength) == '\'')) {
            ++predicateLength;
        }
        int b = v.lastIndexOf(32);
        b = b == -1 ? v.lastIndexOf(9) : b;
        b = b == -1 ? predicateLength : b + 1;
        int e = v.length();
        String prefix = v.substring(b);
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        for (String text : this.idList) {
            if (!text.startsWith(prefix)) continue;
            TextProposal proposal = new TextProposal();
            proposal.setLabel(text);
            proposal.setReplacementString(text);
            proposal.setPosition(b + text.length() - predicateLength);
            proposal.setStart(b - predicateLength);
            proposal.setEnd(e - predicateLength);
            proposal.setImageDescriptor(IMAGE);
            proposals.add(proposal);
        }
        return proposals.toArray(new TextProposal[0]);
    }
}

