/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

public class LibraryStorage {
    private static final Set<ITagLibrary> EMPTY_SET = Collections.emptySet();
    private static final ITagLibrary[] EMPTY_LIB_ARRAY = new ITagLibrary[0];
    private Set<ITagLibrary> allLibraries = new HashSet<ITagLibrary>();
    private ITagLibrary[] allLibrariesArray = EMPTY_LIB_ARRAY;
    private Map<IPath, Set<ITagLibrary>> librariesBySource = new HashMap<IPath, Set<ITagLibrary>>();
    private Map<String, Set<ITagLibrary>> librariesByUri = new HashMap<String, Set<ITagLibrary>>();
    private Map<String, ITagLibrary[]> librariesByUriArray = new HashMap<String, ITagLibrary[]>();

    public synchronized void clear() {
        this.allLibraries.clear();
        this.allLibrariesArray = EMPTY_LIB_ARRAY;
        this.librariesBySource.clear();
        this.librariesByUri.clear();
        this.librariesByUriArray.clear();
    }

    public synchronized ITagLibrary[] getAllLibrariesArray() {
        if (this.allLibrariesArray.length == 0) {
            this.allLibrariesArray = this.allLibraries.toArray(new ITagLibrary[this.allLibraries.size()]);
        }
        return this.allLibrariesArray;
    }

    synchronized Collection<ITagLibrary> getAllLibraries() {
        ArrayList<ITagLibrary> collection = new ArrayList<ITagLibrary>();
        collection.addAll(this.allLibraries);
        return collection;
    }

    public synchronized ITagLibrary[] getLibrariesArray(String uri) {
        ITagLibrary[] result = this.librariesByUriArray.get(uri);
        if (result == null) {
            Set<ITagLibrary> libs = this.librariesByUri.get(uri);
            result = libs != null ? libs.toArray(new ITagLibrary[libs.size()]) : EMPTY_LIB_ARRAY;
            this.librariesByUriArray.put(uri, result);
        }
        return result;
    }

    public synchronized Set<ITagLibrary> getLibrariesBySource(IPath path) {
        Set<ITagLibrary> set = this.librariesBySource.get(path);
        return set != null ? set : EMPTY_SET;
    }

    public synchronized ITagLibrary[] getLibrariesArray(IPath path) {
        ITagLibrary[] result = EMPTY_LIB_ARRAY;
        Set<ITagLibrary> libs = this.librariesBySource.get(path);
        if (libs != null) {
            result = libs.toArray(new ITagLibrary[0]);
        }
        return result;
    }

    public void addLibrary(ITagLibrary f) {
        this.addLibrary(f, f.getSourcePath());
    }

    public synchronized void addLibrary(ITagLibrary f, IPath sourcePath) {
        this.allLibraries.add(f);
        this.allLibrariesArray = EMPTY_LIB_ARRAY;
        if (sourcePath != null) {
            Set<ITagLibrary> fs = this.librariesBySource.get(sourcePath);
            if (fs == null) {
                fs = new HashSet<ITagLibrary>();
                this.librariesBySource.put(sourcePath, fs);
            }
            fs.add(f);
        }
        String uri = f.getURI();
        this.librariesByUriArray.remove(uri);
        Set<ITagLibrary> ul = this.librariesByUri.get(uri);
        if (ul == null) {
            ul = new HashSet<ITagLibrary>();
            this.librariesByUri.put(uri, ul);
        }
        ul.add(f);
    }

    public synchronized void removeLibrary(ITagLibrary f) {
        this.removeLibrary(f, f.getSourcePath());
    }

    public synchronized void removeLibrary(ITagLibrary f, IPath sourcePath) {
        this.allLibraries.remove(f);
        this.allLibrariesArray = EMPTY_LIB_ARRAY;
        if (sourcePath != null) {
            Set<ITagLibrary> fs = this.librariesBySource.get(sourcePath);
            if (fs != null) {
                fs.remove(f);
            }
            if (fs.isEmpty()) {
                this.librariesBySource.remove(sourcePath);
            }
        }
        String uri = f.getURI();
        Set<ITagLibrary> ul = this.librariesByUri.get(uri);
        this.librariesByUriArray.remove(uri);
        if (ul != null) {
            ul.remove(f);
            if (ul.isEmpty()) {
                this.librariesByUri.remove(uri);
            }
        }
    }

    public synchronized Set<ITagLibrary> removePath(IPath path) {
        Set<ITagLibrary> fs = this.librariesBySource.get(path);
        if (fs == null) {
            fs = EMPTY_SET;
        } else {
            for (ITagLibrary f : fs) {
                this.allLibraries.remove(f);
                this.allLibrariesArray = EMPTY_LIB_ARRAY;
                Set<ITagLibrary> s = this.librariesByUri.get(f.getURI());
                if (s != null) {
                    s.remove(f);
                    if (s.isEmpty()) {
                        this.librariesByUri.remove(f.getURI());
                    }
                }
                this.librariesByUriArray.remove(f.getURI());
            }
            this.librariesBySource.remove(path);
        }
        return fs;
    }

    public synchronized void onCompositeTagLibrariesChange(Set<String> names) {
        for (ITagLibrary l : this.allLibraries) {
            FaceletTagLibrary f;
            String n;
            if (!(l instanceof FaceletTagLibrary) || (n = (f = (FaceletTagLibrary)l).getCompositeLibraryName()) == null || !names.contains(n)) continue;
            f.onCompositeLibraryChanged();
        }
    }
}

