/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.UniquePaths;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbMessages;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.include.IIncludeModel;
import org.jboss.tools.jst.web.kb.include.IncludeModel;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.KbBuilderMarker;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.LibraryStorage;
import org.jboss.tools.jst.web.kb.internal.NameSpaceStorage;
import org.jboss.tools.jst.web.kb.internal.StaticLibraries;
import org.jboss.tools.jst.web.kb.internal.scanner.ClassPathMonitor;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryProxy;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.myfaces.MyFacesTagLibrary;
import org.jboss.tools.jst.web.kb.require.KbRequireBuilder;
import org.jboss.tools.jst.web.kb.require.KbRequireDefinition;
import org.jboss.tools.jst.web.kb.taglib.ICompositeTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.INameSpaceStorage;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.Element;

public class KbProject
extends KbObject
implements IKbProject {
    IProject project;
    boolean isMock = false;
    ClassPathMonitor classPath = new ClassPathMonitor(this);
    Map<IPath, LoadedDeclarations> sourcePaths2 = new HashMap<IPath, LoadedDeclarations>();
    private boolean isStorageResolved = false;
    Set<KbProject> dependsOn = new HashSet<KbProject>();
    Set<KbProject> usedBy = new HashSet<KbProject>();
    LibraryStorage libraries = new LibraryStorage();
    ProjectValidationContext validationContext;
    int modifications = 0;
    Map<String, Object> extensionModels = new HashMap<String, Object>();
    IncludeModel includeModel = new IncludeModel();
    NameSpaceStorage namespacesStorage = new NameSpaceStorage(this);
    public long fullBuildTime;
    public List<Long> statistics;
    static String EXTERNAL_TOOL_BUILDER = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    private Set<IPath> sourcesInRegistering = new HashSet<IPath>();
    List<Change> postponedChanges = null;
    PathCheck pathCheck = new PathCheck();

    public void setMock() {
        this.isMock = true;
    }

    @Override
    public ITagLibrary[] getProjectTagLibraries() {
        return this.libraries.getAllLibrariesArray();
    }

    @Override
    public List<ITagLibrary> getAllTagLibraries() {
        Collection<ITagLibrary> libs = this.libraries.getAllLibraries();
        List<ITagLibrary> result = StaticLibraries.instance.getAllTagLibraries();
        result.addAll(libs);
        return result;
    }

    @Override
    public ITagLibrary[] getTagLibraries(String uri) {
        ITagLibrary[] result = this.libraries.getLibrariesArray(uri);
        if (result.length == 0) {
            result = StaticLibraries.instance.getLibraries(uri);
        }
        return result;
    }

    @Override
    public ITagLibrary[] getTagLibraries(IPath path) {
        return this.libraries.getLibrariesArray(path);
    }

    @Override
    public IIncludeModel getIncludeModel() {
        return this.includeModel;
    }

    @Override
    public INameSpaceStorage getNameSpaceStorage() {
        return this.namespacesStorage;
    }

    public void configure() throws CoreException {
        this.addToBuildSpec(KbBuilder.BUILDER_ID);
        if (this.project.getPersistentProperty(KbProjectFactory.NATURE_MOCK) != null) {
            this.project.setPersistentProperty(KbProjectFactory.NATURE_MOCK, null);
        }
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(KbBuilder.BUILDER_ID);
        this.dispose();
        this.clearStorage();
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public IKbProject getKbProject() {
        return this;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.setSourcePath(project.getFullPath());
        this.resource = project;
        this.classPath.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKbProject(KbProject p) {
        Set<KbProject> set = this.dependsOn;
        synchronized (set) {
            if (this.dependsOn.contains(p)) {
                return;
            }
        }
        this.addUsedKbProject(p);
        p.addDependentKbProject(this);
        if (!p.isStorageResolved) {
            p.resolve();
        } else {
            Map<IPath, LoadedDeclarations> map = null;
            try {
                map = p.getAllDeclarations();
            }
            catch (CloneNotSupportedException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
            for (IPath source : map.keySet()) {
                LoadedDeclarations ds = map.get(source);
                this.registerComponents(ds, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KbProject> getKbProjects() {
        HashSet<KbProject> result = new HashSet<KbProject>();
        Set<KbProject> set = this.dependsOn;
        synchronized (set) {
            result.addAll(this.dependsOn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependentKbProject(KbProject p) {
        Set<KbProject> set = this.usedBy;
        synchronized (set) {
            this.usedBy.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDependentKbProject(KbProject p) {
        Set<KbProject> set = this.usedBy;
        synchronized (set) {
            this.usedBy.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KbProject[] getDependentKbProjects() {
        Set<KbProject> set = this.usedBy;
        synchronized (set) {
            return this.usedBy.toArray(new KbProject[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUsedKbProject(KbProject p) {
        Set<KbProject> set = this.dependsOn;
        synchronized (set) {
            this.dependsOn.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUsedKbProject(KbProject p) {
        Set<KbProject> set = this.dependsOn;
        synchronized (set) {
            this.dependsOn.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKbProject(KbProject p) {
        Set<KbProject> set = this.dependsOn;
        synchronized (set) {
            if (!this.dependsOn.contains(p)) {
                return;
            }
        }
        ++this.modifications;
        p.removeDependentKbProject(this);
        this.removeUsedKbProject(p);
        IPath[] ps = null;
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            ps = this.sourcePaths2.keySet().toArray(new IPath[0]);
        }
        int i = 0;
        while (i < ps.length) {
            IPath pth = ps[i];
            if (p.getSourcePath().isPrefixOf(pth) || p.isPathLoaded(pth) && !EclipseResourceUtil.isJar((String)pth.toString())) {
                this.pathRemoved(pth);
            }
            ++i;
        }
    }

    public ClassPathMonitor getClassPath() {
        return this.classPath;
    }

    public void resolveStorage(boolean load) {
        if (this.isStorageResolved) {
            return;
        }
        if (load) {
            this.load();
        } else {
            this.loadValidationContext();
            this.isStorageResolved = true;
        }
    }

    public boolean isStorageResolved() {
        return this.isStorageResolved;
    }

    @Override
    public void resolve() {
        this.resolveStorage(true);
    }

    public void load() {
        if (this.isStorageResolved) {
            return;
        }
        this.isStorageResolved = true;
        this.postponeFiring();
        try {
            boolean b = this.getClassPath().update();
            if (b) {
                this.getClassPath().validateProjectDependencies();
            }
            File file = this.getStorageFile();
            Element root = null;
            if (file != null && file.isFile() && (root = XMLUtilities.getElement((File)file, null)) != null) {
                this.loadProjectDependencies(root);
                if (XMLUtilities.getUniqueChild((Element)root, (String)"paths") != null) {
                    this.loadSourcePaths2(root);
                }
            }
            if (b) {
                this.getClassPath().process();
            }
            if (root != null) {
                this.getValidationContext().load(root);
                this.includeModel.load(root);
                this.namespacesStorage.load(root);
            }
        }
        finally {
            this.fireChanges();
            if (this.getStorageFile() != null && this.getStorageFile().exists()) {
                this.modifications = 0;
            }
        }
    }

    void loadValidationContext() {
        File file = this.getStorageFile();
        Element root = null;
        if (file != null && file.isFile() && (root = XMLUtilities.getElement((File)file, null)) != null) {
            this.getValidationContext().load(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        File file = this.getStorageFile();
        if (file != null && file.isFile()) {
            file.delete();
        }
        this.namespacesStorage.clear();
        this.classPath.clean();
        this.postponeFiring();
        IPath[] ps = null;
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            ps = this.sourcePaths2.keySet().toArray(new IPath[0]);
        }
        int i = 0;
        while (i < ps.length) {
            this.pathRemoved(ps[i]);
            ++i;
        }
        this.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reload() {
        this.statistics = new ArrayList<Long>();
        this.classPath = new ClassPathMonitor(this);
        Set<KbProject> set = this.sourcePaths2;
        synchronized (set) {
            this.sourcePaths2.clear();
        }
        this.isStorageResolved = false;
        set = this.dependsOn;
        synchronized (set) {
            this.dependsOn.clear();
        }
        set = this.usedBy;
        synchronized (set) {
            this.usedBy.clear();
        }
        this.libraries.clear();
        long begin = System.currentTimeMillis();
        this.classPath.init();
        this.resolve();
        long end = System.currentTimeMillis();
        return end - begin;
    }

    public int getModificationsSinceLastStore() {
        return this.modifications + (this.validationContext == null ? 0 : this.validationContext.getModificationsSinceLastStore());
    }

    public void store() throws IOException {
        try {
            if (!this.project.hasNature("org.jboss.tools.jst.web.kb.kbnature")) {
                return;
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        File file = this.getStorageFile();
        if (file != null) {
            file.getParentFile().mkdirs();
            Element root = XMLUtilities.createDocumentElement((String)"kb-project");
            this.storeProjectDependencies(root);
            this.storeSourcePaths2(root);
            if (this.validationContext != null) {
                this.validationContext.store(root);
            }
            this.includeModel.store(root);
            this.namespacesStorage.store(root);
            XMLUtilities.serialize((Element)root, (String)file.getAbsolutePath());
            this.modifications = 0;
        }
    }

    private File getStorageFile() {
        WebKbPlugin plugin = WebKbPlugin.getDefault();
        if (plugin != null) {
            IPath path = plugin.getStateLocation();
            File file = new File(path.toFile(), "projects/" + this.project.getName() + ".xml");
            return file;
        }
        return null;
    }

    public void clearStorage() {
        this.getStorageFile().delete();
    }

    @Override
    public IProjectValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new ProjectValidationContext();
        }
        return this.validationContext;
    }

    private void loadProjectDependencies(Element root) {
        Element usedElement;
        Element dependsOnElement = XMLUtilities.getUniqueChild((Element)root, (String)"depends-on-projects");
        if (dependsOnElement != null) {
            Element[] paths = XMLUtilities.getChildren((Element)dependsOnElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible()) {
                    KbProject.checkKBBuilderInstalled((IResource)project);
                    KbProject sp = (KbProject)KbProjectFactory.getKbProject(project, false);
                    if (sp != null) {
                        if (sp.isMock) {
                            this.addKbProject(sp);
                        } else {
                            this.addUsedKbProject(sp);
                            sp.addDependentKbProject(this);
                        }
                    }
                }
                ++i;
            }
        }
        if ((usedElement = XMLUtilities.getUniqueChild((Element)root, (String)"used-by-projects")) != null) {
            Element[] paths = XMLUtilities.getChildren((Element)usedElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                KbProject sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = (KbProject)KbProjectFactory.getKbProject(project, false)) != null) {
                    this.addDependentKbProject(sp);
                }
                ++i;
            }
        }
    }

    private void loadSourcePaths2(Element root) {
        block25: {
            Properties context = new Properties();
            context.put("kbProject", this);
            Element sourcePathsElement = XMLUtilities.getUniqueChild((Element)root, (String)"paths");
            if (sourcePathsElement == null) {
                return;
            }
            Element[] paths = XMLUtilities.getChildren((Element)sourcePathsElement, (String)"path");
            if (paths == null) break block25;
            int i = 0;
            while (i < paths.length) {
                block26: {
                    Path path;
                    block27: {
                        String p = paths[i].getAttribute("value");
                        if (p == null || p.trim().length() == 0 || this.sourcePaths2.containsKey(path = new Path(p.trim()))) break block26;
                        if (this.getClassPath().hasPath((IPath)path)) break block27;
                        boolean ok = false;
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                        if (folder != null && folder.exists() && folder.isSynchronized(2)) {
                            ok = true;
                        } else {
                            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                            if (f != null && f.exists() && f.isSynchronized(0)) {
                                ok = true;
                            }
                        }
                        if (!ok) break block26;
                    }
                    context.put("path", path);
                    long t1 = System.currentTimeMillis();
                    LoadedDeclarations ds = new LoadedDeclarations();
                    Element libraries = XMLUtilities.getUniqueChild((Element)paths[i], (String)"libraries");
                    if (libraries != null) {
                        Element[] cs;
                        Element[] elementArray = cs = XMLUtilities.getChildren((Element)libraries, (String)"library");
                        int n = cs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Element library = elementArray[n2];
                            String cls = library.getAttribute("class");
                            AbstractTagLib tagLib = null;
                            if ("tld".equals(cls)) {
                                tagLib = new TLDLibrary();
                            } else if ("facelet".equals(cls)) {
                                tagLib = new FaceletTagLibrary();
                            } else if ("faces-config".equals(cls)) {
                                tagLib = new FacesConfigTagLibrary();
                            } else if ("composite".equals(cls)) {
                                tagLib = new CompositeTagLibrary();
                            } else if ("myfaces".equals(cls)) {
                                tagLib = new MyFacesTagLibrary();
                            }
                            if (tagLib != null && !(tagLib instanceof ICompositeTagLibrary) && !(tagLib instanceof MyFacesTagLibrary)) {
                                LibraryProxy proxy = new LibraryProxy(tagLib);
                                proxy.loadXML(library, context);
                                tagLib = proxy.getLibrary();
                            } else if (tagLib != null) {
                                ((AbstractTagLib)tagLib).loadXML(library, context);
                            }
                            if (tagLib != null) {
                                ds.getLibraries().add(tagLib);
                            }
                            ++n2;
                        }
                    }
                    this.getClassPath().pathLoaded((IPath)path);
                    this.registerComponents(ds, (IPath)path);
                    long t2 = System.currentTimeMillis();
                    if (this.statistics != null) {
                        this.statistics.add(new Long(t2 - t1));
                        if (t2 - t1 > 30L) {
                            System.out.println("--->" + this.statistics.size() + " " + (t2 - t1));
                            System.out.println("stop");
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSourcePaths2(Element root) {
        Properties context = new Properties();
        Element sourcePathsElement = XMLUtilities.createElement((Element)root, (String)"paths");
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            for (IPath path : this.sourcePaths2.keySet()) {
                IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (f != null && f.exists() && f.getProject() != this.project) continue;
                context.put("path", path);
                LoadedDeclarations ds = this.sourcePaths2.get(path);
                Element pathElement = XMLUtilities.createElement((Element)sourcePathsElement, (String)"path");
                pathElement.setAttribute("value", path.toString());
                List<ITagLibrary> fs = ds.getLibraries();
                if (fs == null || fs.isEmpty()) continue;
                Element cse = XMLUtilities.createElement((Element)pathElement, (String)"libraries");
                for (ITagLibrary d : fs) {
                    if (d instanceof ICustomTagLibrary) continue;
                    AbstractTagLib t = (AbstractTagLib)d;
                    if (!(t instanceof ICompositeTagLibrary) && !(t instanceof MyFacesTagLibrary)) {
                        LibraryProxy proxy = new LibraryProxy(t);
                        proxy.toXML(cse, context);
                        continue;
                    }
                    t.toXML(cse, context);
                }
            }
        }
    }

    private void storeProjectDependencies(Element root) {
        KbProject[] ps;
        Element dependsOnElement = XMLUtilities.createElement((Element)root, (String)"depends-on-projects");
        for (IKbProject iKbProject : this.getKbProjects()) {
            if (!iKbProject.getProject().isAccessible()) continue;
            Element pathElement = XMLUtilities.createElement((Element)dependsOnElement, (String)"project");
            pathElement.setAttribute("name", iKbProject.getProject().getName());
        }
        Element element = XMLUtilities.createElement((Element)root, (String)"used-by-projects");
        KbProject[] kbProjectArray = ps = this.getDependentKbProjects();
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            KbProject p = kbProjectArray[n2];
            if (p.getProject().isAccessible()) {
                Element pathElement = XMLUtilities.createElement((Element)element, (String)"project");
                pathElement.setAttribute("name", p.getProject().getName());
            }
            ++n2;
        }
    }

    Map<IPath, LoadedDeclarations> getAllDeclarations() throws CloneNotSupportedException {
        HashMap<IPath, LoadedDeclarations> map = new HashMap<IPath, LoadedDeclarations>();
        ITagLibrary[] iTagLibraryArray = this.getProjectTagLibraries();
        int n = iTagLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITagLibrary f = iTagLibraryArray[n2];
            IPath p = f.getSourcePath();
            if (p != null && !EclipseResourceUtil.isJar((String)p.toString())) {
                LoadedDeclarations ds = (LoadedDeclarations)map.get(p);
                if (ds == null) {
                    ds = new LoadedDeclarations();
                    map.put(p, ds);
                }
                ds.getLibraries().add(f.clone());
            }
            ++n2;
        }
        return map;
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand command = null;
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length && command == null) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
            }
            ++i;
        }
        if (command == null) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] oldCommands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            Object handle;
            String builderName = commands[i].getBuilderName();
            if (builderName.equals(builderID) || builderName.equals(EXTERNAL_TOOL_BUILDER) && (handle = commands[i].getArguments().get(LAUNCH_CONFIG_HANDLE)) != null && handle.toString().indexOf(builderID) >= 0) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComponents(LoadedDeclarations ds, IPath source) {
        source = UniquePaths.getInstance().intern(source);
        boolean isThisProject = this.pathCheck.isThisProject(source);
        ITagLibrary[] libraries = ds.getLibraries().toArray(new ITagLibrary[0]);
        if (libraries.length == 0) {
            this.pathRemoved(source);
            if (EclipseResourceUtil.isJar((String)source.toString())) {
                Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
                synchronized (map) {
                    this.sourcePaths2.put(source, ds);
                }
            }
            return;
        }
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            this.sourcePaths2.put(source, ds);
        }
        Map<Object, ITagLibrary> currentLibraries = this.findLibraryDeclarations(source);
        List addedLibraries = null;
        ITagLibrary[] iTagLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            ITagLibrary library = iTagLibraryArray[n2];
            AbstractTagLib loaded = (AbstractTagLib)library;
            AbstractTagLib current = (AbstractTagLib)currentLibraries.remove(loaded.getId());
            loaded.setSourcePath(source);
            if (current != null && current.getClass() != loaded.getClass()) {
                this.libraries.removeLibrary(current);
                current = null;
            }
            if (current != null) {
                boolean uriChanged;
                boolean bl = uriChanged = !this.stringsEqual(current.getURI(), loaded.getURI());
                if (uriChanged) {
                    this.libraries.removeLibrary(current);
                }
                List<Change> changes = current.merge(loaded);
                if (uriChanged) {
                    this.libraries.addLibrary(current);
                }
                this.fireChanges(changes, isThisProject);
            } else {
                if (((KbObject)((Object)library)).getParent() == null) {
                    this.adopt((KbObject)((Object)library));
                }
                this.libraries.addLibrary(library);
                addedLibraries = Change.addChange(addedLibraries, (Change)new Change((Object)this, null, null, (Object)loaded));
            }
            ++n2;
        }
        this.fireChanges(addedLibraries, isThisProject);
        this.libraryDeclarationsRemoved(currentLibraries);
        try {
            this.registerComponentsInDependentProjects(ds, source);
        }
        catch (CloneNotSupportedException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComponentsInDependentProjects(LoadedDeclarations ds, IPath source) throws CloneNotSupportedException {
        Set<KbProject> set = this.usedBy;
        synchronized (set) {
            if (this.usedBy.isEmpty()) {
                return;
            }
        }
        if (EclipseResourceUtil.isJar((String)source.toString())) {
            return;
        }
        if (this.sourcesInRegistering.contains(source)) {
            return;
        }
        set = this.sourcesInRegistering;
        synchronized (set) {
            this.sourcesInRegistering.add(source);
        }
        try {
            KbProject[] ps;
            KbProject[] kbProjectArray = ps = this.getDependentKbProjects();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                KbProject p = kbProjectArray[n2];
                if (!p.sourcesInRegistering.contains(source)) {
                    p.resolve();
                    LoadedDeclarations ds1 = new LoadedDeclarations();
                    for (ITagLibrary f : ds.getLibraries()) {
                        ds1.getLibraries().add(f.clone());
                    }
                    p.registerComponents(ds1, source);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Set<IPath> set2 = this.sourcesInRegistering;
            synchronized (set2) {
                this.sourcesInRegistering.remove(source);
            }
            throw throwable;
        }
        Set<IPath> set3 = this.sourcesInRegistering;
        synchronized (set3) {
            this.sourcesInRegistering.remove(source);
        }
    }

    public boolean isPathLoaded(IPath source) {
        return this.sourcePaths2.containsKey(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathRemoved(IPath source) {
        if (!this.sourcePaths2.containsKey(source)) {
            return;
        }
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            this.sourcePaths2.remove(source);
        }
        List changes = null;
        Set<ITagLibrary> ls = this.libraries.removePath(source);
        for (ITagLibrary l : ls) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)l, null));
            if (l.getResource() == null || l.getResource().getProject() != this.project) continue;
            ++this.modifications;
        }
        this.fireChanges(changes, false);
        this.firePathRemovedToDependentProjects(source);
    }

    public void updateChildPaths(IPath path, Collection<IPath> cs) {
        IPath[] ps;
        IPath[] iPathArray = ps = this.sourcePaths2.keySet().toArray(new IPath[this.sourcePaths2.keySet().size()]);
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            if (!cs.contains(p) && !p.equals((Object)path) && path.isPrefixOf(p)) {
                this.pathRemoved(p);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePathRemovedToDependentProjects(IPath source) {
        KbProject[] ps;
        Set<KbProject> set = this.usedBy;
        synchronized (set) {
            if (this.usedBy.isEmpty()) {
                return;
            }
        }
        if (EclipseResourceUtil.isJar((String)source.toString())) {
            return;
        }
        KbProject[] kbProjectArray = ps = this.getDependentKbProjects();
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            KbProject p = kbProjectArray[n2];
            p.resolve();
            p.pathRemoved(source);
            ++n2;
        }
    }

    public Map<Object, ITagLibrary> findLibraryDeclarations(IPath source) {
        HashMap<Object, ITagLibrary> map = new HashMap<Object, ITagLibrary>();
        Set<ITagLibrary> fs = this.libraries.getLibrariesBySource(source);
        for (ITagLibrary c : fs) {
            KbObject ci = (KbObject)((Object)c);
            map.put(ci.getId(), c);
        }
        return map;
    }

    void libraryDeclarationsRemoved(Map<Object, ITagLibrary> removed) {
        if (removed == null || removed.isEmpty()) {
            return;
        }
        List changes = null;
        for (ITagLibrary c : removed.values()) {
            this.libraries.removeLibrary(c);
            changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)c, null));
        }
        this.fireChanges(changes, false);
    }

    public void postponeFiring() {
        if (this.postponedChanges == null) {
            this.postponedChanges = new ArrayList<Change>();
        }
    }

    public void fireChanges() {
        if (this.postponedChanges == null) {
            return;
        }
        List<Change> changes = this.postponedChanges;
        this.postponedChanges = null;
        this.fireChanges(changes, false);
    }

    void fireChanges(List<Change> changes, boolean increaseModification) {
        if (changes == null || changes.isEmpty()) {
            return;
        }
        if (increaseModification) {
            ++this.modifications;
        }
        if (this.postponedChanges != null) {
            this.postponedChanges.addAll(changes);
            return;
        }
        Set<String> compositeNames = this.collectChangedCompositeTagLibraries(changes);
        if (!compositeNames.isEmpty()) {
            this.libraries.onCompositeTagLibrariesChange(compositeNames);
        }
    }

    private Set<String> collectChangedCompositeTagLibraries(List<Change> changes) {
        HashSet<String> result = new HashSet<String>();
        for (Change c : changes) {
            int i;
            CompositeTagLibrary l;
            String uri;
            Object o = c.getTarget();
            if (o == this) {
                if (c.getOldValue() != null) {
                    o = c.getOldValue();
                }
                if (c.getNewValue() != null) {
                    o = c.getNewValue();
                }
            }
            if (!(o instanceof CompositeTagLibrary) || (uri = (l = (CompositeTagLibrary)o).getURI()) == null || (i = uri.lastIndexOf(47)) <= 0) continue;
            result.add(uri.substring(i + 1));
        }
        return result;
    }

    private static String[] getKBBuilderRequiredNatureDescriptions(IProject project) {
        ArrayList<String> natureDescriptions = new ArrayList<String>();
        try {
            List<KbRequireDefinition> definitions = KbRequireBuilder.getInstance().getKbRequireDefinitions();
            if (definitions == null) {
                return natureDescriptions.toArray(new String[0]);
            }
            for (KbRequireDefinition def : definitions) {
                String forNature = def.getNatureId();
                if (project.getNature(forNature) == null) continue;
                String description = def.getDescription();
                if (description == null) {
                    description = forNature;
                }
                natureDescriptions.add(description);
            }
        }
        catch (CoreException ex) {
            WebKbPlugin.getDefault().logError(ex);
        }
        return natureDescriptions.toArray(new String[0]);
    }

    public static boolean checkKBBuilderInstalled(IResource resource) {
        IMarker m;
        int n;
        IMarker[] markers;
        IProject project;
        IProject iProject = project = resource == null || !resource.isAccessible() ? null : resource.getProject();
        if (project == null || !project.isAccessible()) {
            return false;
        }
        String[] descriptions = KbProject.getKBBuilderRequiredNatureDescriptions(project);
        if (descriptions == null || descriptions.length == 0) {
            return true;
        }
        StringBuffer natures = new StringBuffer();
        int i = 0;
        while (i < descriptions.length) {
            if (i > 0) {
                if (i != descriptions.length - 1) {
                    natures.append(KbMessages.KBNATURE_SEPARATOR).append(' ');
                } else {
                    natures.append(' ').append(KbMessages.KBNATURE_LAST_SEPARATOR).append(' ');
                }
            }
            natures.append(descriptions[i]);
            ++i;
        }
        boolean kbNatureFound = false;
        boolean kbBuilderFound = false;
        try {
            kbNatureFound = project.getNature("org.jboss.tools.jst.web.kb.kbnature") != null;
            IProjectDescription description = project.getDescription();
            Object command = null;
            ICommand[] commands = description.getBuildSpec();
            int i2 = 0;
            while (i2 < commands.length && command == null) {
                if (commands[i2].getBuilderName().equals(KbBuilder.BUILDER_ID)) {
                    kbBuilderFound = true;
                    break;
                }
                ++i2;
            }
        }
        catch (CoreException ex) {
            WebKbPlugin.getDefault().logError(ex);
        }
        if (kbNatureFound && kbBuilderFound) {
            markers = KbBuilderMarker.getOwnedMarkers((IResource)project, 1);
            if (markers != null && markers.length > 0) {
                try {
                    IMarker[] iMarkerArray = markers;
                    n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        m = iMarkerArray[n2];
                        m.delete();
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    WebKbPlugin.getDefault().logError(ex);
                }
            }
            return true;
        }
        markers = KbBuilderMarker.getOwnedMarkers((IResource)project, 1);
        if (markers == null || markers.length == 0) {
            try {
                KbProject.createOrUpdateKbProblemMarker(null, (IResource)project, !kbNatureFound, !kbBuilderFound, natures.toString());
            }
            catch (CoreException ex) {
                WebKbPlugin.getDefault().logError(ex);
            }
        } else {
            IMarker[] iMarkerArray = markers;
            n = markers.length;
            int n3 = 0;
            while (n3 < n) {
                m = iMarkerArray[n3];
                try {
                    m = KbProject.createOrUpdateKbProblemMarker(m, (IResource)project, !kbNatureFound, !kbBuilderFound, natures.toString());
                }
                catch (CoreException ex) {
                    WebKbPlugin.getDefault().logError(ex);
                }
                ++n3;
            }
        }
        return false;
    }

    private static IMarker createOrUpdateKbProblemMarker(IMarker m, IResource r, boolean kbNatureIsAbsent, boolean kbBuilderIsAbsent, String natures) throws CoreException {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer arg = new StringBuffer();
        if (kbNatureIsAbsent) {
            arg.append(KbMessages.KBNATURE_NOT_FOUND);
        }
        if (kbBuilderIsAbsent) {
            if (kbNatureIsAbsent) {
                arg.append('/');
            }
            arg.append(KbMessages.KBBUILDER_NOT_FOUND);
        }
        args.add(arg.toString());
        args.add(natures);
        String message = MessageFormat.format(KbMessages.KBPROBLEM, args.toArray());
        return KbBuilderMarker.createOrUpdateKbProblemMarker(m, r, message, 1);
    }

    public void printModifications() {
        System.out.println(this.project.getName());
        System.out.println("" + this.modifications);
        if (this.validationContext != null) {
            System.out.println("validationContext " + this.validationContext.getModificationsSinceLastStore());
        }
    }

    public Object getExtensionModel(String id) {
        return this.extensionModels.get(id);
    }

    public void setExtensionModel(String id, Object model) {
        this.extensionModels.put(id, model);
    }

    public void dispose() {
        for (KbProject p : this.getKbProjects()) {
            this.removeKbProject(p);
        }
        KbProject[] kbProjectArray = this.getDependentKbProjects();
        int n = kbProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            KbProject p;
            p = kbProjectArray[n2];
            p.removeKbProject(this);
            ++n2;
        }
        ++this.modifications;
    }

    class PathCheck {
        Map<IPath, Boolean> paths = new HashMap<IPath, Boolean>();

        PathCheck() {
        }

        public boolean isThisProject(IPath path) {
            Boolean b = this.paths.get(path);
            if (b == null) {
                if (path != null && path.toString().endsWith(".jar")) {
                    b = true;
                } else {
                    IFile f = path.segmentCount() < 2 ? null : ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    b = f == null || !f.exists() || f.getProject() == KbProject.this.project;
                }
                this.paths.put(path, b);
            }
            return b;
        }
    }
}

