/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.include;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.include.IIncludeModel;
import org.jboss.tools.jst.web.kb.include.PageInclude;
import org.w3c.dom.Element;

public class IncludeModel
implements IIncludeModel {
    private Map<IPath, List<PageInclude>> directReferences = new HashMap<IPath, List<PageInclude>>();
    private Map<IPath, List<PageInclude>> parentReferences = new HashMap<IPath, List<PageInclude>>();
    static final String STORE_ELEMENT_INCLUDES = "includes";
    static final String STORE_ELEMENT_PAGE = "page";
    static final String STORE_ELEMENT_INCLUDE = "include";
    static final String STORE_ELEMENT_VAR = "var";
    static final String STORE_ATTR_PATH = "path";
    static final String STORE_ATTR_NAME = "name";
    static final String STORE_ATTR_VALUE = "value";
    static final String STORE_ATTR_OFFSET = "off";
    static final String STORE_ATTR_LENGTH = "len";
    static final String STORE_ELEMENT_ALIASES = "aliases";
    static final String STORE_ELEMENT_ALIAS = "alias";

    @Override
    public synchronized void clean(IPath path) {
        List<PageInclude> old = this.directReferences.remove(path);
        if (old != null && !old.isEmpty()) {
            for (IPath child : this.parentReferences.keySet()) {
                Iterator<PageInclude> is = this.parentReferences.get(child).iterator();
                while (is.hasNext()) {
                    PageInclude i = is.next();
                    if (!i.getParent().equals((Object)path)) continue;
                    is.remove();
                }
            }
        }
    }

    @Override
    public synchronized void addInclude(IPath path, PageInclude include) {
        List<PageInclude> current = this.directReferences.get(path);
        if (current == null) {
            current = new ArrayList<PageInclude>();
            this.directReferences.put(path, current);
        }
        current.add(include);
        IPath child = include.getPath();
        List<PageInclude> is = this.parentReferences.get(child);
        if (is == null) {
            is = new ArrayList<PageInclude>();
            this.parentReferences.put(child, is);
        }
        is.add(include);
    }

    @Override
    public synchronized List<Var> getVars(IPath path) {
        ArrayList<Var> result = new ArrayList<Var>();
        List<PageInclude> is = this.parentReferences.get(path);
        if (is != null) {
            for (PageInclude i : is) {
                result.addAll(i.getVars());
            }
        }
        return result;
    }

    public synchronized void store(Element root) {
        HashMap<String, String> pathAliases = new HashMap<String, String>();
        Map<String, String> available = this.loadAliases(root);
        for (Map.Entry<String, String> e : available.entrySet()) {
            pathAliases.put(e.getValue(), e.getKey());
        }
        Element includes = XMLUtilities.createElement((Element)root, (String)STORE_ELEMENT_INCLUDES);
        for (IPath path : this.directReferences.keySet()) {
            if (!ResourcesPlugin.getWorkspace().getRoot().getFile(path).exists()) continue;
            Element page = XMLUtilities.createElement((Element)includes, (String)STORE_ELEMENT_PAGE);
            String pathAlias = ELReference.getAlias(pathAliases, (String)path.toString());
            page.setAttribute(STORE_ATTR_PATH, pathAlias);
            List<PageInclude> is = this.directReferences.get(path);
            for (PageInclude i : is) {
                Element includeElement = XMLUtilities.createElement((Element)page, (String)STORE_ELEMENT_INCLUDE);
                String pathAlias1 = ELReference.getAlias(pathAliases, (String)i.getPath().toString());
                includeElement.setAttribute(STORE_ATTR_PATH, pathAlias1);
                List<Var> vars = i.getVars();
                for (Var var : vars) {
                    Element varElement = XMLUtilities.createElement((Element)includeElement, (String)STORE_ELEMENT_VAR);
                    varElement.setAttribute(STORE_ATTR_NAME, var.getName());
                    varElement.setAttribute(STORE_ATTR_VALUE, var.getValue());
                    varElement.setAttribute(STORE_ATTR_OFFSET, "" + var.getDeclarationOffset());
                    varElement.setAttribute(STORE_ATTR_LENGTH, "" + var.getDeclarationLength());
                }
            }
        }
        Element aliases = XMLUtilities.getUniqueChild((Element)root, (String)STORE_ELEMENT_ALIASES);
        if (aliases == null) {
            aliases = XMLUtilities.createElement((Element)root, (String)STORE_ELEMENT_ALIASES);
        } else {
            for (Map.Entry<String, String> e : available.entrySet()) {
                pathAliases.remove(e.getValue());
            }
        }
        for (String path : pathAliases.keySet()) {
            String value = (String)pathAliases.get(path);
            Element alias = XMLUtilities.createElement((Element)aliases, (String)STORE_ELEMENT_ALIAS);
            alias.setAttribute(STORE_ATTR_PATH, path);
            alias.setAttribute(STORE_ATTR_VALUE, value);
        }
    }

    public synchronized void load(Element root) {
        Element[] pages;
        Map<String, String> pathAliases = this.loadAliases(root);
        Element includes = XMLUtilities.getUniqueChild((Element)root, (String)STORE_ELEMENT_INCLUDES);
        if (includes == null) {
            return;
        }
        Element[] elementArray = pages = XMLUtilities.getChildren((Element)includes, (String)STORE_ELEMENT_PAGE);
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Element page = elementArray[n2];
            String spath = page.getAttribute(STORE_ATTR_PATH);
            if (spath != null && spath.trim().length() != 0) {
                Element[] is;
                spath = ELReference.getPath(pathAliases, (String)spath);
                Path path = new Path(spath);
                this.clean((IPath)path);
                Element[] elementArray2 = is = XMLUtilities.getChildren((Element)page, (String)STORE_ELEMENT_INCLUDE);
                int n3 = is.length;
                int n4 = 0;
                while (n4 < n3) {
                    Element includeElement = elementArray2[n4];
                    ArrayList<Var> vars = new ArrayList<Var>();
                    String path1 = includeElement.getAttribute(STORE_ATTR_PATH);
                    if (path1 != null && path1.trim().length() != 0) {
                        Element[] vs;
                        Element[] elementArray3 = vs = XMLUtilities.getChildren((Element)includeElement, (String)STORE_ELEMENT_VAR);
                        int n5 = vs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Element v = elementArray3[n6];
                            String name = v.getAttribute(STORE_ATTR_NAME);
                            String value = v.getAttribute(STORE_ATTR_VALUE);
                            int offset = 0;
                            int length = 0;
                            if (v.hasAttribute(STORE_ATTR_OFFSET)) {
                                try {
                                    offset = Integer.parseInt(v.getAttribute(STORE_ATTR_OFFSET));
                                }
                                catch (NumberFormatException e) {
                                    WebKbPlugin.getDefault().logError(e);
                                }
                            }
                            if (v.hasAttribute(STORE_ATTR_LENGTH)) {
                                try {
                                    length = Integer.parseInt(v.getAttribute(STORE_ATTR_LENGTH));
                                }
                                catch (NumberFormatException e) {
                                    WebKbPlugin.getDefault().logError(e);
                                }
                            }
                            Var var = new Var(ELParserUtil.getJbossFactory(), name, value, offset, length);
                            if (path.segmentCount() > 1) {
                                var.setFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path));
                            }
                            vars.add(var);
                            ++n6;
                        }
                        path1 = ELReference.getPath(pathAliases, (String)path1);
                        this.addInclude((IPath)path, new PageInclude((IPath)path, (IPath)new Path(path1), vars));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    Map<String, String> loadAliases(Element root) {
        HashMap<String, String> pathAliases = new HashMap<String, String>();
        Element aliases = XMLUtilities.getUniqueChild((Element)root, (String)STORE_ELEMENT_ALIASES);
        if (aliases != null) {
            Element[] aliasArray;
            Element[] elementArray = aliasArray = XMLUtilities.getChildren((Element)aliases, (String)STORE_ELEMENT_ALIAS);
            int n = aliasArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element alias = elementArray[n2];
                String path = alias.getAttribute(STORE_ATTR_PATH);
                String value = alias.getAttribute(STORE_ATTR_VALUE);
                pathAliases.put(value, path);
                ++n2;
            }
        }
        return pathAliases;
    }
}

