/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IExclusiblePartitionerRecognition;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLElementAttributeNameHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer,
IExclusiblePartitionerRecognition {
    public static final String XML_ATTRIBUTE_NAME_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_ATTRIBUTE_NAME";

    protected String getPartitionType() {
        return XML_ATTRIBUTE_NAME_PARTITION;
    }

    @Override
    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = n instanceof IDOMAttr ? ((IDOMAttr)n).getNameRegionStartOffset() : -1;
            int end = n instanceof IDOMAttr ? ((IDOMAttr)n).getNameRegionEndOffset() : -1;
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType();
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(start, end - start, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    @Override
    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            int end;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (!(n instanceof Attr)) {
                return false;
            }
            int start = n instanceof IDOMAttr ? ((IDOMAttr)n).getNameRegionStartOffset() : -1;
            int n2 = end = n instanceof IDOMAttr ? ((IDOMAttr)n).getNameRegionEndOffset() : -1;
            return start >= 0 && start <= offset && end >= offset;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    @Override
    public boolean excludes(String partitionType, IDocument document, int offset, IHyperlinkRegion superRegion) {
        return false;
    }

    @Override
    public String getExclusionPartitionType() {
        return this.getPartitionType();
    }
}

