/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;

public abstract class RelativeLinkHyperlink
extends AbstractHyperlink {
    @Override
    protected void doHyperlink(IRegion region) {
        try {
            String fileName = this.getFilePath(region);
            IFile fileToOpen = this.getFileFromProject(fileName);
            if (fileToOpen != null && fileToOpen.exists()) {
                IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)fileToOpen, (boolean)true);
            } else {
                this.openFileFailed();
            }
        }
        catch (CoreException coreException) {
            this.openFileFailed();
        }
    }

    private String getFilePath(IRegion region) {
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String updateFilenameForModel(String filename, IProject project) {
        return filename;
    }

    @Override
    protected IFile getFileFromProject(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return null;
        }
        IFile documentFile = this.getFile();
        IProject project = documentFile.getProject();
        return super.getFileFromProject(this.updateFilenameForModel(fileName, project));
    }

    @Override
    public String getHyperlinkText() {
        String filePath = this.getFilePath(this.getHyperlinkRegion());
        if (filePath == null) {
            return MessageFormat.format(Messages.OpenA, Messages.File);
        }
        return MessageFormat.format(Messages.OpenFile, filePath);
    }
}

