/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.model;

import com.eclipsesource.json.JsonValue;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.feedhenry.ui.FHPlugin;

public class FeedHenryApplication {
    public static final String APP_TYPE_CORDOVA_ADVANCED = "client_advanced_hybrid";
    private String guid;
    private String title;
    private String type;
    private String repoUrl;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String id) {
        this.guid = id;
    }

    public String getEclipseProjectName() {
        return this.getTitle();
    }

    public IProject findEclipseProject() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IFile f = project.getFile("www/fhconfig.json");
            if (f.isAccessible()) {
                try {
                    InputStreamReader reader = new InputStreamReader(f.getContents());
                    JsonValue value = JsonValue.readFrom((Reader)reader);
                    String appid = value.asObject().get("appid").asString();
                    if (appid.equals(this.getGuid())) {
                        return project;
                    }
                }
                catch (Exception e) {
                    FHPlugin.log(4, NLS.bind((String)"Error while parsing fhconfig.json on project {0}", (Object)project.getName()), e);
                }
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "[FeedHenry Application: " + this.title + " ]";
    }

    public boolean equals(Object obj) {
        if (this.guid != null && obj instanceof FeedHenryApplication) {
            FeedHenryApplication that = (FeedHenryApplication)obj;
            return this.guid.equals(that.getGuid());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.guid != null) {
            return this.guid.hashCode();
        }
        return super.hashCode();
    }
}

