/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.model;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryException;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;
import org.jboss.tools.feedhenry.ui.model.HttpUtil;

public class FeedHenry {
    private URL fhURL;
    private String apikey;

    public FeedHenry setFeedHenryURL(URL url) {
        this.fhURL = url;
        return this;
    }

    public FeedHenry setAPIKey(String key) {
        this.apikey = key;
        return this;
    }

    public List<FeedHenryProject> listProjects() throws FeedHenryException {
        String json = this.doAPICall("/box/api/projects");
        if (json == null) {
            return null;
        }
        JsonValue value = JsonValue.readFrom((String)json);
        if (value.isArray()) {
            ArrayList<FeedHenryProject> projects = new ArrayList<FeedHenryProject>();
            JsonArray array = value.asArray();
            int i = 0;
            while (i < array.size()) {
                FeedHenryProject fhp = new FeedHenryProject();
                JsonObject project = array.get(i).asObject();
                fhp.setTitle(project.get("title").asString());
                fhp.setGuid(project.get("guid").asString());
                JsonArray apps = project.get("apps").asArray();
                ArrayList<FeedHenryApplication> fhapps = new ArrayList<FeedHenryApplication>();
                int j = 0;
                while (j < apps.size()) {
                    JsonObject app = apps.get(j).asObject();
                    FeedHenryApplication fha = new FeedHenryApplication();
                    fha.setTitle(app.get("title").asString());
                    fha.setType(app.get("type").asString());
                    fha.setRepoUrl(app.get("internallyHostedRepoUrl").asString());
                    fha.setGuid(app.get("guid").asString());
                    fhapps.add(fha);
                    ++j;
                }
                fhp.setApplications(fhapps);
                projects.add(fhp);
                ++i;
            }
            return projects;
        }
        return null;
    }

    private String doAPICall(String api) throws FeedHenryException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(httpClient);
        HttpGet get = new HttpGet(String.valueOf(this.fhURL.toString()) + api);
        get.addHeader("X-FH-AUTH-USER", this.apikey);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            String json = new String(baos.toByteArray());
            if (status != 200) {
                throw new FeedHenryException(status, response.getStatusLine().getReasonPhrase());
            }
            return json;
        }
        catch (IOException e) {
            FeedHenryException fe = new FeedHenryException("Error occured while communicating with the FeedHenry server");
            fe.initCause(e);
            throw fe;
        }
    }
}

