/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class FHErrorHandler {
    public static final int ERROR_INVALID_PREFERENCES = 10;
    public static final int ERROR_UNAUTHORIZED = 401;

    public static boolean handle(Throwable e) {
        if (e instanceof InvocationTargetException) {
            Throwable cause = e.getCause();
            return FHErrorHandler.handle(cause);
        }
        if (e instanceof CoreException) {
            CoreException ce = (CoreException)e;
            return FHErrorHandler.handle(ce.getStatus());
        }
        if (e instanceof TransportException) {
            FHErrorHandler.displayGitTransportMessage(e.getMessage());
            Status s = new Status(1, "org.jboss.tools.feedhenry.ui", e.getMessage(), e);
            StatusManager.getManager().handle((IStatus)s, 1);
            return false;
        }
        Status s = new Status(4, "org.jboss.tools.feedhenry.ui", e.getMessage(), e);
        return FHErrorHandler.handle((IStatus)s);
    }

    public static boolean handle(IStatus status) {
        int code = status.getCode();
        switch (code) {
            case 401: {
                return FHErrorHandler.displayPreferences("Unauthorized", "You are not authorized to complete this action. This may indicate a problem with your API key. Would you like to correct it on preferences now ?");
            }
            case 10: {
                return FHErrorHandler.displayPreferences("Invalid Preferences", "FeedHenry connection preferences are undefined or invalid. Correct preferences now?");
            }
        }
        StatusManager.getManager().handle(status);
        return false;
    }

    private static boolean displayPreferences(String title, String message) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        boolean define = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
        if (define) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.jboss.tools.feedhenry.ui.FeedHenryPreferences", null, null);
            dialog.open();
            return true;
        }
        return false;
    }

    private static void displayGitTransportMessage(String message) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openError((Shell)shell, (String)"Git Communication Error", (String)"Problem when cloning the application. This can be due to a network problem or missing security credentials. Refer to error log for details.");
    }
}

