/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordova.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngineManager;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.wizard.project.HybridProjectCreator;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.jboss.tools.feedhenry.ui.cordova.internal.FHApplicationSelectionPage;
import org.jboss.tools.feedhenry.ui.internal.FHErrorHandler;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;

public class CordovaImportWizard
extends Wizard
implements IImportWizard {
    private static final String DIALOG_SETTINGS_KEY = "FeedHenryCordovaImportWizard";
    private FHApplicationSelectionPage page;
    private IStructuredSelection currentSelection;

    public CordovaImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(FHPlugin.getImageDescriptor("org.jboss.tools.feedhenry.ui", "/icons/wizban/fh_wizban.png"));
        IDialogSettings wbSettings = FHPlugin.getDefault().getDialogSettings();
        IDialogSettings section = wbSettings.getSection(DIALOG_SETTINGS_KEY);
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Import");
        this.currentSelection = selection;
    }

    public void addPages() {
        super.addPages();
        this.page = new FHApplicationSelectionPage(this.currentSelection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        List<FeedHenryApplication> apps = this.page.getSelectedApplications();
        try {
            final ArrayList<CloneOperation> ops = new ArrayList<CloneOperation>();
            for (FeedHenryApplication feedHenryApplication : apps) {
                ImportProjectTask pct = new ImportProjectTask(feedHenryApplication);
                URIish uri = new URIish(feedHenryApplication.getRepoUrl());
                IPath workpath = new Path(this.page.getWorkingPath()).append(feedHenryApplication.getEclipseProjectName());
                CloneOperation op = new CloneOperation(uri, true, null, workpath.toFile(), "master", "origin", 60);
                op.addPostCloneTask((CloneOperation.PostCloneTask)pct);
                ops.add(op);
            }
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Clone FeedHenry Application", (int)ops.size());
                    for (CloneOperation cloneOperation : ops) {
                        if (sm.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        cloneOperation.run((IProgressMonitor)sm.newChild(1));
                    }
                    sm.done();
                }
            });
        }
        catch (Exception e) {
            FHErrorHandler.handle(e);
            return false;
        }
        this.savePageSettings();
        return true;
    }

    private void addToWorkingSets(IProject project) {
        IWorkingSet[] selectedWorkingSets = this.page.getSelectedWorkingSets();
        if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
    }

    private void savePageSettings() {
        IDialogSettings section = this.getDialogSettings();
        if (section == null) {
            IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
            section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            if (section == null) {
                section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            }
            this.setDialogSettings(section);
        }
        this.page.saveWidgetValues();
    }

    private void openAndSelectConfigFile(IProject project) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HybridProject hp = HybridProject.getHybridProject((IProject)project);
        IFile file = hp.getConfigFile();
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        }
        catch (PartInitException e) {
            FHPlugin.log(4, "Error opening the config.xml", e);
        }
    }

    private void importProject(FeedHenryApplication app, File location, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        HybridProjectCreator projectCreator = new HybridProjectCreator();
        IProject project = projectCreator.createProject(app.getEclipseProjectName(), location.toURI(), app.getTitle(), app.getTitle(), HybridMobileEngineManager.getDefaultEngine(), monitor);
        this.addToWorkingSets(project);
        this.openAndSelectConfigFile(project);
    }

    private class ImportProjectTask
    implements CloneOperation.PostCloneTask {
        private FeedHenryApplication fhapp;

        public ImportProjectTask(FeedHenryApplication app) {
            this.fhapp = app;
        }

        public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
            CordovaImportWizard.this.importProject(this.fhapp, repository.getWorkTree(), monitor);
        }
    }
}

