/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.ui.SeamGuiPlugin;

public class SelectJavaPackageAction
extends ButtonFieldEditor.ButtonPressedAction {
    public SelectJavaPackageAction() {
        super(SeamCoreMessages.SELECT_SEAM_PROJECT_ACTION_BROWSE);
    }

    public void run() {
        IJavaProject javaProject;
        String projectName = (String)this.getFieldEditor().getData((Object)"seam.project.name");
        if (projectName == null) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            SeamGuiPlugin.getPluginLog().logError("Can't find java project with name: " + projectName);
            return;
        }
        SeamProjectsSet seamPrjSet = new SeamProjectsSet(project);
        IProject ejbProject = seamPrjSet.getEjbProject();
        if (ejbProject != null) {
            project = ejbProject;
        }
        if ((javaProject = EclipseResourceUtil.getJavaProject((IProject)project)) == null) {
            SeamGuiPlugin.getPluginLog().logError("Can't find java project with name: " + projectName);
            return;
        }
        IPackageFragmentRoot packageFragmentRoot = null;
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    packageFragmentRoot = roots[i];
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
        if (packageFragmentRoot == null) {
            packageFragmentRoot = javaProject.getPackageFragmentRoot(javaProject.getResource());
        }
        if (packageFragmentRoot == null) {
            SeamGuiPlugin.getPluginLog().logError("Can't find src folder for project " + projectName);
            return;
        }
        Object[] packages = null;
        try {
            packages = packageFragmentRoot.getChildren();
        }
        catch (JavaModelException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        String initialValue = this.getFieldEditor().getValue().toString();
        IJavaElement initialElement = null;
        ArrayList<IJavaElement> packagesWithoutDefaultPackage = new ArrayList<IJavaElement>();
        Object[] objectArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement packageElement = objectArray[n2];
            String packageName = packageElement.getElementName();
            if (packageName.length() > 0) {
                packagesWithoutDefaultPackage.add(packageElement);
                if (packageName.equals(initialValue)) {
                    initialElement = packageElement;
                }
            }
            ++n2;
        }
        packages = packagesWithoutDefaultPackage.toArray(new IJavaElement[packagesWithoutDefaultPackage.size()]);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_TITLE);
        dialog.setMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_DESC);
        dialog.setEmptyListMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_MSG_NONE);
        dialog.setElements(packages);
        if (initialElement != null) {
            dialog.setInitialSelections(new Object[]{initialElement});
        }
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            if (fragment != null) {
                this.getFieldEditor().setValue((Object)fragment.getElementName());
            } else {
                this.getFieldEditor().setValue((Object)"");
            }
        }
    }
}

