/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.progress.WorkbenchJob;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.proxy.SettingsProxy;
import org.jboss.tools.hibernate.spi.IConfiguration;
import org.jboss.tools.seam.ui.internal.reveng.JDBCTablesColumnsReader;
import org.jboss.tools.seam.ui.internal.reveng.TablesColumnsCollector;

public class DBTablesViewer
extends TreeViewer {
    private String connectionErrorMessage = "Couldn't connect to Database";
    private Image catalog = EclipseImages.getImageDescriptor((String)"DATABASE").createImage();
    private Image schema = EclipseImages.getImageDescriptor((String)"SCHEMA").createImage();
    private Image table = EclipseImages.getImageDescriptor((String)"TABLE").createImage();

    public DBTablesViewer(Tree tree) {
        super(tree);
        this.setContentProvider((IContentProvider)this.createContentProvider());
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
    }

    public DBTablesViewer(Composite parent) {
        super(parent);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){
            private IConfiguration cfg = null;
            private SettingsProxy buildSettings = null;
            private String placeHolder = "Pending...";
            private String conErrorItem;
            private final Object[] NO_CHILDREN;
            private static final int BEGIN_STATE = 0;
            private static final int CHILDREN_FETCHED = 1;
            private static final int CONNECTION_ERROR = 2;
            private static final int LOADING_IN_PROGRESS = 3;
            private int connectionState;
            private TablesColumnsCollector tablesCollector;
            {
                this.conErrorItem = String.valueOf('<') + DBTablesViewer.this.connectionErrorMessage + '>';
                this.NO_CHILDREN = new Object[0];
                this.connectionState = 0;
            }

            private Object[] getCatalogs() {
                if (this.connectionState == 3) {
                    return new String[]{this.placeHolder};
                }
                if (this.connectionState == 2) {
                    return new String[]{DBTablesViewer.this.connectionErrorMessage};
                }
                List catalogNames = this.tablesCollector.getCatalogNames();
                Object[] catalogs = new Element[catalogNames.size()];
                int i = 0;
                while (i < catalogs.length) {
                    String catalogName = (String)catalogNames.get(i);
                    if (catalogName == null || "".equals(catalogName)) {
                        catalogName = null;
                    }
                    catalogs[i] = new Catalog(catalogName);
                    ++i;
                }
                return catalogs;
            }

            private Object[] getSchemas(Catalog catalog) {
                List schemaNames = this.tablesCollector.getMatchingSchemaNames(catalog.getName(), this.buildSettings.getDefaultSchemaName());
                Object[] schemas = new Element[schemaNames.size()];
                int i = 0;
                while (i < schemaNames.size()) {
                    String schemaName = (String)schemaNames.get(i);
                    if (schemaName == null || "".equals(schemaName)) {
                        schemaName = null;
                    }
                    schemas[i] = new Schema(schemaName, catalog);
                    ++i;
                }
                return schemas;
            }

            private Object[] getTables(Schema schema) {
                List tableNames = this.tablesCollector.getMatchingTablesNames(schema.getParent().getName(), schema.getName(), "");
                Object[] tables = new Table[tableNames.size()];
                int i = 0;
                while (i < tables.length) {
                    tables[i] = new Table((String)tableNames.get(i));
                    tables[i].setCatalog(schema.getParent().getName());
                    tables[i].setSchema(schema.getName());
                    ++i;
                }
                return tables;
            }

            public Object[] getChildren(Object parent) {
                if (parent instanceof Catalog) {
                    return this.getSchemas((Catalog)parent);
                }
                if (parent instanceof Schema) {
                    Schema schema = (Schema)parent;
                    return this.getTables(schema);
                }
                return this.NO_CHILDREN;
            }

            public Object getParent(Object element) {
                if (element instanceof Schema) {
                    return ((Schema)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object parent) {
                return parent instanceof Element;
            }

            public Object[] getElements(Object inputElement) {
                if (this.buildSettings == null) {
                    return new String[]{this.conErrorItem};
                }
                if (this.connectionState == 0) {
                    this.tablesCollector = new TablesColumnsCollector(true);
                    if (this.connectionState == 0) {
                        this.connectionState = 3;
                    }
                    WorkbenchJob job = new WorkbenchJob("Fetching database structure"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                MetaDataDialect realMetaData = JDBCReaderFactory.newMetaDataDialect((Dialect)buildSettings.getTarget().getDialect(), (Properties)cfg.getProperties());
                                JDBCTablesColumnsReader reader = new JDBCTablesColumnsReader(realMetaData, buildSettings.getConnectionProvider(), buildSettings.getTarget().getSQLExceptionConverter());
                                reader.readDatabaseTables(tablesCollector, buildSettings.getDefaultCatalogName(), buildSettings.getDefaultSchemaName());
                                connectionState = 1;
                            }
                            catch (JDBCException jDBCException) {
                                connectionState = 2;
                            }
                            DBTablesViewer.this.remove(placeHolder);
                            DBTablesViewer.this.refresh();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                return this.getCatalogs();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput == oldInput && this.connectionState != 2) {
                    return;
                }
                if (newInput instanceof ConsoleConfiguration) {
                    ConsoleConfiguration cc = (ConsoleConfiguration)newInput;
                    try {
                        cc.build();
                        this.cfg = cc.getConfiguration();
                        cc.getExecutionContext().execute(new ExecutionContext.Command(){

                            public Object execute() {
                                SettingsProxy newSettings = (SettingsProxy)cfg.buildSettings();
                                if (!newSettings.equals(buildSettings)) {
                                    buildSettings = newSettings;
                                    connectionState = 0;
                                }
                                return null;
                            }
                        });
                    }
                    catch (HibernateException hibernateException) {
                        this.connectionState = 2;
                    }
                }
            }
        };
    }

    protected LabelProvider createLabelProvider() {
        return new LabelProvider(){

            public void dispose() {
                DBTablesViewer.this.catalog.dispose();
                DBTablesViewer.this.schema.dispose();
                DBTablesViewer.this.table.dispose();
            }

            public Image getImage(Object element) {
                if (element instanceof Catalog) {
                    return DBTablesViewer.this.catalog;
                }
                if (element instanceof Schema) {
                    return DBTablesViewer.this.schema;
                }
                if (element instanceof Table) {
                    return DBTablesViewer.this.table;
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof Element) {
                    return ((Element)element).getLabel();
                }
                if (element instanceof Table) {
                    return ((Table)element).getName();
                }
                return super.getText(element);
            }
        };
    }

    public void setConnectionErrorMessage(String connectionErrorMessage) {
        this.connectionErrorMessage = connectionErrorMessage;
    }

    public class Catalog
    extends Element {
        public static final String DEF_CATALOG_NAME = "<Default catalog>";

        Catalog(String name) {
            super(name);
            this.defaultLabel = DEF_CATALOG_NAME;
        }
    }

    public class Element {
        private String name;
        protected String defaultLabel;

        Element(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.name == null ? this.defaultLabel : this.name;
        }
    }

    public class Schema
    extends Element {
        public static final String DEF_SCHEMA_NAME = "<Default schema>";
        private Catalog parent;

        Schema(String name, Catalog parent) {
            super(name);
            this.parent = parent;
            this.defaultLabel = DEF_SCHEMA_NAME;
        }

        public Catalog getParent() {
            return this.parent;
        }
    }
}

