/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.internal.project.facet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.internal.project.facet.DataModelSynchronizer;
import org.jboss.tools.seam.ui.internal.project.facet.DataModelValidatorDelegate;
import org.jboss.tools.seam.ui.wizard.SeamFormWizard;
import org.jboss.tools.seam.ui.wizard.SeamProjectWizard;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;

public class SeamInstallWizardPage
extends AbstractFacetWizardPage
implements IFacetWizardPage,
IDataModelListener {
    public static final String PAGE_DESCRIPTION = SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_CONFIGURE_SEAM_FACET_SETTINGS;
    private static final DriverClassHelpers HIBERNATE_HELPER = new DriverClassHelpers();
    private IDataModel model = null;
    private DataModelValidatorDelegate validatorDelegate;
    private IFieldEditor jBossSeamHomeEditor;
    private IFieldEditor ejbProjectNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("seam.ejb.project", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_EJB_PROJECT_NAME, "");
    private IFieldEditor earProjectNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("seam.ear.project", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_EAR_PROJECT_NAME, "");
    private IFieldEditor libraryListEditor;
    private IFieldEditor jBossAsDeployAsEditor = IFieldEditorFactory.INSTANCE.createRadioEditor("seam.project.deployment.type", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_DEPLOY_AS, Arrays.asList("war".toUpperCase(), "ear".toUpperCase()), Arrays.asList("war", "ear"), (Object)"war");
    private IFieldEditor connProfileSelEditor;
    private IFieldEditor jBossHibernateDbTypeEditor;
    private IFieldEditor dbSchemaName;
    private IFieldEditor dbCatalogName;
    private IFieldEditor dbTablesExists;
    private IFieldEditor recreateTablesOnDeploy;
    private IFieldEditor sessionBeanPkgNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("action.package", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_SESSION_BEAN_PACKAGE_NAME, "");
    private IFieldEditor entityBeanPkgNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("model.package", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_ENTITY_BEAN_PACKAGE_NAME, "");
    private IFieldEditor createTestProjectCheckboxeditor = IFieldEditorFactory.INSTANCE.createCheckboxEditor("seam.test.project.creating", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_CREATE_TEST_PROJECT, true);
    private IFieldEditor testProjectNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("seam.test.project", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_TEST_PROJECT_NAME, "");
    private IFieldEditor testsPkgNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("test.package", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_TEST_PACKAGE_NAME, "");
    private Group databaseGroup;
    private DataModelSynchronizer sync;
    private String jpaConnectioProfile;
    private boolean needToShowConnectionProfile = true;

    public SeamInstallWizardPage() {
        super(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_FACET);
        this.setTitle(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_FACET);
        this.setImageDescriptor(ImageDescriptor.createFromFile(SeamFormWizard.class, (String)"SeamWebProjectWizBan.png"));
        this.setDescription(PAGE_DESCRIPTION);
    }

    private String getDefaultDbType() {
        return SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.hibernate.default.db.type");
    }

    private Object getDeployAsDefaultValue() {
        String result = SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.project.default.deployment.type");
        if (!this.isSeamProjectWizard()) {
            IProjectFacetVersion webVersion = null;
            if (this.isWebProjectWizard()) {
                IFacetedProjectWorkingCopy facetedProject = ((ModifyFacetedProjectWizard)this.getWizard()).getFacetedProjectWorkingCopy();
                webVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            } else {
                IFacetedProject facetedProject;
                ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
                IProject project = SeamWizardUtils.getInitialProject(sel);
                if (project == null) {
                    return "war";
                }
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject == null) {
                        return "war";
                    }
                }
                catch (CoreException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    return result;
                }
                webVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            }
            if (webVersion != null) {
                return "war";
            }
            return "ear";
        }
        return result;
    }

    private Object getConnectionProfileDefaultValue() {
        String defaultDs = SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.project.facet.default.conn.profile");
        return SeamInstallWizardPage.getConnectionProfileNameList().contains(defaultDs) ? defaultDs : "";
    }

    private static List<String> getConnectionProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
    }

    public void setConfig(Object config) {
        this.model = (IDataModel)config;
        this.model.setProperty("hibernate.dialect", (Object)HIBERNATE_HELPER.getDialectClass(this.getDefaultDbType()));
    }

    public IDataModel getConfig() {
        return this.model;
    }

    public void transferStateToConfig() {
        String seamRuntimeName = this.jBossSeamHomeEditor.getValueAsString();
        SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(seamRuntimeName);
        if (seamRuntime != null) {
            SeamRuntimeManager.getInstance().setDefaultRuntime(seamRuntime);
        }
        if (this.connProfileSelEditor != null) {
            SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.project.facet.default.conn.profile", this.connProfileSelEditor.getValueAsString());
        } else {
            SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.project.facet.default.conn.profile", this.getJpaConnectionProfile());
            this.model.setStringProperty("seam.project.connection.profile", this.getJpaConnectionProfile());
        }
        if (this.jBossHibernateDbTypeEditor != null) {
            SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.hibernate.default.db.type", this.jBossHibernateDbTypeEditor.getValueAsString());
        }
        SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.project.default.deployment.type", this.jBossAsDeployAsEditor.getValueAsString());
        this.model.setBooleanProperty("seam.templates.copying", this.isSeamProjectWizard() || this.isWebProjectWizard());
        this.model.setBooleanProperty("seam.runtime.libraries.copying", this.libraryListEditor.getValueAsString().equals(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_COPY_LIBRARIES) && (this.isSeamProjectWizard() || this.isWebProjectWizard()));
    }

    private IProjectFacetVersion getJpaFacetVersion() {
        IFacetedProjectWorkingCopy facetedProject = ((ModifyFacetedProjectWizard)this.getWizard()).getFacetedProjectWorkingCopy();
        return facetedProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jpt.jpa"));
    }

    public void setJpaConnectionProfile(String jpaConnectioProfile) {
        this.jpaConnectioProfile = jpaConnectioProfile;
    }

    private String getJpaConnectionProfile() {
        if (this.jpaConnectioProfile != null) {
            return this.jpaConnectioProfile;
        }
        IProjectFacetVersion jpaVersion = this.getJpaFacetVersion();
        if (jpaVersion == null) {
            throw new NullPointerException("Jpa facet version is null");
        }
        try {
            Object config = this.context.getConfig(jpaVersion, IFacetedProject.Action.Type.INSTALL, this.context.getProjectName());
            if (config instanceof IDataModel) {
                return ((IDataModel)config).getStringProperty("JpaFacetDataModelProperties.CONNECTION");
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    protected void registerEditor(IFieldEditor editor, Composite parent, int columns) {
        this.sync.register(editor);
        editor.doFillIntoGrid((Object)parent);
    }

    public List<String> getRuntimeNames(String version) {
        SeamRuntime[] rts = SeamRuntimeManager.getInstance().getRuntimes(SeamVersion.parseFromString((String)version));
        ArrayList<String> result = new ArrayList<String>();
        SeamRuntime[] seamRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime seamRuntime = seamRuntimeArray[n2];
            result.add(seamRuntime.getName());
            ++n2;
        }
        return result;
    }

    public void createControl(Composite parent) {
        this.sync = new DataModelSynchronizer(this.model);
        this.jBossSeamHomeEditor = SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(new SeamVersion[0], SeamFacetInstallDataModelProvider.getSeamRuntimeDefaultValue((IDataModel)this.model), new NewSeamRuntimeAction());
        this.initializeDialogUnits((Control)parent);
        Composite root = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        GridLayout gridLayout = new GridLayout(1, false);
        root.setLayout((Layout)gridLayout);
        Group generalGroup = new Group(root, 0);
        generalGroup.setLayoutData((Object)gd);
        generalGroup.setText(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_GENERAL);
        gridLayout = new GridLayout(3, false);
        generalGroup.setLayout((Layout)gridLayout);
        this.registerEditor(this.jBossSeamHomeEditor, (Composite)generalGroup, 3);
        this.jBossSeamHomeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Boolean testProject = SeamInstallWizardPage.this.canTestProjectBeCreated();
                SeamInstallWizardPage.this.createTestProjectCheckboxeditor.setValue((Object)testProject);
                SeamInstallWizardPage.this.createTestProjectCheckboxeditor.setEnabled(testProject.booleanValue());
            }
        });
        Object deployAs = this.getDeployAsDefaultValue();
        this.jBossAsDeployAsEditor.setValue(deployAs);
        this.registerEditor(this.jBossAsDeployAsEditor, (Composite)generalGroup, 3);
        this.registerEditor(this.ejbProjectNameditor, (Composite)generalGroup, 3);
        this.ejbProjectNameditor.setEnabled(deployAs.equals("ear"));
        this.registerEditor(this.earProjectNameditor, (Composite)generalGroup, 3);
        this.earProjectNameditor.setEnabled(deployAs.equals("ear"));
        ArrayList<String> providers = new ArrayList<String>();
        providers.add(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_COPY_LIBRARIES);
        providers.add(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_CONFIGURE_LATER);
        this.libraryListEditor = IFieldEditorFactory.INSTANCE.createComboEditor("seam.runtime.library.provider", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_LIBRARIES, providers, providers.get(0));
        this.registerEditor(this.libraryListEditor, (Composite)generalGroup, 3);
        this.jBossAsDeployAsEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Boolean value = SeamInstallWizardPage.this.jBossAsDeployAsEditor.getValue() == "ear";
                if (!SeamInstallWizardPage.this.isWebProjectWizard()) {
                    SeamInstallWizardPage.this.ejbProjectNameditor.setEnabled(value.booleanValue());
                    SeamInstallWizardPage.this.earProjectNameditor.setEnabled(value.booleanValue());
                }
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        this.databaseGroup = new Group(root, 0);
        this.databaseGroup.setLayoutData((Object)gd);
        this.databaseGroup.setText(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE);
        gridLayout = new GridLayout(4, false);
        this.databaseGroup.setLayout((Layout)gridLayout);
        this.jBossHibernateDbTypeEditor = IFieldEditorFactory.INSTANCE.createComboEditor("database.type", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE_TYPE, Arrays.asList(HIBERNATE_HELPER.getDialectNames()), (Object)this.getDefaultDbType(), false);
        this.registerEditor(this.jBossHibernateDbTypeEditor, (Composite)this.databaseGroup, 4);
        this.createDatabaseGoupControl();
        Group generationGroup = new Group(root, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        generationGroup.setLayoutData((Object)gd);
        generationGroup.setText(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_CODE_GENERATION);
        gridLayout = new GridLayout(3, false);
        generationGroup.setLayout((Layout)gridLayout);
        this.registerEditor(this.sessionBeanPkgNameditor, (Composite)generationGroup, 3);
        this.registerEditor(this.entityBeanPkgNameditor, (Composite)generationGroup, 3);
        this.registerEditor(this.createTestProjectCheckboxeditor, (Composite)generationGroup, 3);
        this.createTestProjectCheckboxeditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Boolean value = (Boolean)SeamInstallWizardPage.this.createTestProjectCheckboxeditor.getValue();
                SeamInstallWizardPage.this.testsPkgNameditor.setEnabled(value.booleanValue());
                SeamInstallWizardPage.this.testProjectNameditor.setEnabled(value.booleanValue());
            }
        });
        this.registerEditor(this.testProjectNameditor, (Composite)generationGroup, 3);
        this.registerEditor(this.testsPkgNameditor, (Composite)generationGroup, 3);
        if (!this.isSeamProjectWizard()) {
            this.createTestProjectCheckboxeditor.setValue((Object)false);
            this.createTestProjectCheckboxeditor.setEnabled(false);
            this.testProjectNameditor.setEnabled(false);
            this.testsPkgNameditor.setEnabled(false);
            if (!this.isWebProjectWizard()) {
                this.libraryListEditor.setValue(providers.get(1));
                this.libraryListEditor.setEnabled(false);
            }
        }
        if (this.isWebProjectWizard()) {
            this.ejbProjectNameditor.setValue((Object)"");
            this.ejbProjectNameditor.setEnabled(false);
            this.earProjectNameditor.setValue((Object)"");
            this.earProjectNameditor.setEnabled(false);
        }
        this.setControl((Control)root);
        if (this.validatorDelegate == null) {
            this.validatorDelegate = new DataModelValidatorDelegate(this.model, (WizardPage)this);
            this.validatorDelegate.addValidatorForProperty(this.jBossSeamHomeEditor.getName(), SeamValidatorFactory.SEAM_RUNTIME_NAME_VALIDATOR);
            this.validatorDelegate.addValidatorForProperty(this.connProfileSelEditor.getName(), SeamValidatorFactory.CONNECTION_PROFILE_VALIDATOR);
            this.validatorDelegate.addValidatorForProperty(this.testsPkgNameditor.getName(), new PackageNameValidator(this.testsPkgNameditor.getName(), "tests"));
            this.validatorDelegate.addValidatorForProperty(this.entityBeanPkgNameditor.getName(), new PackageNameValidator(this.entityBeanPkgNameditor.getName(), "entity beans"));
            this.validatorDelegate.addValidatorForProperty(this.sessionBeanPkgNameditor.getName(), new PackageNameValidator(this.sessionBeanPkgNameditor.getName(), "session beans"));
            if (this.isSeamProjectWizard()) {
                this.validatorDelegate.addValidatorForProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", new ProjectNamesDuplicationValidator("IFacetDataModelProperties.FACET_PROJECT_NAME"));
            }
            this.validatorDelegate.addValidatorForProperty("seam.project.deployment.type", this.getDeploymentTypeValidator(this.getWizard()));
            this.validatorDelegate.addValidatorForProperty("seam.ear.project", new ProjectNamesDuplicationValidator("seam.ear.project"));
            this.validatorDelegate.addValidatorForProperty("seam.ejb.project", new ProjectNamesDuplicationValidator("seam.ejb.project"));
            this.validatorDelegate.addValidatorForProperty("seam.test.project", new ProjectNamesDuplicationValidator("seam.test.project"));
        }
        Dialog.applyDialogFont((Control)parent);
        this.initDefaultWizardProperties();
        Object parentDm = this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (parentDm != null) {
            ((IDataModel)parentDm).addListener((IDataModelListener)this);
        }
    }

    public void createDatabaseGoupControl() {
        this.disposeControls(this.connProfileSelEditor);
        this.disposeControls(this.dbSchemaName);
        this.disposeControls(this.dbCatalogName);
        this.disposeControls(this.dbTablesExists);
        this.disposeControls(this.recreateTablesOnDeploy);
        if (!this.needToShowConnectionProfile) {
            this.connProfileSelEditor = null;
            this.dbSchemaName = null;
            this.dbCatalogName = null;
        } else {
            this.connProfileSelEditor = SeamWizardFactory.createConnectionProfileSelectionFieldEditor(this.getConnectionProfileDefaultValue(), new IValidator(){

                public Map<String, IStatus> validate(Object value, Object context) {
                    SeamInstallWizardPage.this.validate();
                    return SeamValidatorFactory.NO_ERRORS;
                }
            });
            this.dbSchemaName = IFieldEditorFactory.INSTANCE.createTextEditor("hibernate.default_schema", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE_SCHEMA_NAME, "");
            this.dbCatalogName = IFieldEditorFactory.INSTANCE.createTextEditor("hibernate.default_catalog", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE_CATALOG_NAME, "");
            this.jBossHibernateDbTypeEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SeamInstallWizardPage.this.model.setProperty("hibernate.dialect", (Object)HIBERNATE_HELPER.getDialectClass(evt.getNewValue().toString()));
                }
            });
            this.registerEditor(this.connProfileSelEditor, (Composite)this.databaseGroup, 4);
            this.registerEditor(this.dbSchemaName, (Composite)this.databaseGroup, 4);
            this.registerEditor(this.dbCatalogName, (Composite)this.databaseGroup, 4);
        }
        this.dbTablesExists = IFieldEditorFactory.INSTANCE.createCheckboxEditor("database.exists", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_DB_TABLES_ALREADY_EXISTS, false);
        this.recreateTablesOnDeploy = IFieldEditorFactory.INSTANCE.createCheckboxEditor("database.drop", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_RECREATE_DATABASE_TABLES_AND_DATA_ON_DEPLOY, false);
        this.registerEditor(this.dbTablesExists, (Composite)this.databaseGroup, 4);
        this.registerEditor(this.recreateTablesOnDeploy, (Composite)this.databaseGroup, 4);
        this.databaseGroup.getParent().layout(true);
    }

    private void disposeControls(IFieldEditor editor) {
        if (editor != null) {
            Object[] controls = editor.getEditorControls();
            int i = 0;
            while (i < controls.length) {
                Control control = (Control)controls[i];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++i;
            }
            editor.dispose();
        }
    }

    private boolean isSeamProjectWizard() {
        return this.getWizard() instanceof SeamProjectWizard;
    }

    private boolean isWebProjectWizard() {
        IWizard wizard = this.getWizard();
        if (wizard != null) {
            return wizard.getClass().equals(WebProjectWizard.class);
        }
        return false;
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            this.model.setStringProperty("seam.project.web.root.folder", event.getProperty().toString());
        } else if (event.getPropertyName().equals("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
            String seamProjectName = event.getProperty().toString();
            this.model.setStringProperty("project.name", seamProjectName);
            this.sessionBeanPkgNameditor.setValue((Object)this.getSessionPkgName(seamProjectName));
            this.entityBeanPkgNameditor.setValue((Object)this.getEntityPkgName(seamProjectName));
            this.testsPkgNameditor.setValue((Object)this.getTestPkgName(seamProjectName));
            if (!this.isWebProjectWizard()) {
                this.ejbProjectNameditor.setValue((Object)this.getEJBProjectName(seamProjectName));
                this.earProjectNameditor.setValue((Object)this.getEARProjectName(seamProjectName));
            }
            this.testProjectNameditor.setValue((Object)this.getTestProjectName(seamProjectName));
            this.model.setStringProperty("action.package", this.getSessionPkgName(seamProjectName));
            this.model.setStringProperty("model.package", this.getEntityPkgName(seamProjectName));
            this.model.setProperty("seam.test.project.creating", this.createTestProjectCheckboxeditor.getValue());
            this.model.setStringProperty("test.package", this.getTestPkgName(seamProjectName));
            this.model.setStringProperty("seam.ear.project", this.earProjectNameditor.getValueAsString());
            this.model.setStringProperty("seam.ejb.project", this.ejbProjectNameditor.getValueAsString());
            this.model.setStringProperty("seam.test.project", this.testProjectNameditor.getValueAsString());
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean jpaFacetAdded;
            this.setCodeGenerationProperties();
            this.setDefaultSeamRuntime();
            boolean bl = jpaFacetAdded = this.getJpaFacetVersion() != null;
            if (jpaFacetAdded == this.needToShowConnectionProfile) {
                this.needToShowConnectionProfile = !jpaFacetAdded;
                this.createDatabaseGoupControl();
            }
            if (!this.needToShowConnectionProfile) {
                this.model.setStringProperty("seam.project.connection.profile", this.getJpaConnectionProfile());
            }
            this.validate();
        }
        super.setVisible(visible);
    }

    private void initDefaultWizardProperties() {
        this.setCodeGenerationProperties();
        this.setDefaultSeamRuntime();
        this.validate();
    }

    private void setCodeGenerationProperties() {
        String seamProjectName = this.model.getStringProperty("project.name");
        if (seamProjectName == null) {
            return;
        }
        if ("".equals(this.sessionBeanPkgNameditor.getValueAsString())) {
            this.sessionBeanPkgNameditor.setValue((Object)this.getSessionPkgName(seamProjectName));
        }
        if ("".equals(this.entityBeanPkgNameditor.getValueAsString())) {
            this.entityBeanPkgNameditor.setValue((Object)this.getEntityPkgName(seamProjectName));
        }
        if ("".equals(this.testsPkgNameditor.getValueAsString())) {
            this.testsPkgNameditor.setValue((Object)this.getTestPkgName(seamProjectName));
        }
        if (!this.isWebProjectWizard()) {
            if ("".equals(this.ejbProjectNameditor.getValueAsString())) {
                this.ejbProjectNameditor.setValue((Object)this.getEJBProjectName(seamProjectName));
            }
            if ("".equals(this.earProjectNameditor.getValueAsString())) {
                this.earProjectNameditor.setValue((Object)this.getEARProjectName(seamProjectName));
            }
        }
        if ("".equals(this.testProjectNameditor.getValueAsString())) {
            this.testProjectNameditor.setValue((Object)this.getTestProjectName(seamProjectName));
        }
    }

    private String getSessionPkgName(String projectName) {
        return "org.domain." + SeamUtil.getSeamPackageName((String)projectName) + ".session";
    }

    private String getEntityPkgName(String projectName) {
        return "org.domain." + SeamUtil.getSeamPackageName((String)projectName) + ".entity";
    }

    private String getTestPkgName(String projectName) {
        return "org.domain." + SeamUtil.getSeamPackageName((String)projectName) + ".test";
    }

    private String getEJBProjectName(String projectName) {
        return String.valueOf(projectName) + "-ejb";
    }

    private String getEARProjectName(String projectName) {
        return String.valueOf(projectName) + "-ear";
    }

    private String getTestProjectName(String projectName) {
        return String.valueOf(projectName) + "-test";
    }

    private void setDefaultSeamRuntime() {
        ITaggedFieldEditor runtimesField = (ITaggedFieldEditor)((CompositeEditor)this.jBossSeamHomeEditor).getEditors().get(1);
        Object oldValue = runtimesField.getValue();
        Object newValue = "";
        List<String> runtimes = this.getRuntimeNames(this.model.getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString());
        if (oldValue == null || !runtimes.contains(oldValue)) {
            String defaultRnt = SeamFacetInstallDataModelProvider.getSeamRuntimeDefaultValue((IDataModel)this.model);
            if (defaultRnt != null && runtimes.contains(defaultRnt)) {
                newValue = defaultRnt;
            } else if (!runtimes.isEmpty()) {
                newValue = runtimes.get(0);
            }
        } else {
            newValue = oldValue;
        }
        runtimesField.setValue(newValue);
        runtimesField.setTags(runtimes.toArray(new String[0]));
    }

    private void validate() {
        final IStatus message = this.validatorDelegate.getFirstValidationError();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (message == null) {
                    SeamInstallWizardPage.this.setMessage(null);
                    SeamInstallWizardPage.this.setErrorMessage(null);
                    SeamInstallWizardPage.this.setPageComplete(true);
                    return;
                }
                if (message.getSeverity() == 4) {
                    SeamInstallWizardPage.this.setErrorMessage(message.getMessage());
                    SeamInstallWizardPage.this.setPageComplete(false);
                    return;
                }
                SeamInstallWizardPage.this.setErrorMessage(null);
                SeamInstallWizardPage.this.setMessage(message.getMessage(), 2);
                SeamInstallWizardPage.this.setPageComplete(true);
            }
        });
    }

    private boolean canTestProjectBeCreated() {
        if (this.isSeamProjectWizard()) {
            String seamRuntimeName = this.jBossSeamHomeEditor.getValueAsString();
            SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(seamRuntimeName);
            if (seamRuntime != null) {
                File bootstrap = new File(seamRuntime.getHomeDir(), "bootstrap");
                return bootstrap.exists();
            }
        }
        return false;
    }

    IValidator getDeploymentTypeValidator(IWizard wizard) {
        if (wizard instanceof NewProjectDataModelFacetWizard) {
            return new DeploymentTypeValidator("seam.project.deployment.type", ((NewProjectDataModelFacetWizard)wizard).getDataModel());
        }
        return new IValidator(){

            public Map<String, IStatus> validate(Object value, Object context) {
                return SeamValidatorFactory.NO_ERRORS;
            }
        };
    }

    public void finishPressed() {
        this.model.removeListener((IDataModelListener)this.validatorDelegate);
    }

    public String getSessionBeanPkgName() {
        return this.sessionBeanPkgNameditor.getValueAsString();
    }

    public String getEntityBeanPkgName() {
        return this.entityBeanPkgNameditor.getValueAsString();
    }

    public String getTestsPkgName() {
        return this.testsPkgNameditor.getValueAsString();
    }

    private Map<String, IStatus> doPackStatus(IStatus status, String propertyName, String message) {
        return SeamValidatorFactory.createErrormessage((String)propertyName, (IStatus)new Status(status.getSeverity(), "org.jboss.tools.seam.core", message));
    }

    static class DeploymentTypeValidator
    implements IValidator {
        String propertyName;
        IDataModel model;
        static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        static final IProjectFacetVersion EJB_30 = EJB_FACET.getVersion("3.0");
        static final IProjectFacet EAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        static final IProjectFacetVersion EAR_50 = EAR_FACET.getVersion("5.0");

        public DeploymentTypeValidator(String propertyName, IDataModel model) {
            this.propertyName = propertyName;
            this.model = model;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            IRuntime rt;
            Object runtimeName;
            String deploymentType = value.toString();
            if (!("war".equals(deploymentType) || (runtimeName = this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) == null || (rt = RuntimeManager.getRuntime((String)runtimeName.toString())).supports(EJB_30) && rt.supports(EAR_50))) {
                return SeamValidatorFactory.createErrormessage((String)this.propertyName, (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_CANNOT_USE_SELECTED_DEPLOYMENT6, (Object[])new String[]{deploymentType.toUpperCase(), runtimeName.toString()})));
            }
            return SeamValidatorFactory.NO_ERRORS;
        }
    }

    private class NewSeamRuntimeAction
    extends SeamWizardFactory.NewSeamRuntimeAction {
        private NewSeamRuntimeAction() {
        }

        @Override
        protected IFieldEditor getRuntimeSelectionEditor() {
            return SeamInstallWizardPage.this.jBossSeamHomeEditor;
        }

        @Override
        protected SeamVersion[] getSeamVersions() {
            String seamVersion = SeamInstallWizardPage.this.model.getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString();
            return new SeamVersion[]{SeamVersion.parseFromString((String)seamVersion)};
        }
    }

    public class PackageNameValidator
    implements IValidator {
        String fieldName;
        String targetName;

        public PackageNameValidator(String fieldName, String targetName) {
            this.fieldName = fieldName;
            this.targetName = targetName;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            IStatus status = JavaConventions.validatePackageName((String)value.toString(), (String)"1.5", (String)"1.5");
            if ((6 & status.getSeverity()) != 0) {
                return SeamInstallWizardPage.this.doPackStatus(status, this.fieldName, NLS.bind((String)SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_PACKAGE_NAME_NOT_VALID, (Object)this.targetName));
            }
            return SeamValidatorFactory.NO_ERRORS;
        }
    }

    class ProjectNamesDuplicationValidator
    implements IValidator {
        String propertyName;

        public ProjectNamesDuplicationValidator(String propertyName) {
            this.propertyName = propertyName;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            String testProjectName;
            IStatus status;
            String deployAs = SeamInstallWizardPage.this.model.getStringProperty("seam.project.deployment.type");
            boolean testCreating = (Boolean)SeamInstallWizardPage.this.model.getProperty("seam.test.project.creating");
            if (testCreating && (6 & (status = ProjectCreationDataModelProviderNew.validateName((String)(testProjectName = SeamInstallWizardPage.this.testProjectNameditor.getValueAsString()))).getSeverity()) != 0) {
                if ("".equals(testProjectName.trim())) {
                    return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, SeamCoreMessages.VALIDATOR_FACTORY_TEST_PROJECT_CANNOT_BE_EMPTY);
                }
                return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, NLS.bind((String)SeamCoreMessages.VALIDATOR_FACTORY_TEST_PROJECT_ALREADY_EXISTS, (Object)testProjectName));
            }
            if ("ear".equals(deployAs) && !SeamInstallWizardPage.this.isWebProjectWizard()) {
                String earProjectName = SeamInstallWizardPage.this.earProjectNameditor.getValueAsString();
                status = ProjectCreationDataModelProviderNew.validateName((String)earProjectName);
                if ((6 & status.getSeverity()) != 0) {
                    if ("".equals(earProjectName.trim())) {
                        return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, SeamCoreMessages.VALIDATOR_FACTORY_EAR_PROJECT_CANNOT_BE_EMPTY);
                    }
                    return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, NLS.bind((String)SeamCoreMessages.VALIDATOR_FACTORY_EAR_PROJECT_ALREADY_EXISTS, (Object)earProjectName));
                }
                String ejbProjectName = SeamInstallWizardPage.this.ejbProjectNameditor.getValueAsString();
                status = ProjectCreationDataModelProviderNew.validateName((String)ejbProjectName);
                if ((6 & status.getSeverity()) != 0) {
                    if ("".equals(ejbProjectName.trim())) {
                        return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, SeamCoreMessages.VALIDATOR_FACTORY_EJB_PROJECT_CANNOT_BE_EMPTY);
                    }
                    return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, NLS.bind((String)SeamCoreMessages.VALIDATOR_FACTORY_EJB_PROJECT_ALREADY_EXISTS, (Object)ejbProjectName));
                }
            }
            return SeamValidatorFactory.NO_ERRORS;
        }
    }
}

