/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.html.template;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlTextareaTemplate
extends VpeAbstractTemplate {
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement textarea = visualDocument.createElement("textarea");
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)textarea);
        NodeList childNodes = sourceNode.getChildNodes();
        int childNodesLength = childNodes.getLength();
        int i = 0;
        while (i < childNodesLength) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 3) {
                nsIDOMText text = visualDocument.createTextNode(child.getNodeValue());
                textarea.appendChild((nsIDOMNode)text);
            }
            ++i;
        }
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)textarea);
        VpeElementData textElementsData = new VpeElementData();
        textElementsData.addNodeData(new NodeData(sourceNode.getLastChild(), (nsIDOMNode)textarea));
        creationData.setElementData(textElementsData);
        return creationData;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

