/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.jboss.tools.hibernate.proxy.ClassMetadataProxy;
import org.jboss.tools.hibernate.proxy.CollectionMetadataProxy;
import org.jboss.tools.hibernate.proxy.SessionProxy;
import org.jboss.tools.hibernate.spi.IClassMetadata;
import org.jboss.tools.hibernate.spi.ICollectionMetadata;
import org.jboss.tools.hibernate.spi.ISession;
import org.jboss.tools.hibernate.spi.ISessionFactory;

public class SessionFactoryProxy
implements ISessionFactory {
    private SessionFactory target;
    private Map<String, IClassMetadata> allClassMetadata = null;
    private Map<String, ICollectionMetadata> allCollectionMetadata = null;

    public SessionFactoryProxy(SessionFactory sessionFactory) {
        this.target = sessionFactory;
    }

    public void close() {
        this.target.close();
    }

    public Map<String, IClassMetadata> getAllClassMetadata() {
        if (this.allClassMetadata == null) {
            this.initializeAllClassMetadata();
        }
        return this.allClassMetadata;
    }

    private void initializeAllClassMetadata() {
        Map origin = this.target.getAllClassMetadata();
        this.allClassMetadata = new HashMap<String, IClassMetadata>(origin.size());
        for (Map.Entry entry : origin.entrySet()) {
            this.allClassMetadata.put((String)entry.getKey(), new ClassMetadataProxy((ClassMetadata)entry.getValue()));
        }
    }

    public Map<String, ICollectionMetadata> getAllCollectionMetadata() {
        if (this.allCollectionMetadata == null) {
            this.initializeAllCollectionMetadata();
        }
        return this.allCollectionMetadata;
    }

    private void initializeAllCollectionMetadata() {
        Map origin = this.target.getAllCollectionMetadata();
        this.allCollectionMetadata = new HashMap<String, ICollectionMetadata>(origin.size());
        for (Map.Entry entry : origin.entrySet()) {
            this.allCollectionMetadata.put((String)entry.getKey(), new CollectionMetadataProxy((CollectionMetadata)entry.getValue()));
        }
    }

    public ISession openSession() {
        return new SessionProxy(this, (Session)this.target.openSession());
    }

    SessionFactory getTarget() {
        return this.target;
    }

    public IClassMetadata getClassMetadata(Class<?> clazz) {
        if (this.allClassMetadata == null) {
            this.initializeAllClassMetadata();
        }
        return this.allClassMetadata.get(clazz.getName());
    }

    public IClassMetadata getClassMetadata(String entityName) {
        if (this.allClassMetadata == null) {
            this.initializeAllClassMetadata();
        }
        return this.allClassMetadata.get(entityName);
    }

    public ICollectionMetadata getCollectionMetadata(String string) {
        if (this.allCollectionMetadata == null) {
            this.initializeAllCollectionMetadata();
        }
        return this.allCollectionMetadata.get(string);
    }
}

