/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.io.Serializable;
import java.util.ArrayList;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.proxy.EntityMetamodelProxy;
import org.jboss.tools.hibernate.proxy.SessionProxy;
import org.jboss.tools.hibernate.proxy.TypeProxy;
import org.jboss.tools.hibernate.spi.HibernateException;
import org.jboss.tools.hibernate.spi.IClassMetadata;
import org.jboss.tools.hibernate.spi.IEntityMetamodel;
import org.jboss.tools.hibernate.spi.ISession;
import org.jboss.tools.hibernate.spi.IType;

public class ClassMetadataProxy
implements IClassMetadata {
    private ClassMetadata target = null;
    private IType[] propertyTypes = null;
    private IType identifierType = null;

    public ClassMetadataProxy(ClassMetadata classMetadata) {
        this.target = classMetadata;
    }

    public String getEntityName() {
        return this.target.getEntityName();
    }

    public String getIdentifierPropertyName() {
        return this.target.getIdentifierPropertyName();
    }

    public String[] getPropertyNames() {
        return this.target.getPropertyNames();
    }

    public IType[] getPropertyTypes() {
        if (this.propertyTypes == null) {
            this.initializePropertyTypes();
        }
        return this.propertyTypes;
    }

    private void initializePropertyTypes() {
        Type[] origin = this.target.getPropertyTypes();
        ArrayList<TypeProxy> propertyTypes = new ArrayList<TypeProxy>(origin.length);
        Type[] typeArray = origin;
        int n = origin.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            propertyTypes.add(new TypeProxy(type));
            ++n2;
        }
        this.propertyTypes = propertyTypes.toArray(new IType[origin.length]);
    }

    public Class<?> getMappedClass() {
        return this.target.getMappedClass(EntityMode.POJO);
    }

    public IType getIdentifierType() {
        if (this.identifierType == null) {
            this.identifierType = new TypeProxy(this.target.getIdentifierType());
        }
        return this.identifierType;
    }

    public Object getPropertyValue(Object object, String name) throws HibernateException {
        try {
            return this.target.getPropertyValue(object, name, EntityMode.POJO);
        }
        catch (org.hibernate.HibernateException e) {
            throw new HibernateException(e.getMessage(), e.getCause());
        }
    }

    public boolean hasIdentifierProperty() {
        return this.target.hasIdentifierProperty();
    }

    public Object getIdentifier(Object object) {
        return this.target.getIdentifier(object, EntityMode.POJO);
    }

    public Object getIdentifier(Object object, ISession session) {
        Serializable result = null;
        if (session instanceof SessionProxy) {
            SessionImplementor impl = (SessionImplementor)((SessionProxy)session).getTarget();
            result = this.target.getIdentifier(object, impl);
        }
        return result;
    }

    public boolean isInstanceOfAbstractEntityPersister() {
        return this.target instanceof AbstractEntityPersister;
    }

    public IEntityMetamodel getEntityMetamodel() {
        assert (this.target instanceof AbstractEntityPersister);
        EntityMetamodel emm = ((AbstractEntityPersister)this.target).getEntityMetamodel();
        return emm != null ? new EntityMetamodelProxy(emm) : null;
    }
}

