/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeModel;
import org.jboss.tools.runtime.core.model.RuntimePath;

public class RuntimeModelUtil {
    public static final String LINE_DELIMITER = "\n\r\f";
    public static final String IN_LINE_DELIMITER = ",";

    public static Set<RuntimePath> parseRuntimeFile(File file) {
        try {
            return RuntimeModelUtil.parseRuntimeFile(new BufferedInputStream(new FileInputStream(file)), false);
        }
        catch (IOException ioe) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)ioe);
            return new TreeSet<RuntimePath>();
        }
    }

    public static Set<RuntimePath> parseRuntimeFile(InputStream is, boolean includeMissing) {
        HashSet<RuntimePath> runtimePaths = new HashSet<RuntimePath>();
        try {
            Properties servers = new Properties();
            servers.load(is);
            Enumeration<Object> elements = servers.elements();
            while (elements.hasMoreElements()) {
                String str = (String)elements.nextElement();
                StringTokenizer lineTokenizer = new StringTokenizer(str, LINE_DELIMITER);
                while (lineTokenizer.hasMoreTokens()) {
                    String lineToken = lineTokenizer.nextToken();
                    StringTokenizer tokenizer = new StringTokenizer(lineToken, IN_LINE_DELIMITER);
                    if (tokenizer.countTokens() != 2) continue;
                    String location = tokenizer.nextToken();
                    boolean scan = Boolean.parseBoolean(tokenizer.nextToken());
                    File locationFile = new File(location);
                    if (!locationFile.isDirectory() && (!includeMissing || locationFile.exists())) continue;
                    RuntimePath tempLocation = new RuntimePath(location);
                    tempLocation.setScanOnEveryStartup(scan);
                    runtimePaths.add(tempLocation);
                }
            }
        }
        catch (IOException e) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e);
        }
        return runtimePaths;
    }

    public static void updateTimestamps(RuntimePath[] runtimePaths2) {
        RuntimePath[] runtimePathArray = runtimePaths2;
        int n = runtimePaths2.length;
        int n2 = 0;
        while (n2 < n) {
            File directory;
            RuntimePath runtimePath = runtimePathArray[n2];
            String path = runtimePath.getPath();
            if (path != null && !path.isEmpty() && (directory = new File(path)).isDirectory()) {
                runtimePath.setTimestamp(directory.lastModified());
            }
            ++n2;
        }
    }

    public static boolean verifyRuntimeDefinitionCreated(RuntimeDefinition runtimeDefinition) {
        return RuntimeModelUtil.verifyRuntimeDefinitionCreated(runtimeDefinition, true);
    }

    public static boolean verifyRuntimeDefinitionCreated(RuntimeDefinition runtimeDefinition, boolean checkNested) {
        Set<IRuntimeDetector> detectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        return RuntimeModelUtil.verifyRuntimeDefinitionCreated(runtimeDefinition, detectors, checkNested);
    }

    public static boolean verifyRuntimeDefinitionCreated(RuntimeDefinition runtimeDefinition, Set<IRuntimeDetector> detectors, boolean checkNested) {
        boolean created = false;
        for (IRuntimeDetector detector : detectors) {
            if (!detector.isEnabled() || !detector.exists(runtimeDefinition)) continue;
            if (!checkNested) {
                created = true;
                continue;
            }
            List<RuntimeDefinition> includedDefinitions = runtimeDefinition.getIncludedRuntimeDefinitions();
            boolean includedCreated = true;
            for (RuntimeDefinition includedDefinition : includedDefinitions) {
                if (RuntimeModelUtil.verifyRuntimeDefinitionCreated(includedDefinition)) continue;
                includedCreated = false;
                break;
            }
            if (!includedCreated) continue;
            created = true;
            break;
        }
        return created;
    }

    public static List<RuntimeDefinition> getRuntimeDefinitions(Set<RuntimePath> runtimePaths) {
        RuntimePath[] paths = runtimePaths.toArray(new RuntimePath[runtimePaths.size()]);
        return RuntimeModelUtil.getRuntimeDefinitions(paths);
    }

    public static List<RuntimeDefinition> getRuntimeDefinitions(RuntimePath[] runtimePaths) {
        ArrayList<RuntimeDefinition> runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        RuntimePath[] runtimePathArray = runtimePaths;
        int n = runtimePaths.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath runtimePath = runtimePathArray[n2];
            runtimeDefinitions.addAll(Arrays.asList(runtimePath.getRuntimeDefinitions()));
            ++n2;
        }
        return runtimeDefinitions;
    }

    public static List<RuntimeDefinition> getAllDefinitions(RuntimePath runtimePath) {
        return RuntimeModelUtil.getAllDefinitions(new RuntimePath[]{runtimePath});
    }

    public static List<RuntimeDefinition> getAllDefinitions(RuntimePath[] runtimePath) {
        ArrayList<RuntimeDefinition> allDefinitions = new ArrayList<RuntimeDefinition>();
        int i = 0;
        while (i < runtimePath.length) {
            allDefinitions.addAll(Arrays.asList(runtimePath[i].getRuntimeDefinitions()));
            RuntimeDefinition[] runtimeDefinitionArray = runtimePath[i].getRuntimeDefinitions();
            int n = runtimeDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                RuntimeDefinition runtimeDefinition = runtimeDefinitionArray[n2];
                allDefinitions.addAll(runtimeDefinition.getIncludedRuntimeDefinitions());
                ++n2;
            }
            ++i;
        }
        return allDefinitions;
    }

    public static boolean runtimeDefinitionsExists(RuntimeDefinition runtimeDefinition, RuntimeModel model) {
        return RuntimeModelUtil.runtimeDefinitionsExists(runtimeDefinition, model.getRuntimePaths());
    }

    public static boolean runtimeDefinitionsExists(RuntimeDefinition runtimeDefinition, RuntimePath[] paths) {
        return RuntimeModelUtil.runtimeDefinitionsExists(runtimeDefinition, RuntimeModelUtil.getRuntimeDefinitions(paths));
    }

    public static boolean runtimeDefinitionsExists(RuntimeDefinition runtimeDefinition, List<RuntimeDefinition> allRuntimeDefinitions) {
        Iterator<RuntimeDefinition> it = allRuntimeDefinitions.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(runtimeDefinition)) continue;
            return true;
        }
        return false;
    }
}

