/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class RuntimePath
implements Cloneable {
    private String path;
    private boolean scanOnEveryStartup;
    private List<RuntimeDefinition> runtimeDefinitions;
    private long timestamp;

    public RuntimePath(String path) {
        this.path = path;
        this.scanOnEveryStartup = false;
        this.runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        this.timestamp = -1L;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isScanOnEveryStartup() {
        return this.scanOnEveryStartup;
    }

    public void setScanOnEveryStartup(boolean scanOnEveryStartup) {
        this.scanOnEveryStartup = scanOnEveryStartup;
    }

    public RuntimeDefinition[] getRuntimeDefinitions() {
        return this.runtimeDefinitions.toArray(new RuntimeDefinition[this.runtimeDefinitions.size()]);
    }

    public void setRuntimeDefinitions(RuntimeDefinition[] defs2) {
        ArrayList<RuntimeDefinition> defs = new ArrayList<RuntimeDefinition>();
        defs.addAll(Arrays.asList(defs2));
        this.runtimeDefinitions = defs;
    }

    public void addRuntimeDefinition(RuntimeDefinition def) {
        if (!this.runtimeDefinitions.contains(def)) {
            this.runtimeDefinitions.add(def);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RuntimePath runtimePath = new RuntimePath(this.path);
        runtimePath.setScanOnEveryStartup(this.scanOnEveryStartup);
        runtimePath.runtimeDefinitions = (List)((ArrayList)this.runtimeDefinitions).clone();
        return runtimePath;
    }

    public boolean isModified() {
        if (this.path == null || this.path.isEmpty()) {
            return false;
        }
        if (this.timestamp < 0L) {
            return true;
        }
        File directory = new File(this.path);
        if (!directory.isDirectory()) {
            return false;
        }
        try {
            return directory.lastModified() > this.timestamp;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return "RuntimePath [path=" + this.path + "]";
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimePath other = (RuntimePath)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

