/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.wizard;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.compare.Splitter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertManager;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.util.SwtUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractWizardPageWithPreview;
import org.jboss.tools.jst.web.ui.palette.html.wizard.ComboContentProposalProvider;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;
import org.w3c.dom.Document;

public class AbstractNewHTMLWidgetWizardPage
extends AbstractWizardPageWithPreview {
    protected Map<String, IFieldEditor> editors = new HashMap<String, IFieldEditor>();
    protected StyledText text;
    protected Browser browser;
    protected File sourceFile = null;
    protected String sourceURL = null;
    String warningMessage;
    protected static final boolean isLinux = SystemUtils.IS_OS_LINUX;
    protected static final String SECTION_NAME = "InsertTag";
    public static final String ADD_JS_CSS_SETTING_NAME = "addJSCSS";
    FocusReturn focusReturn = new FocusReturn();
    int textLimit = -1;
    static Color valueColor = new Color(null, 42, 0, 255);
    static Color tagColor = new Color(null, 63, 127, 127);
    static Color attrColor = new Color(null, 127, 0, 127);

    public AbstractNewHTMLWidgetWizardPage(String pageName, String title) {
        super(pageName, title);
    }

    public AbstractNewHTMLWidgetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public AbstractNewHTMLWidgetWizard getWizard() {
        return (AbstractNewHTMLWidgetWizard)super.getWizard();
    }

    protected void createWarningMessage() {
        String palettePath = this.getWizard().getCommandProperties().getProperty("palettePath");
        IPositionCorrector corrector = PaletteInsertManager.getInstance().createCorrectorInstance(palettePath);
        if (corrector != null) {
            ITextSelection s = (ITextSelection)this.getWizard().getWizardModel().getDropData().getSelectionProvider().getSelection();
            IDocument doc = this.getWizard().getWizardModel().getDropData().getSourceViewer().getDocument();
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)((IStructuredDocument)doc));
                if (model instanceof IDOMModel) {
                    this.warningMessage = corrector.getWarningMessage((Document)((IDOMModel)model).getDocument(), s);
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    public void validate() throws ValidationException {
        if (this.warningMessage != null) {
            throw new ValidationException(this.warningMessage, true);
        }
    }

    @Override
    protected void createPreview() {
        if (this.hasVisualPreview()) {
            Splitter previewPanel = new Splitter(this.panel, 512);
            GridData d = new GridData(1808);
            previewPanel.setLayoutData((Object)d);
            previewPanel.setLayout((Layout)new GridLayout());
            this.createTextPreview((Composite)previewPanel);
            Composite browserPanel = this.createBrowserPanel((Composite)previewPanel);
            this.browser = WebUiPlugin.createBrowser(browserPanel, this.getPreferredBrowser());
            if (this.browser != null) {
                this.browser.setLayoutData((Object)new GridData(1808));
                this.browser.pack();
            }
            this.createDisclaimer(browserPanel);
            previewPanel.setWeights(new int[]{4, 6});
            this.previewPanel = previewPanel;
        } else {
            this.createTextPreview(this.panel);
            this.previewPanel = this.text;
        }
    }

    @Override
    protected void startPreview() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractNewHTMLWidgetWizardPage.this.text == null || AbstractNewHTMLWidgetWizardPage.this.text.isDisposed()) {
                    return;
                }
                AbstractNewHTMLWidgetWizardPage.this.updatePreviewPanel(true, true);
                AbstractNewHTMLWidgetWizardPage.this.updatePreviewContent();
                AbstractNewHTMLWidgetWizardPage.this.runValidation();
                AbstractNewHTMLWidgetWizardPage.this.text.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        if ((this).AbstractNewHTMLWidgetWizardPage.this.textLimit < 0 || (this).AbstractNewHTMLWidgetWizardPage.this.textLimit == AbstractNewHTMLWidgetWizardPage.this.getTextLimit()) {
                            return;
                        }
                        AbstractNewHTMLWidgetWizardPage.this.resetText();
                    }
                });
            }
        });
    }

    @Override
    protected void onCreateControl() {
        Display.getDefault().addFilter(16, (Listener)this.focusReturn);
        Display.getDefault().addFilter(3, (Listener)this.focusReturn);
        Display.getDefault().addFilter(1, (Listener)this.focusReturn);
        Display.getDefault().addFilter(24, (Listener)this.focusReturn);
        this.createWarningMessage();
    }

    void createTextPreview(Composite parent) {
        this.text = new StyledText(parent, 2570);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setText("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n<html><body>aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa</body></html>");
    }

    protected int getPreferredBrowser() {
        return WebUiPlugin.getPreferredBrowser();
    }

    protected boolean hasVisualPreview() {
        return true;
    }

    public String getBrowserType() {
        return this.browser == null ? null : this.browser.getBrowserType();
    }

    private Composite createBrowserPanel(Composite previewPanel) {
        Composite browserPanel = new Composite(previewPanel, 2048);
        GridData g = new GridData();
        g.horizontalAlignment = 4;
        g.verticalAlignment = 4;
        g.grabExcessHorizontalSpace = true;
        g.grabExcessVerticalSpace = true;
        browserPanel.setLayoutData((Object)g);
        GridLayout l = new GridLayout();
        l.verticalSpacing = 0;
        l.marginWidth = 0;
        l.marginHeight = 0;
        browserPanel.setLayout((Layout)l);
        return browserPanel;
    }

    private void createDisclaimer(Composite browserPanel) {
        Label disclaimer = new Label(browserPanel, 0);
        disclaimer.setText(WizardMessages.previewDisclaimer);
        GridData disclaimerData = new GridData();
        disclaimerData.horizontalAlignment = 0x1000000;
        disclaimer.setLayoutData((Object)disclaimerData);
        FontData fd = disclaimer.getFont().getFontData()[0];
        fd.setStyle(2);
        fd.setHeight(8);
        Font font = new Font(null, fd);
        disclaimer.setFont(font);
        SwtUtil.bindDisposal((Resource)font, (Widget)disclaimer);
    }

    public void addEditor(IFieldEditor editor) {
        this.editors.put(editor.getName(), editor);
    }

    public void addEditor(IFieldEditor editor, Composite parent) {
        Combo c;
        if (parent != null) {
            editor.doFillIntoGrid((Object)parent);
        }
        editor.addPropertyChangeListener((PropertyChangeListener)this);
        this.addEditor(editor);
        Combo combo = c = parent != null ? this.findCombo(editor) : null;
        if (c != null) {
            new ComboContentProposalProvider(c);
        }
    }

    private Combo findCombo(IFieldEditor editor) {
        Object[] objectArray = editor.getEditorControls();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Combo) {
                return (Combo)o;
            }
            ++n2;
        }
        return null;
    }

    public void addEditor(IFieldEditor editor, Composite parent, boolean expandCombo) {
        this.addEditor(editor, parent);
        if (expandCombo && parent != null) {
            this.expandCombo(editor);
        }
    }

    public void expandCombo(IFieldEditor editor) {
        if (this.left == null) {
            return;
        }
        Control c = (Control)editor.getEditorControls()[1];
        GridData d = (GridData)c.getLayoutData();
        d.horizontalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)d);
    }

    public IFieldEditor getEditor(String name) {
        return this.editors.get(name);
    }

    public String getEditorValue(String name) {
        return !this.editors.containsKey(name) ? null : this.getEditor(name).getValueAsString();
    }

    public void setEditorValue(String name, String value) {
        if (this.editors.containsKey(name)) {
            this.getEditor(name).setValue((Object)value);
        }
    }

    File getFile() {
        if (this.sourceFile == null) {
            try {
                this.sourceFile = File.createTempFile("jquery_preview", ".html");
                this.sourceURL = this.sourceFile.toURI().toURL().toString();
            }
            catch (IOException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        return this.sourceFile;
    }

    @Override
    protected void updatePreviewContent() {
        this.resetText();
        if (this.browser == null) {
            return;
        }
        File f = this.getFile();
        FileUtil.writeFile((File)f, (String)this.getWizard().getTextForBrowser());
        this.focusReturn.init();
        if (this.browser.getUrl() == null || !this.browser.getUrl().endsWith(f.getName()) || "mozilla".equals(this.getBrowserType())) {
            this.browser.setUrl(this.sourceURL);
        } else {
            this.browser.refresh();
        }
    }

    boolean isFocusInBrowser() {
        Control c = Display.getDefault().getFocusControl();
        while (c != null && c != this.browser) {
            c = c.getParent();
        }
        return c == this.browser;
    }

    int getTextLimit() {
        int w;
        int c = this.text.getSize().x - 2;
        if (this.text.getVerticalBar() != null && (w = this.text.getVerticalBar().getSize().x) > 0) {
            c -= w + 5;
        }
        return c < 20 ? 20 : c;
    }

    protected String formatText(String text) {
        this.textLimit = this.getTextLimit();
        return AbstractNewHTMLWidgetWizardPage.formatText(text, this.text, this.textLimit);
    }

    public static String formatText(String text, StyledText styledText, int max) {
        GC gc = new GC((Drawable)styledText);
        gc.setFont(styledText.getFont());
        StringBuilder sb = new StringBuilder();
        boolean inQuota = false;
        boolean inTag = false;
        int offset = 0;
        int i = 0;
        while (i < text.length()) {
            int w;
            char ch = text.charAt(i);
            if (ch == '<' && !inQuota) {
                int n = AbstractNewHTMLWidgetWizardPage.lookUp(text, i, inTag, false);
                w = gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)sb.substring((int)offset, (int)sb.length()))).append((String)text.substring((int)i, (int)n)).toString()).x;
                if (w > max) {
                    sb.append("\n");
                    offset = sb.length();
                }
            }
            sb.append(ch);
            if (inTag && ch == '\"') {
                inQuota = !inQuota;
            } else if (ch == '<' && !inQuota) {
                inTag = true;
            } else if (ch == '>' && !inQuota) {
                inTag = false;
            } else if (ch == '\n') {
                offset = sb.length();
            }
            if (sb.length() > offset && (ch == ' ' || ch == '>')) {
                int l = AbstractNewHTMLWidgetWizardPage.lookUp(text, i + 1, inTag, inQuota);
                w = gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)sb.substring((int)offset, (int)sb.length()))).append((String)text.substring((int)i, (int)l)).toString()).x;
                if (l > i + 1 && w > max) {
                    sb.append("\n");
                    offset = sb.length();
                    if (inTag) {
                        String indent = "        ";
                        if (inQuota) {
                            indent = String.valueOf(indent) + "    ";
                        }
                        sb.append(indent);
                    }
                }
            }
            ++i;
        }
        gc.dispose();
        return sb.toString();
    }

    protected static int lookUp(String text, int pos, boolean inTag, boolean inQuota) {
        int res = pos;
        while (res < text.length()) {
            char ch = text.charAt(res);
            if (ch == '\n') {
                return res;
            }
            if (ch == '\"' && inTag) {
                boolean bl = inQuota = !inQuota;
            }
            if (!inQuota) {
                if (ch == ' ' || res > pos && ch == '<') {
                    return res;
                }
                if (ch == '>') {
                    return res + 1;
                }
            } else if (ch == ' ' && res > pos + 1) {
                return res;
            }
            ++res;
        }
        return res;
    }

    public void dispose() {
        if (this.sourceFile != null) {
            this.sourceFile.delete();
            this.sourceFile = null;
        }
        Display.getDefault().removeFilter(16, (Listener)this.focusReturn);
        Display.getDefault().removeFilter(3, (Listener)this.focusReturn);
        Display.getDefault().removeFilter(1, (Listener)this.focusReturn);
        Display.getDefault().removeFilter(24, (Listener)this.focusReturn);
        super.dispose();
    }

    private void resetText() {
        String text = this.formatText(this.getWizard().getTextForTextView());
        this.text.setStyleRanges(new StyleRange[0]);
        this.text.setText(text);
        this.text.setStyleRanges(AbstractNewHTMLWidgetWizardPage.getRanges(text));
        this.text.update();
        this.text.layout();
    }

    public static StyleRange[] getRanges(String text) {
        ArrayList<StyleRange> regionList = new ArrayList<StyleRange>();
        boolean inQuota = false;
        boolean inTag = false;
        int offset = 0;
        StringBuilder name = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (inTag && ch == '\"') {
                boolean bl = inQuota = !inQuota;
                if (!inQuota) {
                    AbstractNewHTMLWidgetWizardPage.addRange(offset, 1, valueColor, false, regionList);
                    if (i - offset > 1) {
                        AbstractNewHTMLWidgetWizardPage.addRange(offset + 1, i - offset - 1, valueColor, true, regionList);
                    }
                    AbstractNewHTMLWidgetWizardPage.addRange(i, 1, valueColor, false, regionList);
                } else {
                    offset = i;
                }
            } else if (ch == '>' && !inQuota) {
                inTag = false;
                if (name.length() > 0) {
                    AbstractNewHTMLWidgetWizardPage.addRange(offset, name.length(), tagColor, false, regionList);
                    name.setLength(0);
                }
                AbstractNewHTMLWidgetWizardPage.addRange(i, 1, tagColor, false, regionList);
            } else if (ch == '<' && !inQuota) {
                inTag = true;
                name.setLength(0);
                name.append(ch);
                offset = i;
            } else if (!inQuota && inTag && (Character.isLetterOrDigit(ch) || ch == '-' || ch == '/')) {
                if (name.length() == 0) {
                    offset = i;
                }
                name.append(ch);
            } else if (name.length() > 0) {
                Color c = name.charAt(0) == '<' ? tagColor : attrColor;
                AbstractNewHTMLWidgetWizardPage.addRange(offset, name.length(), c, false, regionList);
                name.setLength(0);
            }
            ++i;
        }
        return regionList.toArray(new StyleRange[0]);
    }

    static void addRange(int offset, int length, Color c, boolean italic, ArrayList<StyleRange> regionList) {
        StyleRange region = new StyleRange(offset, length, c, null);
        if (italic) {
            region.fontStyle = 2;
        }
        regionList.add(region);
    }

    class FocusReturn
    implements Listener {
        Control c;
        long t;
        Point s;
        StringBuilder missed = new StringBuilder();

        FocusReturn() {
        }

        void clear() {
            this.c = null;
            this.s = null;
            this.t = 0L;
            this.missed.setLength(0);
        }

        private Point getSelection() {
            return this.c instanceof Combo ? ((Combo)this.c).getSelection() : (this.c instanceof Text ? ((Text)this.c).getSelection() : null);
        }

        private String getText() {
            return this.c instanceof Combo ? ((Combo)this.c).getText() : (this.c instanceof Text ? ((Text)this.c).getText() : null);
        }

        private void setText(String t) {
            if (this.c instanceof Combo) {
                ((Combo)this.c).setText(t);
            } else if (this.c instanceof Text) {
                ((Text)this.c).setText(t);
            }
        }

        private void setSelection() {
            if (this.c instanceof Combo) {
                ((Combo)this.c).setSelection(this.s);
            } else if (this.c instanceof Text) {
                ((Text)this.c).setSelection(this.s);
            }
        }

        void init() {
            this.clear();
            this.c = Display.getDefault().getFocusControl();
            if (this.c != null) {
                this.t = System.currentTimeMillis();
                this.s = this.getSelection();
            }
        }

        boolean isReady() {
            if (this.c == null) {
                return false;
            }
            if (System.currentTimeMillis() - this.t > 2000L) {
                this.clear();
                return false;
            }
            return true;
        }

        void apply() {
            if (!this.isReady()) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FocusReturn.this.c != null && FocusReturn.this.c != Display.getCurrent().getFocusControl() && AbstractNewHTMLWidgetWizardPage.this.isFocusInBrowser()) {
                        if (FocusReturn.this.s != null && FocusReturn.this.missed.length() > 0) {
                            String t = FocusReturn.this.getText();
                            t = String.valueOf(t.substring(0, FocusReturn.this.s.x)) + FocusReturn.this.missed.toString() + t.substring(FocusReturn.this.s.y);
                            FocusReturn.this.s.x += FocusReturn.this.missed.length();
                            FocusReturn.this.s.y = FocusReturn.this.s.x;
                            FocusReturn.this.setText(t);
                        }
                        FocusReturn.this.c.forceFocus();
                        if (FocusReturn.this.s != null) {
                            FocusReturn.this.setSelection();
                        }
                    }
                    FocusReturn.this.clear();
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 3) {
                this.clear();
            } else if (event.type == 24) {
                if (this.isReady() && this.c == Display.getDefault().getFocusControl() && this.c == event.widget) {
                    this.s = this.getSelection();
                }
            } else if (event.type == 1) {
                char ch;
                if (this.isReady() && this.c == Display.getDefault().getFocusControl()) {
                    this.t = System.currentTimeMillis();
                }
                if (this.isReady() && event.widget == AbstractNewHTMLWidgetWizardPage.this.browser && (ch = event.character) >= ' ' && ch <= '\u0080') {
                    this.missed.append(ch);
                }
            } else if (event.type == 16) {
                this.apply();
            }
        }
    }
}

