/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.beans.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.TabEditor;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class NewTabsWizardPage
extends NewJQueryWidgetWizardPage {
    TabEditor tabs = new TabEditor(this, 1, 6);

    public NewTabsWizardPage() {
        super("newTabs", WizardMessages.newTabsTitle);
        this.setDescription(WizardMessages.newTabsDescription);
    }

    @Override
    protected void createFieldPanel(Composite parent) {
        IFieldEditor modeEditor = JQueryFieldEditorFactory.createTabsLayoutEditor();
        this.addEditor(modeEditor, parent);
        this.createIDEditor(parent, false);
        LayoutUtil.TwoColumns columns = parent == null ? new LayoutUtil.TwoColumns(null, null) : LayoutUtil.createTwoColumns(parent);
        IFieldEditor collapsible = JQueryFieldEditorFactory.createTabsCollapsibleEditor();
        this.addEditor(collapsible, columns.left());
        IFieldEditor collapsed = JQueryFieldEditorFactory.createTabsCollapsedEditor();
        this.addEditor(collapsed, columns.right());
        IFieldEditor animated = JQueryFieldEditorFactory.createTabsAnimatedEditor();
        this.addEditor(animated, columns.left());
        IFieldEditor span = JQueryFieldEditorFactory.createSpan("tabs", 3);
        this.addEditor(span, columns.right());
        IFieldEditor activation = JQueryFieldEditorFactory.createTabsActivationEditor();
        this.addEditor(activation, parent);
        this.tabs.createControl(parent, WizardMessages.itemsLabel);
        IFieldEditor theme = JQueryFieldEditorFactory.createDataThemeEditor(this.getVersion());
        this.addEditor(theme, parent, true);
        this.updateEnablement();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String value;
        if (this.tabs.isSwitching) {
            return;
        }
        String name = evt.getPropertyName();
        if (this.tabs.onPropertyChange(name, value = evt.getNewValue().toString()) && "tabs-active".equals(name)) {
            this.tabs.onActiveModified();
        }
        this.updateEnablement();
        super.propertyChange(evt);
    }

    @Override
    protected int getPreferredBrowser() {
        return isLinux ? super.getPreferredBrowser() : 65536;
    }

    protected void updateEnablement() {
        if (this.left == null) {
            return;
        }
        boolean isCollapsible = this.isTrue("tabs-collapsible");
        this.getEditor("data-collapsed").setEnabled(isCollapsible);
        boolean isCollapsed = isCollapsible && this.isTrue("data-collapsed");
        this.getEditor("tabs-active").setEnabled(!isCollapsed);
    }
}

