/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.html.JQueryHTMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractWidgetPositionCorrector
implements IPositionCorrector,
JQueryHTMLConstants {
    protected IDocument fDocument;
    protected Element body;
    protected Node c;
    int offset;

    public ITextSelection correctSelection(Document document, ITextSelection selection) {
        this.init(document, selection);
        if (this.c != null) {
            return this.doCorrectSelection(selection);
        }
        return selection;
    }

    protected void init(Document document, ITextSelection selection) {
        this.c = null;
        if (!(document instanceof IDOMDocument) || selection == null) {
            return;
        }
        this.fDocument = ((IDOMDocument)document).getStructuredDocument();
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        this.body = XMLUtilities.getUniqueChild((Element)root, (String)"body");
        if (this.body == null) {
            this.body = root;
        }
        this.offset = selection.getOffset();
        IDOMDocument doc = (IDOMDocument)document;
        IndexedRegion region = doc.getModel().getIndexedRegion(this.offset);
        if (region instanceof Node) {
            this.c = (Node)region;
        }
    }

    protected abstract ITextSelection doCorrectSelection(ITextSelection var1);

    public String getWarningMessage(Document document, ITextSelection selection) {
        return null;
    }

    protected static boolean isSection(Node n) {
        String dataRole;
        if (n.getAttributes() == null) {
            return false;
        }
        Node a = n.getAttributes().getNamedItem("data-role");
        return a instanceof Attr && ("content".equals(dataRole = ((Attr)a).getValue()) || "header".equals(dataRole) || "footer".equals(dataRole) || "panel".equals(dataRole));
    }

    protected static boolean isContentSection(Node n) {
        return AbstractWidgetPositionCorrector.isSection(n, "content");
    }

    protected static boolean isSection(Node n, String dataRole) {
        String _dataRole;
        if (n.getAttributes() == null) {
            return false;
        }
        Node a = n.getAttributes().getNamedItem("data-role");
        return a instanceof Attr && dataRole.equals(_dataRole = ((Attr)a).getNodeValue());
    }

    protected static boolean isPage(Node n) {
        String dataRole;
        if (n.getAttributes() == null) {
            return false;
        }
        Node a = n.getAttributes().getNamedItem("data-role");
        return a instanceof Attr && ("page".equals(dataRole = ((Attr)a).getValue()) || "dialog".equals(dataRole));
    }

    protected static boolean hasSectionParent(Node n) {
        Node p = n.getParentNode();
        while (p != null) {
            if (AbstractWidgetPositionCorrector.isSection(p)) {
                return true;
            }
            p = p.getParentNode();
        }
        return false;
    }

    protected static Node getPageParent(Node n) {
        Node p = n.getParentNode();
        while (p != null) {
            if (AbstractWidgetPositionCorrector.isPage(p)) {
                return p;
            }
            p = p.getParentNode();
        }
        return null;
    }

    protected static boolean isInStartTag(Node n, int offset) {
        if (n instanceof ElementImpl) {
            ElementImpl e = (ElementImpl)n;
            return e.getStartOffset() <= offset && offset <= e.getStartEndOffset();
        }
        return false;
    }

    protected static boolean isInEndTag(Node n, int offset) {
        if (n instanceof ElementImpl) {
            ElementImpl e = (ElementImpl)n;
            return e.getEndStartOffset() <= offset && offset <= e.getEndOffset();
        }
        return false;
    }

    protected static boolean isInside(ElementImpl e, int offset) {
        return e.getStartEndOffset() <= offset && e.getEndStartOffset() >= offset;
    }

    protected static List<ElementImpl> getChildrenWithDatarole(Element parent) {
        return AbstractWidgetPositionCorrector.getChildrenWithDatarole(parent, null);
    }

    protected static List<ElementImpl> getChildrenWithDatarole(Element parent, String datarole) {
        ArrayList<ElementImpl> result = new ArrayList<ElementImpl>();
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            ElementImpl c;
            Node n = list.item(i);
            if (n instanceof ElementImpl && (c = (ElementImpl)n).hasAttribute("data-role") && (datarole == null || datarole.equals(c.getAttribute("data-role")))) {
                result.add(c);
            }
            ++i;
        }
        return result;
    }

    protected static List<ElementImpl> getPages(Element body) {
        ArrayList<ElementImpl> result = new ArrayList<ElementImpl>();
        for (Element element : AbstractWidgetPositionCorrector.getChildrenWithDatarole(body)) {
            if (!AbstractWidgetPositionCorrector.isPage(element)) continue;
            result.add((ElementImpl)element);
        }
        return result;
    }

    protected static List<ElementImpl> getPagesWithSections(Element body) {
        ArrayList<ElementImpl> result = new ArrayList<ElementImpl>();
        for (Element element : AbstractWidgetPositionCorrector.getChildrenWithDatarole(body)) {
            if (!AbstractWidgetPositionCorrector.isPage(element) || AbstractWidgetPositionCorrector.getSections(element).isEmpty()) continue;
            result.add((ElementImpl)element);
        }
        return result;
    }

    protected static List<ElementImpl> getSections(Element page) {
        ArrayList<ElementImpl> result = new ArrayList<ElementImpl>();
        for (Element element : AbstractWidgetPositionCorrector.getChildrenWithDatarole(page)) {
            if (!AbstractWidgetPositionCorrector.isSection(element)) continue;
            result.add((ElementImpl)element);
        }
        return result;
    }

    protected static ElementImpl getContentSection(Element page) {
        return AbstractWidgetPositionCorrector.getFirstElement(AbstractWidgetPositionCorrector.getChildrenWithDatarole(page, "content"));
    }

    static ElementImpl getHeaderSection(Element page) {
        return AbstractWidgetPositionCorrector.getFirstElement(AbstractWidgetPositionCorrector.getChildrenWithDatarole(page, "header"));
    }

    static ElementImpl getFooterSection(Element page) {
        return AbstractWidgetPositionCorrector.getFirstElement(AbstractWidgetPositionCorrector.getChildrenWithDatarole(page, "footer"));
    }

    static <T> T getFirstElement(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected static List<ElementImpl> getPanels(Element page) {
        return AbstractWidgetPositionCorrector.getChildrenWithDatarole(page, "panel");
    }

    protected static int getClosestInnerPosition(ElementImpl e, int offset) {
        int start = e.getStartEndOffset();
        int end = e.getEndStartOffset();
        if (end < 0) {
            return start;
        }
        return offset < start ? start : (offset > end ? end : offset);
    }

    protected static int getClosestInnerEdge(ElementImpl e, int offset) {
        int start = e.getStartEndOffset();
        int end = e.getEndStartOffset();
        if (end < 0) {
            return start;
        }
        return AbstractWidgetPositionCorrector.getClosest(offset, start, end);
    }

    protected static int getClosestOuterEdge(ElementImpl e, int offset) {
        int start = e.getStartOffset();
        int end = e.getEndOffset();
        return AbstractWidgetPositionCorrector.getClosest(offset, start, end);
    }

    protected static int getClosest(int offset, int a, int b) {
        return Math.abs(offset - a) <= Math.abs(b - offset) ? a : b;
    }

    protected static ElementImpl getClosestElement(List<ElementImpl> es, int offset) {
        int bestDistance = Integer.MAX_VALUE;
        ElementImpl result = null;
        for (ElementImpl e : es) {
            if (e.getStartOffset() <= offset && e.getEndOffset() >= offset) {
                return e;
            }
            int o = AbstractWidgetPositionCorrector.getClosestInnerPosition(e, offset);
            int dist = Math.abs(o - offset);
            if (dist >= bestDistance) continue;
            bestDistance = dist;
            result = e;
        }
        return result;
    }
}

