/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.CustomDrawerFigure;
import org.jboss.tools.jst.web.ui.palette.JQueryMobileVersionPopUp;
import org.jboss.tools.jst.web.ui.palette.MobileDrawerEditPart;
import org.jboss.tools.jst.web.ui.palette.model.PaletteCategory;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;
import org.jboss.tools.jst.web.ui.palette.model.PaletteRoot;

class MobileDrawerFigure
extends CustomDrawerFigure {
    private Control control;
    private static JQueryMobileVersionPopUp popup;
    private PaletteCategory category;
    private Label label = new Label("", JSTWebUIImages.getImage((ImageDescriptor)JSTWebUIImages.getInstance().createImageDescriptor(JSTWebUIImages.DROP_DOWN_LIST_IMAGE)));

    public MobileDrawerFigure(PaletteCategory category, Control control) {
        super(control);
        this.category = category;
        this.control = control;
        Figure collapseToggle = (Figure)this.getChildren().get(0);
        Figure title = (Figure)collapseToggle.getChildren().get(0);
        Figure pinFigure = (Figure)title.getChildren().get(0);
        Figure drawerFigure = (Figure)title.getChildren().get(1);
        if (category.getAvailableVersions().length > 0) {
            VersionFigure label = new VersionFigure(category.getVersion());
            GridLayout layout = new GridLayout(4, false);
            title.setLayoutManager((LayoutManager)layout);
            layout.setConstraint((IFigure)drawerFigure, (Object)new GridData(768));
            title.add((IFigure)drawerFigure);
            title.add((IFigure)label);
            title.add((IFigure)pinFigure);
        }
    }

    protected void handleExpandStateChanged() {
        super.handleExpandStateChanged();
        if (this.isCalledByButtonModel()) {
            this.category.getPaletteModel().onCategoryExpandChange(this.category.getLabel(), this.isExpanded());
        }
    }

    private boolean isCalledByButtonModel() {
        boolean buttonModel = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            if (ButtonModel.class.getName().endsWith(s.getClassName())) {
                buttonModel = true;
            } else if (MobileDrawerEditPart.class.getName().equals(s.getClassName())) {
                return false;
            }
            ++n2;
        }
        return buttonModel;
    }

    public class VersionFigure
    extends Clickable {
        private Color backColor;
        private Color foreColor;

        public VersionFigure(String text) {
            super((IFigure)MobileDrawerFigure.this.label);
            this.backColor = Display.getDefault().getSystemColor(1);
            this.foreColor = Display.getDefault().getSystemColor(15);
            MobileDrawerFigure.this.label.setText(text);
            MobileDrawerFigure.this.label.setTextPlacement(8);
            this.setRolloverEnabled(true);
            this.setBorder((Border)new MarginBorder(2));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    popup = new JQueryMobileVersionPopUp(MobileDrawerFigure.this.control, VersionFigure.this);
                    popup.show(MobileDrawerFigure.this.category.getAvailableVersions());
                }
            });
        }

        public void setVersion(String newVersion) {
            ((Label)this.getChildren().get(0)).setText(newVersion);
            PaletteModel paletteModel = ((PaletteRoot)MobileDrawerFigure.this.category.getParent()).getPaletteModel();
            paletteModel.getPaletteContents().setPreferredVersion(MobileDrawerFigure.this.category.getLabel(), newVersion);
            paletteModel.reloadCategory(MobileDrawerFigure.this.category);
        }

        public String getVersion() {
            return ((Label)this.getChildren().get(0)).getText();
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            ButtonModel model = this.getModel();
            if (this.isRolloverEnabled() && model.isMouseOver()) {
                graphics.setBackgroundColor(this.backColor);
                graphics.fillRoundRectangle(this.getClientArea().getCopy().getExpanded(1, 1), 7, 7);
                graphics.setForegroundColor(this.foreColor);
                graphics.drawRoundRectangle(this.getClientArea().getCopy().getExpanded(1, 1), 7, 7);
            }
        }
    }
}

