/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSPForBeanIdHyperlink
extends AbstractHyperlink {
    private static final String USEBEAN_TAGNAME = "jsp:useBean";
    private static final String ID_ATTRNAME = "id";

    protected void doHyperlink(IRegion region) {
        String forID = this.getForId(region);
        IRegion elementByID = this.findElementByIDBackward(forID, region.getOffset(), USEBEAN_TAGNAME);
        if (elementByID != null) {
            StructuredSelectionHelper.setSelectionAndRevealInActiveEditor((IRegion)elementByID);
        } else {
            this.openFileFailed();
        }
    }

    private IRegion findElementByIDBackward(String id, int endOffset, String tagname) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)endOffset);
            if (n == null) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null) {
                return null;
            }
            Element element = null;
            Node parent = n;
            while (parent != null && element == null) {
                element = this.findElementByIDBackward(xmlDocument.getChildNodes(), id, endOffset, tagname);
                parent = parent.getParentNode();
            }
            if (!(element instanceof IDOMElement)) {
                return null;
            }
            int offset = Utils.getValueStart(element);
            int length = ((IDOMElement)element).getStartStructuredDocumentRegion().getLength();
            Region region = new Region(offset, length);
            return region;
        }
        finally {
            smw.dispose();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element findElementByIDBackward(NodeList list, String id, int endOffset, String tagName) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            block13: {
                int i;
                block12: {
                    smw.init(this.getDocument());
                    Document xmlDocument = smw.getDocument();
                    if (xmlDocument == null) {
                        return null;
                    }
                    i = list.getLength() - 1;
                    if (!true) break block12;
                    if (list == null) return null;
                    if (i < 0) break block13;
                }
                do {
                    Element element;
                    int start;
                    if (list.item(i) instanceof Element && (start = Utils.getValueStart((Node)(element = (Element)list.item(i)))) >= 0 && start < endOffset) {
                        Element child;
                        String val;
                        Attr idAttr;
                        String elementName = element.getNodeName();
                        if (tagName.equals(elementName) && (idAttr = element.getAttributeNode(ID_ATTRNAME)) != null && id.equals(val = Utils.trimQuotes((String)idAttr.getNodeValue()))) {
                            Element element2 = element;
                            return element2;
                        }
                        if (element.hasChildNodes() && (child = this.findElementByIDBackward(element.getChildNodes(), id, endOffset, tagName)) != null) {
                            Element element3 = child;
                            return element3;
                        }
                    }
                    --i;
                    if (list == null) return null;
                } while (i >= 0);
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    String getForId(IRegion region) {
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getHyperlinkText() {
        String forId = this.getForId(this.getHyperlinkRegion());
        if (forId == null) {
            return MessageFormat.format(Messages.BrowseFor, Messages.BeanId);
        }
        return MessageFormat.format(Messages.BrowseForBeanId, forId);
    }
}

