/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.internal.CreateNewFileHyperlink;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CreateNewFileHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<CreateNewFileHyperlink> links = new ArrayList<CreateNewFileHyperlink>();
        IFile file = CreateNewFileHyperlinkDetector.getFile();
        if (file == null) {
            return null;
        }
        String extension = file.getFileExtension();
        if ("xml".equals(extension) || "htm".equals(extension) || "html".equals(extension) || "jsp".equals(extension) || "xhtml".equals(extension)) {
            StructuredModelWrapper smw = new StructuredModelWrapper();
            smw.init(textViewer.getDocument());
            try {
                Document xmlDocument = smw.getDocument();
                if (xmlDocument == null) {
                    return null;
                }
                Utils.AttrNodePair pair = Utils.findAttrNodePairForOffset((Node)xmlDocument, (int)region.getOffset());
                if (pair != null) {
                    if (pair.getAttribute() != null) {
                        ITextRegion textRegion = pair.getAttribute().getValueRegion();
                        if (textRegion != null && region.getOffset() >= pair.getNode().getStartOffset() + textRegion.getStart() && region.getOffset() <= pair.getNode().getStartOffset() + textRegion.getEnd()) {
                            IFile linkFile;
                            Region nodeRegion = new Region(pair.getNode().getStartOffset() + textRegion.getStart() + 1, textRegion.getLength() - 2);
                            String attrValue = pair.getAttribute().getNodeValue();
                            if (CreateNewFileHyperlinkDetector.validateName(attrValue) && (linkFile = CreateNewFileHyperlinkDetector.getLinkFile(file, attrValue)) != null) {
                                links.add(new CreateNewFileHyperlink(textViewer.getDocument(), (IRegion)nodeRegion, attrValue, linkFile));
                            }
                        }
                    } else if (pair.getNode() != null && pair.getNode() instanceof IDOMText) {
                        String text = pair.getNode().getNodeValue();
                        int startSpaces = CreateNewFileHyperlinkDetector.getStartSpaces(text);
                        int endSpaces = CreateNewFileHyperlinkDetector.getEndSpaces(text);
                        if (region.getOffset() >= pair.getNode().getStartOffset() + startSpaces && region.getOffset() <= pair.getNode().getStartOffset() + (text.length() - endSpaces) && CreateNewFileHyperlinkDetector.validateName(text.trim())) {
                            Region nodeRegion = new Region(pair.getNode().getStartOffset() + startSpaces, text.length() - (startSpaces + endSpaces));
                            IFile linkFile = CreateNewFileHyperlinkDetector.getLinkFile(file, text.trim());
                            if (linkFile != null) {
                                links.add(new CreateNewFileHyperlink(textViewer.getDocument(), (IRegion)nodeRegion, text.trim(), linkFile));
                            }
                        }
                    }
                }
            }
            finally {
                smw.dispose();
            }
        }
        if (links.size() == 0) {
            return null;
        }
        return links.toArray(new IHyperlink[links.size()]);
    }

    private static int getStartSpaces(String text) {
        int index = 0;
        while (index < text.length()) {
            char c = text.charAt(index);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private static int getEndSpaces(String text) {
        int index = text.length() - 1;
        while (index >= 0) {
            char c = text.charAt(index);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                return text.length() - 1 - index;
            }
            --index;
        }
        return 0;
    }

    private static boolean validateName(String name) {
        String nameLc = name.toLowerCase();
        if (nameLc.endsWith(".js") || nameLc.endsWith(".css") || nameLc.endsWith(".jsp") || nameLc.endsWith(".htm") || nameLc.endsWith(".html") || nameLc.endsWith(".xhtml")) {
            try {
                new URL(name);
            }
            catch (MalformedURLException malformedURLException) {
                return true;
            }
        }
        return false;
    }

    private static IFile getLinkFile(IFile baseFile, String name) {
        if (WebUtils.findResource((IResource)baseFile, (String)name) == null) {
            IProject project = baseFile.getProject();
            if (name.startsWith("/")) {
                IPath webContentPath = WebUtils.getFirstWebContentPath((IProject)project);
                if (webContentPath != null) {
                    IPath container = webContentPath.segmentCount() > 1 ? webContentPath.removeFirstSegments(1) : project.getFullPath();
                    return project.getFile(container.append(name));
                }
                return project.getFile(name);
            }
            return project.getFile(baseFile.getFullPath().removeFirstSegments(1).removeLastSegments(1).append(name));
        }
        return null;
    }

    private static IFile getFile() {
        IEditorInput input;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part != null && (input = part.getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }
}

