/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.jst.web.ui.internal.properties.AbstractPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModelListener;

public class DefaultPropertySetViewer
extends AbstractPropertySetViewer {
    private static String[] columnLabels = new String[]{"Name", "Value"};
    Table table = null;
    private int columnToEdit = 1;
    TableEditor tableEditor = null;
    private HashMap<Object, TableItem> entryToItemMap = new HashMap();
    private ICellEditorListener editorListener;
    private ListenerList activationListeners = new ListenerList();
    CellEditor cellEditor;
    private ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }

        public void cancelEditor() {
        }

        public void applyEditorValue() {
            DefaultPropertySetViewer.this.applyEditorValue();
        }
    };

    @Override
    public Composite createControl(Composite parent) {
        this.table = new Table(parent, 98308);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.addColumns();
        this.hookControl();
        this.tableEditor = new TableEditor(this.table);
        this.createEditorListener();
        return this.table;
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.table.dispose();
        this.tableEditor.dispose();
    }

    private void addColumns() {
        TableColumn[] columns = this.table.getColumns();
        int i = 0;
        while (i < columnLabels.length) {
            String string = columnLabels[i];
            if (string != null) {
                TableColumn column = i < columns.length ? columns[i] : new TableColumn(this.table, 0);
                column.setText(string);
            }
            ++i;
        }
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = DefaultPropertySetViewer.this.table.getClientArea();
                TableColumn[] columns = DefaultPropertySetViewer.this.table.getColumns();
                if (area.width > 0) {
                    columns[0].setWidth(area.width * 40 / 100);
                    columns[1].setWidth(area.width - columns[0].getWidth() - 4);
                    DefaultPropertySetViewer.this.table.removeControlListener((ControlListener)this);
                }
            }
        });
    }

    @Override
    public void refresh(List<IPropertyDescriptor> descriptors) {
        block4: {
            int i;
            int c;
            block3: {
                descriptors = this.getFilteredDescriptors(descriptors);
                c = this.table.getItemCount();
                i = 0;
                while (i < c && i < descriptors.size()) {
                    this.updateEntry(descriptors.get(i), this.table.getItem(i));
                    ++i;
                }
                if (this.table.getItemCount() <= descriptors.size()) break block3;
                i = c - 1;
                while (i >= descriptors.size()) {
                    this.removeItem(this.table.getItem(i));
                    --i;
                }
                break block4;
            }
            if (this.table.getItemCount() >= descriptors.size()) break block4;
            i = c;
            while (i < descriptors.size()) {
                this.createItem(descriptors.get(i), i);
                ++i;
            }
        }
    }

    public List<IPropertyDescriptor> getFilteredDescriptors(List<IPropertyDescriptor> descriptors) {
        if (this.category == null || this.category.equals("All")) {
            return descriptors;
        }
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        for (IPropertyDescriptor d : descriptors) {
            if (!this.category.equals(d.getCategory())) continue;
            result.add(d);
        }
        return result;
    }

    private void updateEntry(IPropertyDescriptor descriptor, TableItem item) {
        item.setData((Object)descriptor);
        this.entryToItemMap.put(descriptor.getId(), item);
        item.setText(0, descriptor.getDisplayName());
        item.setText(1, this.model.getValueAsString(descriptor));
    }

    private void createItem(IPropertyDescriptor descriptor, int index) {
        TableItem item = new TableItem(this.table, 0, index);
        item.setData((Object)descriptor);
        this.entryToItemMap.put(descriptor.getId(), item);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object possibleEntry = e.widget.getData();
                if (possibleEntry != null) {
                    DefaultPropertySetViewer.this.entryToItemMap.remove(possibleEntry);
                }
            }
        });
        this.updateEntry(descriptor, item);
    }

    private void removeItem(TableItem item) {
        IPropertyDescriptor data = (IPropertyDescriptor)item.getData();
        item.setData(null);
        this.entryToItemMap.remove(data.getId());
        item.dispose();
    }

    @Override
    protected void createEntryListener() {
        this.entryListener = new IPropertySheetModelListener(){

            @Override
            public void valueChanged(IPropertyDescriptor descriptor) {
                TableItem item = DefaultPropertySetViewer.this.findItem(descriptor);
                if (item != null) {
                    DefaultPropertySetViewer.this.updateEntry(descriptor, item);
                }
            }

            @Override
            public void descriptorsChanged() {
                if (DefaultPropertySetViewer.this.model != null) {
                    DefaultPropertySetViewer.this.refresh(DefaultPropertySetViewer.this.model.getPropertyDescriptors());
                }
            }
        };
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                DefaultPropertySetViewer.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
            }
        };
    }

    private TableItem findItem(IPropertyDescriptor descriptor) {
        TableItem result = this.entryToItemMap.get(descriptor.getId());
        if (result != null) {
            return result;
        }
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.getData() == descriptor) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public CellEditor getActiveCellEditor() {
        return this.cellEditor;
    }

    private void hookControl() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ((DefaultPropertySetViewer.this.getActiveCellEditor() == null || !DefaultPropertySetViewer.this.getActiveCellEditor().isActivated()) && e.item instanceof TableItem) {
                    TableItem item = (TableItem)e.item;
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)item.getData();
                    DefaultPropertySetViewer.this.editedDescriptor.setDescriptor(descriptor);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    DefaultPropertySetViewer.this.handleSelect((TableItem)e.item);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = DefaultPropertySetViewer.this.table.getItem(pt);
                if (item != null) {
                    DefaultPropertySetViewer.this.handleSelect(item);
                }
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    DefaultPropertySetViewer.this.deactivateCellEditor();
                } else {
                    int cfr_ignored_0 = e.keyCode;
                }
            }
        });
    }

    private void handleSelect(TableItem selection) {
        Object object;
        if (this.getActiveCellEditor() != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
        if (selection != null && (object = selection.getData()) instanceof IPropertyDescriptor) {
            this.activateCellEditor(selection);
        }
        this.entrySelectionChanged();
    }

    private void activateCellEditor(TableItem item) {
        this.table.showSelection();
        IPropertyDescriptor descriptor = (IPropertyDescriptor)item.getData();
        this.editedDescriptor.setDescriptor(descriptor);
        this.cellEditor = this.getCellEditor((Composite)this.table);
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.stopEditing();
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableEditor.grabHorizontal = layout.grabHorizontal;
        this.tableEditor.minimumWidth = layout.minimumWidth;
        this.tableEditor.setEditor(control, item, this.columnToEdit);
        this.cellEditor.setFocus();
        this.fireCellEditorActivated(this.cellEditor);
    }

    @Override
    public void stopEditing() {
        this.deactivateCellEditor();
    }

    public void deactivateCellEditor() {
        if (this.tableEditor.getEditor() == null) {
            return;
        }
        this.tableEditor.setEditor(null, null, this.columnToEdit);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.fireCellEditorDeactivated(this.cellEditor);
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
    }

    private void fireCellEditorActivated(CellEditor activatedCellEditor) {
        Object[] listeners = this.activationListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICellEditorActivationListener)listeners[i]).cellEditorActivated(activatedCellEditor);
            ++i;
        }
    }

    private void fireCellEditorDeactivated(CellEditor activatedCellEditor) {
        Object[] listeners = this.activationListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICellEditorActivationListener)listeners[i]).cellEditorDeactivated(activatedCellEditor);
            ++i;
        }
    }

    @Override
    public void applyEditorValue() {
        TableItem treeItem = this.tableEditor.getItem();
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        if (this.editedDescriptor.getPropertyDescriptor() == treeItem.getData()) {
            if (this.cellEditor == null) {
                return;
            }
            if (!this.cellEditor.isValueValid()) {
                return;
            }
            this.editedDescriptor.applyValue(this.cellEditor.getValue());
        }
    }

    private void entrySelectionChanged() {
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public CellEditor getCellEditor(Composite parent) {
        if (this.cellEditor == null) {
            this.cellEditor = this.editedDescriptor.getPropertyDescriptor().createPropertyEditor(parent);
            if (this.cellEditor != null) {
                this.cellEditor.addListener(this.cellEditorListener);
            }
        }
        if (this.cellEditor != null) {
            this.cellEditor.setValue(this.editedDescriptor.getValue());
        }
        return this.cellEditor;
    }

    static interface ICellEditorActivationListener {
        public void cellEditorActivated(CellEditor var1);

        public void cellEditorDeactivated(CellEditor var1);
    }
}

