/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.JSRecognizer;
import org.jboss.tools.jst.web.kb.internal.taglib.html.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.preferences.js.IPreferredJSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibFactory;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PreferredJSLibVersions
implements IPreferredJSLibVersion {
    IFile f;
    IHTMLLibraryVersion version;
    private Set<String> disabledLibs = new HashSet<String>();
    private Set<String> enabledLibs = new HashSet<String>();
    private boolean addMetaViewport = true;
    private Map<String, Boolean> preferredLibs = new HashMap<String, Boolean>();
    private Map<String, String> preferredVersions = new HashMap<String, String>();
    static Map<Object, QualifiedName> PREFERRED_LIBS = new HashMap<Object, QualifiedName>();

    static QualifiedName getQualifiedName(Object v) {
        QualifiedName result = PREFERRED_LIBS.get(v);
        if (result == null) {
            result = new QualifiedName("org.jboss.tools.jst.web.ui", "preferred-js-libs-" + v.toString());
            PREFERRED_LIBS.put(v, result);
        }
        return result;
    }

    public PreferredJSLibVersions(IFile file, IHTMLLibraryVersion version) {
        this.f = file;
        this.version = version;
    }

    public boolean isLibDisabled(String libName) {
        return this.disabledLibs.contains(libName);
    }

    public boolean areAllLibsDisabled() {
        return this.enabledLibs.isEmpty();
    }

    @Override
    public boolean shouldAddLib(String libName) {
        return this.preferredLibs.containsKey(libName) && this.preferredLibs.get(libName) != false;
    }

    @Override
    public String getLibVersion(String libName) {
        return this.preferredVersions.get(libName);
    }

    public void updateLibEnablementAndSelection() {
        JSLibModel model = JSLibFactory.getInstance().getPreferenceModel();
        for (String libName : new ArrayList<String>(this.preferredLibs.keySet())) {
            JSLib lib = model.getLib(libName);
            if (lib != null && !lib.getVersions().isEmpty()) continue;
            this.enabledLibs.remove(libName);
            this.disabledLibs.remove(libName);
            this.preferredLibs.remove(libName);
            this.preferredVersions.remove(libName);
        }
        for (JSLib lib : model.getLibs()) {
            if (lib.getVersions().isEmpty()) continue;
            String libName = lib.getName();
            boolean enabled = true;
            if (this.version.isPreferredJSLib(null, libName)) {
                enabled = this.f == null || !this.version.isReferencingJSLib(this.f, libName);
            } else {
                String libNameRoot = this.getLibNameRoot(lib);
                if (libNameRoot != null) {
                    boolean bl = enabled = this.f == null || DefaultJSRecognizer.getJSReferenceVersion(this.f, libNameRoot) == null;
                }
            }
            if (enabled) {
                this.enabledLibs.add(libName);
                continue;
            }
            this.disabledLibs.add(libName);
        }
        HashSet<String> availableLibs = new HashSet<String>();
        for (JSLib lib : model.getLibs()) {
            if (lib.getVersions().isEmpty()) continue;
            String libName = lib.getName();
            Boolean current = this.preferredLibs.get(libName);
            String currentVersion = this.getLibVersion(libName);
            if (currentVersion != null && lib.getVersion(currentVersion) == null) {
                currentVersion = null;
            }
            String mask = null;
            boolean add = this.version.isPreferredJSLib(this.f, libName);
            if (libName.equals("jQuery")) {
                mask = this.version == JQueryMobileVersion.JQM_1_3 ? "1.9." : "2.0.";
            } else if (libName.equals("jQuery Mobile")) {
                String string = mask = this.version == JQueryMobileVersion.JQM_1_3 ? "1.3." : "1.4.";
            }
            if (current == null) {
                this.preferredLibs.put(libName, add);
                if (!add && this.version.isPreferredJSLib(null, libName)) {
                    availableLibs.add(libName);
                }
            }
            if (currentVersion == null) {
                String lastVersion = this.getLastVersion(lib, mask);
                if (lastVersion == null) {
                    this.preferredLibs.put(libName, Boolean.FALSE);
                    current = null;
                    String[] ns = lib.getVersionNames().toArray(new String[0]);
                    lastVersion = ns[ns.length - 1];
                }
                this.preferredVersions.put(libName, lastVersion);
            }
            if (current == null) continue;
            availableLibs.add(libName);
        }
        String pl = null;
        try {
            if (this.f != null) {
                pl = this.f.getProject().getPersistentProperty(PreferredJSLibVersions.getQualifiedName(this.version));
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        if (pl != null) {
            StringTokenizer st = new StringTokenizer(pl, ";");
            while (st.hasMoreTokens()) {
                String name;
                String t = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(t, ":");
                if (st2.countTokens() != 3 || !this.preferredLibs.containsKey(name = st2.nextToken()) || availableLibs.contains(name)) continue;
                boolean add = "true".equals(st2.nextToken());
                String version = st2.nextToken();
                if (model.getLib(name).getVersion(version) != null) {
                    this.preferredVersions.put(name, version);
                    this.preferredLibs.put(name, add);
                    continue;
                }
                if (add) continue;
                this.preferredLibs.put(name, add);
            }
        }
        this.addMetaViewport = !PreferredJSLibVersions.containsMetaViewport(this.f);
    }

    private String getLastVersion(JSLib lib, String mask) {
        String[] ns = lib.getVersionNames().toArray(new String[0]);
        if (mask != null) {
            int i = ns.length - 1;
            while (i >= 0) {
                if (ns[i].startsWith(mask)) {
                    return ns[i];
                }
                --i;
            }
        } else {
            return ns[ns.length - 1];
        }
        return null;
    }

    private String getLibNameRoot(JSLib lib) {
        for (JSLibVersion v : lib.getVersions()) {
            for (String u : v.getURLs()) {
                int i;
                int j = u.indexOf(45, i = u.lastIndexOf(47) + 1);
                if (j < 0) continue;
                return u.substring(i, j + 1);
            }
        }
        return null;
    }

    public void applyLibPreference(IPreferredJSLibVersion preferredVersions) {
        for (JSLib lib : JSLibFactory.getInstance().getPreferenceModel().getLibs()) {
            String libName;
            if (lib.getVersions().isEmpty() || !this.enabledLibs.contains(libName = lib.getName())) continue;
            this.preferredLibs.put(libName, preferredVersions.shouldAddLib(libName));
            this.preferredVersions.put(libName, preferredVersions.getLibVersion(libName));
        }
    }

    public void saveLibPreference() {
        StringBuffer sb = new StringBuffer();
        for (String libName : this.preferredLibs.keySet()) {
            String shouldAdd = "" + this.preferredLibs.get(libName);
            String version = this.preferredVersions.get(libName);
            sb.append(libName).append(":").append(shouldAdd).append(":").append(version).append(";");
        }
        try {
            if (this.f != null) {
                this.f.getProject().setPersistentProperty(PreferredJSLibVersions.getQualifiedName(this.version), sb.toString());
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
    }

    public String[][] getURLs(Node node) {
        TreeSet<String> referencedJS = new TreeSet<String>();
        TreeSet<String> referencedCSS = new TreeSet<String>();
        if (node instanceof Element) {
            Element c;
            Element head = (Element)node;
            Element[] elementArray = XMLUtilities.getChildren((Element)head, (String)"link");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = elementArray[n2];
                String href = c.getAttribute("href");
                if (href != null && href.length() > 0) {
                    referencedCSS.add(href);
                }
                ++n2;
            }
            elementArray = XMLUtilities.getChildren((Element)head, (String)"script");
            n = elementArray.length;
            n2 = 0;
            while (n2 < n) {
                c = elementArray[n2];
                String src = c.getAttribute("src");
                if (src != null && src.length() > 0) {
                    referencedJS.add(src);
                }
                ++n2;
            }
        }
        JSLibModel model = JSLibFactory.getInstance().getPreferenceModel();
        String[][] result = new String[2][];
        ArrayList<String> css = new ArrayList<String>();
        ArrayList<String> js = new ArrayList<String>();
        JSLib[] jSLibArray = model.getSortedLibs();
        int n = jSLibArray.length;
        int n3 = 0;
        while (n3 < n) {
            JSLib lib = jSLibArray[n3];
            String libName = lib.getName();
            if (!this.disabledLibs.contains(libName) && this.preferredLibs.containsKey(libName) && this.preferredLibs.get(libName).booleanValue()) {
                String[] urls;
                String preferredVersion = this.preferredVersions.get(libName);
                JSLibVersion version = lib.getVersion(preferredVersion);
                String[] stringArray = urls = version.getSortedUrls();
                int n4 = urls.length;
                int n5 = 0;
                while (n5 < n4) {
                    String u = stringArray[n5];
                    if (version.isCSS(u)) {
                        if (!referencedCSS.contains(u)) {
                            css.add(u);
                        }
                    } else if (version.isJS(u) && !referencedJS.contains(u)) {
                        js.add(u);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        result[0] = css.toArray(new String[0]);
        result[1] = js.toArray(new String[0]);
        return result;
    }

    public boolean addMetaViewport() {
        return this.addMetaViewport;
    }

    static boolean containsMetaViewport(IFile file) {
        block12: {
            if (file == null) {
                return false;
            }
            IStructuredModel model = null;
            try {
                Element[] metaNodes;
                Element headNode;
                Element htmlNode;
                IDOMDocument xmlDocument;
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
                if (xmlDocument == null || (htmlNode = JSRecognizer.findChildElement((Node)xmlDocument, (String)"html")) == null || (headNode = JSRecognizer.findChildElement((Node)htmlNode, (String)"head")) == null) break block12;
                Element[] elementArray = metaNodes = JSRecognizer.findChildElements((Node)headNode, (String)"meta");
                int n = metaNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    Element meta = elementArray[n2];
                    String name = JSRecognizer.getAttribute((Element)meta, (String)"name");
                    if ("viewport".equals(name)) {
                        return true;
                    }
                    try {
                        ++n2;
                        continue;
                    }
                    catch (IOException e) {
                        WebKbPlugin.getDefault().logError((Throwable)e);
                    }
                    catch (CoreException e) {
                        WebKbPlugin.getDefault().logError((Throwable)e);
                    }
                    break;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return false;
    }

    static abstract class DefaultJSRecognizer
    extends JSRecognizer {
        DefaultJSRecognizer() {
        }

        public static String getJSReferenceVersion(IFile file, String jsLibName) {
            return JSRecognizer.getJSReferenceVersion((IFile)file, (String)jsLibName);
        }
    }
}

