/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.html.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractValidationSettingsPage;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.jboss.tools.jst.web.ui.internal.html.text.HTMLCoreNewPreferences;
import org.jboss.tools.jst.web.ui.internal.html.text.HTMLUIMessages;
import org.osgi.service.prefs.BackingStoreException;

public class HTMLSyntaxValidationPreferencePage
extends AbstractValidationSettingsPage {
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.jst.web.ui.internal.html.ui.propertyPage.project.syntax.validation";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.jst.web.ui.internal.html.ui.preferences.syntax.validation";
    private PixelConverter fPixelConverter;
    private Button fIgnoreElementNames;
    private Label fIgnoredElementNamesLabel;
    private Text fIgnoredElementNames;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private boolean fUseElementsOriginOverrides = false;
    private boolean fIgnoreElementNamesOriginOverride = false;
    private String fIgnoredElementNamesOriginOverride = "";

    public void overrideIgnoredElementsOriginValues(boolean enableIgnore, String elementNames) {
        Object data;
        this.fIgnoreElementNamesOriginOverride = enableIgnore;
        this.fIgnoredElementNamesOriginOverride = elementNames;
        this.fUseElementsOriginOverrides = true;
        if (this.fIgnoreElementNames != null && (data = (BooleanData)this.fIgnoreElementNames.getData()) != null) {
            ((BooleanData)data).originalValue = this.fIgnoreElementNamesOriginOverride;
        }
        if (this.fIgnoredElementNames != null && (data = (TextData)this.fIgnoredElementNames.getData()) != null) {
            ((TextData)data).originalValue = this.fIgnoredElementNamesOriginOverride;
        }
    }

    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        page.setLayout((Layout)layout);
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite content = this.createValidationSection(page);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        content.setLayoutData((Object)gridData);
        return page;
    }

    private Composite createValidationSection(Composite page) {
        int nColumns = 3;
        boolean hasRequiredAPI = HTMLCoreNewPreferences.hasRequiredAPI();
        ScrolledPageContent spContent = new ScrolledPageContent(page);
        Composite composite = spContent.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        if (!hasRequiredAPI) {
            Label warning = new Label(composite, 16449);
            warning.setFont(page.getFont());
            warning.setText(HTMLUIMessages.RequiresWTPSR2);
            warning.setEnabled(true);
        }
        BooleanData ignoreData = new BooleanData("ignoreElementNames");
        this.fIgnoreElementNames = new Button(composite, 32);
        this.fIgnoreElementNames.setData((Object)ignoreData);
        this.fIgnoreElementNames.setFont(page.getFont());
        this.fIgnoreElementNames.setText(HTMLUIMessages.IgnoreElementNames);
        this.fIgnoreElementNames.setEnabled(hasRequiredAPI);
        boolean ignoreElementNamesIsSelected = this.fPreferencesService.getBoolean(this.getPreferenceNodeQualifier(), ignoreData.getKey(), false, this.createPreferenceScopes());
        ignoreData.setValue(ignoreElementNamesIsSelected);
        ignoreData.originalValue = this.fUseElementsOriginOverrides ? this.fIgnoreElementNamesOriginOverride : ignoreElementNamesIsSelected;
        this.fIgnoreElementNames.setSelection(ignoreData.getValue());
        this.fIgnoreElementNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HTMLSyntaxValidationPreferencePage.this.controlChanged(e.widget);
            }

            public void widgetSelected(SelectionEvent e) {
                HTMLSyntaxValidationPreferencePage.this.controlChanged(e.widget);
            }
        });
        this.fIgnoreElementNames.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.fIgnoredElementNamesLabel = new Label(composite, 16448);
        this.fIgnoredElementNamesLabel.setFont(composite.getFont());
        this.fIgnoredElementNamesLabel.setEnabled(hasRequiredAPI && ignoreData.getValue());
        this.fIgnoredElementNamesLabel.setText(HTMLUIMessages.IgnoreElementNamesPattern);
        this.fIgnoredElementNamesLabel.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 3, 1));
        this.setHorizontalIndent((Control)this.fIgnoredElementNamesLabel, 20);
        TextData data = new TextData("elementNamesToIgnore");
        this.fIgnoredElementNames = new Text(composite, 2052);
        this.fIgnoredElementNames.setData((Object)data);
        this.fIgnoredElementNames.setEnabled(hasRequiredAPI && ignoreData.getValue());
        this.fIgnoredElementNames.setTextLimit(500);
        this.fIgnoredElementNames.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.setHorizontalIndent((Control)this.fIgnoredElementNames, 20);
        this.setWidthHint((Control)this.fIgnoredElementNames, this.convertWidthInCharsToPixels(65));
        String ignoredElementNames = this.fPreferencesService.getString(this.getPreferenceNodeQualifier(), data.getKey(), "", this.createPreferenceScopes());
        data.setValue(ignoredElementNames);
        data.originalValue = this.fUseElementsOriginOverrides ? this.fIgnoredElementNamesOriginOverride : ignoredElementNames;
        this.fIgnoredElementNames.setText(data.getValue());
        this.fIgnoredElementNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HTMLSyntaxValidationPreferencePage.this.verifyIgnoredElementNames()) {
                    HTMLSyntaxValidationPreferencePage.this.controlChanged(e.widget);
                }
            }
        });
        this.controlChanged((Widget)this.fIgnoreElementNames);
        return spContent;
    }

    private void setHorizontalIndent(Control control, int indent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = indent;
        }
    }

    private void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    private boolean verifyIgnoredElementNames() {
        String text = this.fIgnoredElementNames.getText().trim();
        if (text.length() == 0) {
            return true;
        }
        boolean valid = true;
        String[] values = text.split(",");
        int i = 0;
        while (valid && i < values.length) {
            String value = values[i].trim();
            int j = 0;
            while (valid && j < value.length()) {
                if (!Character.isJavaIdentifierPart(value.charAt(j)) && '-' != value.charAt(j) && '_' != value.charAt(j) && '*' != value.charAt(j) && '?' != value.charAt(j)) {
                    valid = false;
                }
                ++j;
            }
            ++i;
        }
        if (!valid) {
            this.setErrorMessage(NLS.bind((String)HTMLUIMessages.BadIgnoreElementNamesPattern, (Object)text));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
        return valid;
    }

    protected void controlChanged(Widget widget) {
        BooleanData data;
        if (widget instanceof Text) {
            TextData data2 = (TextData)widget.getData();
            data2.setValue(((Text)widget).getText());
        } else if (widget instanceof Button && (data = (BooleanData)widget.getData()) != null) {
            data.setValue(((Button)widget).getSelection());
            boolean hasRequiredAPI = HTMLCoreNewPreferences.hasRequiredAPI();
            this.fIgnoredElementNamesLabel.setEnabled(hasRequiredAPI & data.getValue());
            this.fIgnoredElementNames.setEnabled(hasRequiredAPI & data.getValue());
            if (data.getValue()) {
                this.fIgnoredElementNames.setFocus();
            }
        }
    }

    protected boolean shouldRevalidateOnSettingsChange() {
        TextData data = (TextData)this.fIgnoredElementNames.getData();
        if (data.isChanged()) {
            return true;
        }
        BooleanData ignoreData = (BooleanData)this.fIgnoreElementNames.getData();
        if (ignoreData.isChanged()) {
            return true;
        }
        return super.shouldRevalidateOnSettingsChange();
    }

    protected void storeValues() {
        if (HTMLCoreNewPreferences.hasRequiredAPI()) {
            IScopeContext[] contexts = this.createPreferenceScopes();
            BooleanData ignoreData = (BooleanData)this.fIgnoreElementNames.getData();
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(ignoreData.getKey(), ignoreData.getValue());
            ignoreData.originalValue = ignoreData.getValue();
            TextData data = (TextData)this.fIgnoredElementNames.getData();
            contexts[0].getNode(this.getPreferenceNodeQualifier()).put(data.getKey(), data.getValue());
            data.originalValue = data.getValue();
            int i = 0;
            while (i < contexts.length) {
                try {
                    contexts[i].getNode(this.getPreferenceNodeQualifier()).flush();
                }
                catch (BackingStoreException e) {
                    Logger.logException((Throwable)e);
                }
                ++i;
            }
        }
        super.storeValues();
        this.forceReconciling();
    }

    private void forceReconciling() {
        IPreferenceStore store;
        boolean value = (store = SSEUIPlugin.getDefault().getPreferenceStore()).getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, !value);
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, value);
    }

    protected void performDefaults() {
        if (HTMLCoreNewPreferences.hasRequiredAPI()) {
            this.resetIgnoreElementNamesPattern();
            this.resetSeverities();
        }
        super.performDefaults();
    }

    protected void resetIgnoreElementNamesPattern() {
        if (!HTMLCoreNewPreferences.hasRequiredAPI()) {
            return;
        }
        IEclipsePreferences defaultContext = new DefaultScope().getNode(this.getPreferenceNodeQualifier());
        BooleanData ignoreData = (BooleanData)this.fIgnoreElementNames.getData();
        boolean ignoreElementNames = defaultContext.getBoolean(ignoreData.getKey(), false);
        ignoreData.setValue(ignoreElementNames);
        this.fIgnoreElementNames.setSelection(ignoreData.getValue());
        TextData data = (TextData)this.fIgnoredElementNames.getData();
        String ignoredElementNames = defaultContext.get(data.getKey(), "");
        data.setValue(ignoredElementNames);
        this.fIgnoredElementNames.setText(data.getValue());
        this.controlChanged((Widget)this.fIgnoreElementNames);
    }

    protected IDialogSettings getDialogSettings() {
        return HTMLUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferencePageID() {
        return PREFERENCE_PAGE_ID;
    }

    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    protected String getPropertyPageID() {
        return PROPERTY_PAGE_ID;
    }

    public void init(IWorkbench workbench) {
    }

    private class BooleanData {
        private String fKey;
        private boolean fValue;
        boolean originalValue = false;

        public BooleanData(String key) {
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public void setValue(boolean value) {
            this.fValue = value;
        }

        public boolean getValue() {
            return this.fValue;
        }

        boolean isChanged() {
            return this.originalValue ^ this.fValue;
        }
    }

    private class TextData {
        private String fKey;
        private String fValue;
        String originalValue = "";

        public TextData(String key) {
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public void setValue(String value) {
            this.fValue = value;
        }

        public String getValue() {
            return this.fValue != null ? this.fValue : "";
        }

        boolean isChanged() {
            return !this.originalValue.equalsIgnoreCase(this.fValue);
        }
    }
}

