/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.util;

import java.util.List;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.ui.internal.editor.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletsUtil {
    public static final String TAG_COMPOSITION = "composition";
    public static final String TAG_COMPONENT = "component";
    public static final String FACELETS_URI = "http://java.sun.com/jsf/facelets";

    public static Element findComponentElement(Element root) {
        if (root == null) {
            return null;
        }
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element trimmedElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (trimmedElement = FaceletsUtil.findComponentElement((Element)child)) != null) {
                return trimmedElement;
            }
            ++i;
        }
        if (TAG_COMPOSITION.equalsIgnoreCase(root.getLocalName()) || TAG_COMPONENT.equalsIgnoreCase(root.getLocalName())) {
            return root;
        }
        return null;
    }

    public static boolean isFacelet(Node sourceNode, List<TaglibData> taglibs) {
        String sourceNodeUri;
        boolean isFacelet = false;
        String sourcePrefix = sourceNode.getPrefix();
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        if (sourceNodeTaglib != null && FACELETS_URI.equalsIgnoreCase(sourceNodeUri = sourceNodeTaglib.getUri())) {
            isFacelet = true;
        }
        return isFacelet;
    }
}

