/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import java.util.Properties;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.MobilePaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteTaglibInserter;

public class JSPPaletteInsertHelper
extends PaletteInsertHelper {
    public static final String PROPOPERTY_ADD_TAGLIB = "add taglib";
    public static final String PROPOPERTY_TAGLIBRARY_URI = "library uri";
    public static final String PROPOPERTY_TAGLIBRARY_VERSION = "library version";
    public static final String PROPOPERTY_DEFAULT_PREFIX = "default prefix";
    public static final String PROPOPERTY_FORCE_PREFIX = "force prefix";
    static JSPPaletteInsertHelper instance = new JSPPaletteInsertHelper();
    static PaletteTaglibInserter PaletteTaglibInserter = new PaletteTaglibInserter();

    public static JSPPaletteInsertHelper getInstance() {
        return instance;
    }

    protected void modify(ISourceViewer v, Properties p, String[] texts) {
        if (!MobilePaletteInsertHelper.getInstance().isMobile(v, p, texts)) {
            p.put("viewer", v);
            String tagname = p.getProperty("tag name");
            String uri = p.getProperty(PROPOPERTY_TAGLIBRARY_URI);
            String startText = texts[0];
            if (startText != null && startText.startsWith("<%@ taglib")) {
                if (PaletteTaglibInserter.inserTaglibInXml(v.getDocument(), p)) {
                    texts[0] = "";
                    return;
                }
            } else {
                p = PaletteTaglibInserter.inserTaglib(v.getDocument(), p);
            }
            String defaultPrefix = p.getProperty(PROPOPERTY_DEFAULT_PREFIX);
            IDocument d = v.getDocument();
            JSPPaletteInsertHelper.applyPrefix(texts, d, tagname, uri, defaultPrefix);
        }
    }

    public static void applyPrefix(String[] text, ITextEditor editor, String tagname, String uri, String defaultPrefix) {
        if (defaultPrefix == null || defaultPrefix.length() == 0) {
            return;
        }
        IDocument doc = null;
        if (editor != null && editor.getDocumentProvider() != null) {
            doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        }
        JSPPaletteInsertHelper.applyPrefix(text, doc, tagname, uri, defaultPrefix);
    }

    public static void applyPrefix(String[] text, IDocument doc, String tagname, String uri, String defaultPrefix) {
        if (doc == null) {
            return;
        }
        String body = doc.get();
        JSPPaletteInsertHelper.applyPrefix(text, body, tagname, uri, defaultPrefix);
    }

    public static void applyPrefix(String[] text, String body, String tagname, String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        Properties p = JSPPaletteInsertHelper.getPrefixes(body);
        String prefix = p.getProperty(uri, defaultPrefix);
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        int i = 0;
        while (i < text.length) {
            text[i] = JSPPaletteInsertHelper.applyPrefix(text[i], tagname, prefix, p);
            ++i;
        }
    }

    static String applyPrefix(String text, String tagname, String prefix, Properties prefixes) {
        int j;
        int i;
        if (text == null || text.length() == 0) {
            return text;
        }
        if (tagname == null || tagname.length() == 0) {
            return text;
        }
        while ((i = text.indexOf("%prefix|")) >= 0 && (j = text.indexOf("%", i + 8)) >= 0) {
            int j1 = text.indexOf("|", i + 8);
            String uri = "";
            String defaultPrefix = "";
            String pr = "";
            uri = text.substring(i + 8, j1);
            pr = prefixes.getProperty(uri, defaultPrefix = text.substring(j1 + 1, j));
            if (pr.length() > 0) {
                text = String.valueOf(text.substring(0, i)) + pr + ":" + text.substring(j + 1);
                continue;
            }
            text = String.valueOf(text.substring(0, i)) + text.substring(j + 1);
        }
        int k = text.toLowerCase().indexOf(":" + tagname.toLowerCase());
        if (k >= 0) {
            int g = k - 1;
            while (g >= 0 && text.charAt(g) != '/' && text.charAt(g) != '<') {
                --g;
            }
            if (g >= 0) {
                return String.valueOf(text.substring(0, g + 1)) + prefix + text.substring(k);
            }
        }
        if ((k = text.toLowerCase().indexOf("<" + tagname.toLowerCase())) >= 0) {
            return String.valueOf(text.substring(0, k + 1)) + prefix + ":" + text.substring(k + 1);
        }
        k = text.toLowerCase().indexOf("</" + tagname.toLowerCase());
        if (k >= 0) {
            return String.valueOf(text.substring(0, k + 2)) + prefix + ":" + text.substring(k + 2);
        }
        k = text.toLowerCase().indexOf("${" + tagname.toLowerCase());
        if (k >= 0) {
            return String.valueOf(text.substring(0, k + 2)) + prefix + ":" + text.substring(k + 2);
        }
        return text;
    }

    static Properties getPrefixes(String body) {
        Properties p = new Properties();
        int i = 0;
        while (i >= 0 && i < body.length()) {
            if ((i = body.indexOf("<%@ taglib ", i)) < 0) break;
            int j = body.indexOf("%>", i);
            if (j < 0) {
                j = body.length();
            }
            String taglib = body.substring(i, j);
            JSPPaletteInsertHelper.getPrefix(p, taglib);
            i = j + 1;
        }
        return p;
    }

    static void getPrefix(Properties p, String taglib) {
        int i = taglib.indexOf("uri=\"");
        if (i < 0) {
            return;
        }
        int j = taglib.indexOf("\"", i + 5);
        if (j < 0) {
            return;
        }
        String uri = taglib.substring(i + 5, j);
        i = taglib.indexOf("prefix=\"");
        if (i < 0) {
            return;
        }
        j = taglib.indexOf("\"", i + 8);
        if (j < 0) {
            return;
        }
        String prefix = taglib.substring(i + 8, j);
        p.setProperty(uri, prefix);
    }

    public static /* bridge */ /* synthetic */ PaletteInsertHelper getInstance() {
        return JSPPaletteInsertHelper.getInstance();
    }
}

