/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.StyleAttributes;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.dnd.CSSTableDragAdapter;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.dnd.CSSTableDropAdapter;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.dnd.CSSTreeDragAdapter;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSJSPRecognizer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorTableModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorTreeModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSStyleSheetContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSTreeNode;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.CSSClassSelectionChangedEvent;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.CSSSelectionEventManager;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.ICSSClassSelectionChangedListener;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.viewers.CSSSelectorFilter;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.viewers.CSSSelectorTableViewer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.viewers.CSSSelectorTreeViewer;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class CSSSelectorPartComposite
extends Composite
implements SelectionListener {
    private static final int VIEWER_HEIGHT = 500;
    private static final int BUTTOND_WIDTH = 50;
    private static final int VIEWER_WIDTH = 175;
    private Composite moveButtonsContainer;
    private Composite tableButtonsContainer;
    private Button rightButton;
    private Button leftButton;
    private Button upButton;
    private Button downButton;
    private String setClasses;
    private CSSSelectorTreeViewer allCSSStyleClassViewer;
    private CSSSelectorTableViewer selectedClassesTableViewer;
    private Map<String, Map<String, String>> allCSSClassStyles;
    private StyleAttributes styleAttributes;
    private CSSSelectorTreeModel styleClassTreeModel;
    private CSSSelectorFilter filter;
    private List<ICSSClassSelectionChangedListener> changedListeners = new ArrayList<ICSSClassSelectionChangedListener>(0);

    public CSSSelectorPartComposite(StyleAttributes styleAttributes, Composite parentComposite, String setClasses) {
        super(parentComposite, 2048);
        this.setClasses = setClasses;
        this.styleAttributes = styleAttributes;
        this.creatSelectorPart();
    }

    private void creatSelectorPart() {
        this.initControls();
        this.createLayout();
        this.initListeners();
        this.initDND();
        this.initDefaultContent();
    }

    private void initDefaultContent() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof JSPMultiPageEditor)) {
            return;
        }
        String[] selectedClasses = this.parseSetClasses();
        this.selectedClassesTableViewer.setModel(new CSSSelectorTableModel(selectedClasses));
        CSSJSPRecognizer recognizer = new CSSJSPRecognizer((JSPMultiPageEditor)editorPart);
        if (recognizer.parseCSS() == 1) {
            return;
        }
        this.styleClassTreeModel = recognizer.getCssStyleClassTreeModel();
        this.allCSSClassStyles = recognizer.getCSSStyleMap();
        this.allCSSStyleClassViewer.setModel(this.styleClassTreeModel);
        this.updateStyles();
    }

    private void initDND() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.allCSSStyleClassViewer.addDragSupport(2, types, new CSSTreeDragAdapter(this, this.allCSSStyleClassViewer, this.selectedClassesTableViewer));
        this.selectedClassesTableViewer.addDragSupport(2, types, new CSSTableDragAdapter(this, this.allCSSStyleClassViewer, this.selectedClassesTableViewer));
        this.allCSSStyleClassViewer.addDropSupport(2, types, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (event.data == null || event.data.equals("css_selector_tree_viwer")) {
                    event.detail = 0;
                    return;
                }
            }
        });
        this.selectedClassesTableViewer.addDropSupport(2, types, (DropTargetListener)new CSSTableDropAdapter(this, this.allCSSStyleClassViewer, this.selectedClassesTableViewer));
    }

    private void initListeners() {
        this.allCSSStyleClassViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CSSSelectorPartComposite.this.handleAddClass();
            }
        });
        this.selectedClassesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CSSSelectorPartComposite.this.handleRemoveClass();
            }
        });
        this.allCSSStyleClassViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                if (!CSSSelectionEventManager.getInstance().isHandleSelection()) {
                    CSSSelectionEventManager.getInstance().setHandleSelection(true);
                    return;
                }
                if (!event.getSelection().isEmpty()) {
                    CSSSelectorPartComposite.this.rightButton.setEnabled(true);
                    CSSSelectorPartComposite.this.leftButton.setEnabled(false);
                } else {
                    CSSSelectorPartComposite.this.rightButton.setEnabled(false);
                    CSSSelectorPartComposite.this.leftButton.setEnabled(false);
                }
                CSSSelectorPartComposite.this.selectedClassesTableViewer.getTable().deselectAll();
                CSSSelectorPartComposite.this.checkForTableMove(event);
                if (event.getSelection().isEmpty()) {
                    return;
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CSSSelectorPartComposite.this.fireClassSelectionChanged(CSSSelectionEventManager.getInstance().createTreeSelectionChangedEvent(event, CSSSelectorPartComposite.this.allCSSStyleClassViewer.getModel()));
                    }
                });
            }
        });
        this.selectedClassesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                if (!CSSSelectionEventManager.getInstance().isHandleSelection()) {
                    CSSSelectionEventManager.getInstance().setHandleSelection(true);
                    return;
                }
                if (!event.getSelection().isEmpty()) {
                    CSSSelectorPartComposite.this.rightButton.setEnabled(false);
                    CSSSelectorPartComposite.this.leftButton.setEnabled(true);
                } else {
                    CSSSelectorPartComposite.this.rightButton.setEnabled(false);
                    CSSSelectorPartComposite.this.leftButton.setEnabled(false);
                }
                CSSSelectorPartComposite.this.checkForTableMove(event);
                CSSSelectorPartComposite.this.allCSSStyleClassViewer.getTree().deselectAll();
                if (event.getSelection().isEmpty()) {
                    return;
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CSSSelectorPartComposite.this.fireClassSelectionChanged(CSSSelectionEventManager.getInstance().createTableSelectionChangedEvent(event, CSSSelectorPartComposite.this.allCSSStyleClassViewer.getModel()));
                    }
                });
            }
        });
        this.allCSSStyleClassViewer.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (0x1000004 == e.keyCode && 65536 == e.stateMask) {
                    CSSSelectorPartComposite.this.handleAddClass();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.selectedClassesTableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (0x1000003 == e.keyCode && 65536 == e.stateMask) {
                    CSSSelectorPartComposite.this.handleRemoveClass();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.rightButton.addSelectionListener((SelectionListener)this);
        this.leftButton.addSelectionListener((SelectionListener)this);
        this.upButton.addSelectionListener((SelectionListener)this);
        this.downButton.addSelectionListener((SelectionListener)this);
    }

    private void checkForTableMove(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        int[] selectionIndices = this.selectedClassesTableViewer.getTable().getSelectionIndices();
        if (selectionIndices.length == 0) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        if (!this.isSequencedIndices(selectionIndices)) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else if (selectionIndices[0] != 0 && selectionIndices[selectionIndices.length - 1] != this.selectedClassesTableViewer.getTable().getItemCount() - 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else if (selectionIndices[0] != 0) {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(true);
        } else if (selectionIndices[selectionIndices.length - 1] != this.selectedClassesTableViewer.getTable().getItemCount() - 1) {
            this.downButton.setEnabled(true);
            this.upButton.setEnabled(false);
        } else if (selectionIndices[0] == 0 && selectionIndices[selectionIndices.length - 1] == this.selectedClassesTableViewer.getTable().getItemCount() - 1) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private boolean isSequencedIndices(int[] indices) {
        int i = 0;
        while (i < indices.length - 1) {
            if (indices[i + 1] - indices[i] != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initControls() {
        this.allCSSStyleClassViewer = new CSSSelectorTreeViewer(this, 2818);
        this.filter = new CSSSelectorFilter();
        this.allCSSStyleClassViewer.addFilter(this.filter);
        this.moveButtonsContainer = new Composite((Composite)this, 0);
        this.rightButton = new Button(this.moveButtonsContainer, 8);
        this.leftButton = new Button(this.moveButtonsContainer, 8);
        this.selectedClassesTableViewer = new CSSSelectorTableViewer(this, 2818);
        this.tableButtonsContainer = new Composite((Composite)this, 0);
        this.upButton = new Button(this.tableButtonsContainer, 8);
        this.downButton = new Button(this.tableButtonsContainer, 8);
        this.rightButton.setToolTipText(JstUIMessages.CSS_ADD_CSS_CLASS_TIP);
        ImageDescriptor rightDesc = WebUiPlugin.getImageDescriptor("images/cssdialog/right.gif");
        Image rightImage = rightDesc.createImage();
        this.rightButton.setImage(rightImage);
        this.rightButton.setEnabled(false);
        this.rightButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
        this.leftButton.setToolTipText(JstUIMessages.CSS_REMOVE_CSS_CLASS_TIP);
        ImageDescriptor leftDesc = WebUiPlugin.getImageDescriptor("images/cssdialog/left.gif");
        Image leftImage = leftDesc.createImage();
        this.leftButton.setImage(leftImage);
        this.leftButton.setEnabled(false);
        this.leftButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
        this.upButton.setToolTipText(JstUIMessages.CSS_MOVE_UP_CSS_CLASS_TIP);
        ImageDescriptor upDesc = WebUiPlugin.getImageDescriptor("images/cssdialog/up.gif");
        Image upImage = upDesc.createImage();
        this.upButton.setImage(upImage);
        this.upButton.setEnabled(false);
        this.upButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
        this.downButton.setToolTipText(JstUIMessages.CSS_MOVE_DOWN_CSS_CLASS_TIP);
        ImageDescriptor downDesc = WebUiPlugin.getImageDescriptor("images/cssdialog/down.gif");
        Image downImage = downDesc.createImage();
        this.downButton.setImage(downImage);
        this.downButton.setEnabled(false);
        this.downButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
    }

    private String[] parseSetClasses() {
        if (this.setClasses == null || this.setClasses.length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.setClasses.trim(), " ", false);
        ArrayList<String> list = new ArrayList<String>(0);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            list.add(token.trim());
        }
        return list.toArray(new String[0]);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object ob = e.getSource();
        if (ob.equals(this.leftButton)) {
            this.handleRemoveClass();
        } else if (ob.equals(this.rightButton)) {
            this.handleAddClass();
        } else if (ob.equals(this.upButton)) {
            this.handleMoveUp();
        } else if (ob.equals(this.downButton)) {
            this.handleMoveDown();
        } else if (ob.equals(this.allCSSStyleClassViewer.getTree())) {
            this.selectedClassesTableViewer.setSelection((ISelection)new StructuredSelection());
        } else if (ob.equals(this.selectedClassesTableViewer.getTable())) {
            this.allCSSStyleClassViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    private void handleMoveDown() {
        StructuredSelection selection = (StructuredSelection)this.selectedClassesTableViewer.getSelection();
        Object[] selectedItems = selection.toArray();
        int[] selectedIndices = this.selectedClassesTableViewer.getTable().getSelectionIndices();
        int itemsCount = this.selectedClassesTableViewer.getTable().getItemCount();
        int selectionLength = selectedIndices.length;
        int i = 0;
        while (i < selectionLength) {
            TableItem item;
            CSSSelectionEventManager.getInstance().setHandleSelection(false);
            this.selectedClassesTableViewer.remove(selectedItems[selectionLength - 1 - i]);
            if (selectedIndices[selectionLength - 1 - i] == itemsCount - 1) {
                item = new TableItem(this.selectedClassesTableViewer.getTable(), this.selectedClassesTableViewer.getTable().getStyle(), itemsCount - 1);
                item.setData(selectedItems[selectionLength - 1 - i]);
                --itemsCount;
            } else {
                item = new TableItem(this.selectedClassesTableViewer.getTable(), this.selectedClassesTableViewer.getTable().getStyle(), selectedIndices[selectionLength - 1 - i] + 1);
                item.setData(selectedItems[selectionLength - 1 - i]);
            }
            ++i;
        }
        this.selectedClassesTableViewer.refresh();
        this.selectedClassesTableViewer.setSelection((ISelection)new StructuredSelection(selectedItems));
        this.updateStyles();
    }

    private void handleMoveUp() {
        StructuredSelection selection = (StructuredSelection)this.selectedClassesTableViewer.getSelection();
        Object[] selectedItems = selection.toArray();
        int[] selectedIndices = this.selectedClassesTableViewer.getTable().getSelectionIndices();
        CSSSelectionEventManager.getInstance().setHandleSelection(false);
        this.selectedClassesTableViewer.remove(selection.toArray());
        int i = 0;
        while (i < selectedIndices.length) {
            TableItem item;
            if (selectedIndices[i] == i) {
                item = new TableItem(this.selectedClassesTableViewer.getTable(), this.selectedClassesTableViewer.getTable().getStyle(), i);
                item.setData(selectedItems[i]);
            } else {
                item = new TableItem(this.selectedClassesTableViewer.getTable(), this.selectedClassesTableViewer.getTable().getStyle(), selectedIndices[i] - 1);
                item.setData(selectedItems[i]);
            }
            ++i;
        }
        this.selectedClassesTableViewer.refresh();
        this.selectedClassesTableViewer.setSelection((ISelection)new StructuredSelection(selectedItems));
        this.updateStyles();
    }

    public void widgetSelected(SelectionEvent e) {
        Object ob = e.getSource();
        if (ob.equals(this.leftButton)) {
            this.handleRemoveClass();
        } else if (ob.equals(this.rightButton)) {
            this.handleAddClass();
        } else if (ob.equals(this.upButton)) {
            this.handleMoveUp();
        } else if (ob.equals(this.downButton)) {
            this.handleMoveDown();
        }
    }

    private void handleRemoveClass() {
        TableItem[] selectedItems = this.selectedClassesTableViewer.getTable().getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            ArrayList<String> itemsToRemove = new ArrayList<String>(0);
            int i = 0;
            while (i < selectedItems.length) {
                itemsToRemove.add(selectedItems[i].getData().toString());
                ++i;
            }
            this.selectedClassesTableViewer.remove(itemsToRemove.toArray());
            this.updateStyles();
        }
    }

    private void handleAddClass() {
        LinkedHashSet<String> itemsToMove = new LinkedHashSet<String>(0);
        TreeItem[] selectedItems = this.allCSSStyleClassViewer.getTree().getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int i = 0;
            while (i < selectedItems.length) {
                TreeItem item = selectedItems[i];
                CSSContainer container = ((CSSTreeNode)item.getData()).getCSSContainer();
                CSSTreeNode treeNode = (CSSTreeNode)item.getData();
                if (container instanceof CSSStyleSheetContainer) {
                    List<CSSTreeNode> children = treeNode.getChildren();
                    int j = 0;
                    while (j < children.size()) {
                        itemsToMove.add(children.get(j).toString());
                        ++j;
                    }
                } else if (container instanceof CSSRuleContainer) {
                    itemsToMove.add(treeNode.toString());
                }
                ++i;
            }
            this.selectedClassesTableViewer.add(itemsToMove.toArray());
            this.updateStyles();
            this.allCSSStyleClassViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    private void createLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 500;
        gridData.widthHint = 175;
        this.allCSSStyleClassViewer.getTree().setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 500;
        gridData.widthHint = 175;
        this.selectedClassesTableViewer.getTable().setLayoutData((Object)gridData);
        GridLayout moveBtnContGridLayout = new GridLayout();
        moveBtnContGridLayout.numColumns = 1;
        this.moveButtonsContainer.setLayout((Layout)moveBtnContGridLayout);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 50;
        this.rightButton.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 50;
        this.leftButton.setLayoutData((Object)gridData);
        GridLayout tableBtnContGridLayout = new GridLayout();
        tableBtnContGridLayout.numColumns = 1;
        this.tableButtonsContainer.setLayout((Layout)tableBtnContGridLayout);
    }

    public void updateStyles() {
        String[] selectedItems = this.getItemsFromSelectedTable();
        this.styleAttributes.clear();
        if (this.filter == null) {
            this.filter = new CSSSelectorFilter();
            this.allCSSStyleClassViewer.addFilter(this.filter);
        }
        this.filter.removeAllFilters();
        if (selectedItems != null && selectedItems.length != 0) {
            selectedItems = this.getSortedStyleClasses(selectedItems);
            int i = 0;
            while (i < selectedItems.length) {
                if (selectedItems[i] != null) {
                    this.styleAttributes.putAll(this.allCSSClassStyles.get(selectedItems[i]));
                    this.filter.addFilterName(selectedItems[i]);
                }
                ++i;
            }
        }
        this.allCSSStyleClassViewer.refresh();
    }

    public String getCSSStyleClasses() {
        StringBuilder stringBuilder = new StringBuilder("");
        String[] selectedItems = this.getItemsFromSelectedTable();
        if (selectedItems != null && selectedItems.length != 0) {
            int i = 0;
            while (i < selectedItems.length - 1) {
                stringBuilder.append(String.valueOf(selectedItems[i]) + " ");
                ++i;
            }
            stringBuilder.append(selectedItems[selectedItems.length - 1]);
        }
        return stringBuilder.toString();
    }

    private String[] getSortedStyleClasses(String[] unsortedClasses) {
        String[] sortedStyleClasses = new String[unsortedClasses.length];
        if (this.allCSSClassStyles != null) {
            Set<String> keySet = this.allCSSClassStyles.keySet();
            int iter = 0;
            for (String styleClassName : keySet) {
                int i = 0;
                while (i < unsortedClasses.length) {
                    if (unsortedClasses[i].equals(styleClassName)) {
                        sortedStyleClasses[iter] = styleClassName;
                        ++iter;
                    }
                    ++i;
                }
            }
        }
        return sortedStyleClasses;
    }

    private String[] getItemsFromSelectedTable() {
        TableItem[] selectedTableItems = this.selectedClassesTableViewer.getTable().getItems();
        ArrayList<String> selectedItemsList = new ArrayList<String>(0);
        if (selectedTableItems != null) {
            int i = 0;
            while (i < selectedTableItems.length) {
                selectedItemsList.add((String)selectedTableItems[i].getData());
                ++i;
            }
        }
        return selectedItemsList.toArray(new String[0]);
    }

    private void fireClassSelectionChanged(final CSSClassSelectionChangedEvent event) {
        int i = 0;
        while (i < this.changedListeners.size()) {
            final ICSSClassSelectionChangedListener listener = this.changedListeners.get(i);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    int i = 0;
                    while (i < CSSSelectorPartComposite.this.changedListeners.size()) {
                        listener.classSelectionChanged(event);
                        ++i;
                    }
                }
            });
            ++i;
        }
    }

    public synchronized void addCSSClassSelectionChangedListener(ICSSClassSelectionChangedListener listener) {
        this.changedListeners.add(listener);
    }

    public synchronized void removeCSSClassSelectionChangedListener(ICSSClassSelectionChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    public void dispose() {
        int i = 0;
        while (i < this.changedListeners.size()) {
            this.removeCSSClassSelectionChangedListener(this.changedListeners.get(i));
            ++i;
        }
        this.changedListeners = null;
        super.dispose();
    }
}

