/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.css.core.internal.document.CSSModelImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.text.StructuredTextPartitionerForCSS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.ICSSDialogModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.StyleAttributes;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSModel
implements ICSSDialogModel {
    private IStructuredModel model = null;
    private IFile styleFile = null;
    private CSSStyleSheet styleSheet = null;
    private static final String COPY_SUFFIX = "_copy";
    private boolean copy = false;
    private String oldText = null;

    public CSSModel(IFile file) {
        this.styleFile = file;
        if (file != null) {
            this.init();
        }
    }

    protected void init() {
        try {
            if (this.model != null) {
                this.release();
            }
            this.copy = false;
            IModelManager modelManager = StructuredModelManager.getModelManager();
            this.model = modelManager.getExistingModelForEdit(this.styleFile);
            if (this.model == null) {
                this.model = modelManager.getModelForEdit(this.styleFile);
            } else {
                this.copy = true;
                this.model = modelManager.copyModelForEdit(this.model.getId(), String.valueOf(this.model.getId()) + COPY_SUFFIX);
                this.model.setBaseLocation(this.styleFile.getLocation().toString());
                StructuredTextPartitionerForCSS partitioner = new StructuredTextPartitionerForCSS();
                ((IDocumentExtension3)this.model.getStructuredDocument()).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", (IDocumentPartitioner)partitioner);
                partitioner.connect((IDocument)this.model.getStructuredDocument());
                this.initStyleSheet();
                this.oldText = this.model.getStructuredDocument().get();
            }
        }
        catch (IOException e) {
            WebUiPlugin.getDefault().logError(e.getMessage());
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e.getMessage());
        }
        catch (ResourceInUse e) {
            WebUiPlugin.getDefault().logError(e.getMessage());
        }
    }

    @Override
    public String addCSSRule(String selector) {
        String selectorLabel = null;
        if (this.styleSheet != null && selector != null && !selector.equals("")) {
            CSSStyleRule rule = (CSSStyleRule)((ICSSDocument)this.styleSheet).createCSSRule(String.valueOf(selector) + "{" + "}");
            ((ICSSStyleSheet)this.styleSheet).appendRule((CSSRule)rule);
            for (Map.Entry<String, CSSStyleRule> ruleEntry : this.getRulesMapping().entrySet()) {
                if (ruleEntry.getValue() != rule) continue;
                selectorLabel = ruleEntry.getKey();
            }
        }
        return selectorLabel;
    }

    protected CSSStyleRule getCSSStyle(String selectorLabel) {
        CSSStyleRule rule;
        if (selectorLabel != null && (rule = this.getRulesMapping().get(selectorLabel)) != null) {
            return rule;
        }
        return null;
    }

    @Override
    public IDocument getDocument() {
        if (this.model != null) {
            return this.model.getStructuredDocument();
        }
        return null;
    }

    @Override
    public IFile getFile() {
        return this.styleFile;
    }

    @Override
    public IndexedRegion getIndexedRegion(String selectorLabel) {
        CSSStyleRule rule;
        if (selectorLabel != null && (rule = this.getRulesMapping().get(selectorLabel)) != null && rule instanceof IndexedRegion) {
            return (IndexedRegion)rule;
        }
        return null;
    }

    private void initStyleSheet() {
        this.styleSheet = this.findStyleSheet((ICSSNode)((CSSModelImpl)this.model).getDocument());
    }

    private CSSStyleSheet findStyleSheet(ICSSNode node) {
        if (node.getNodeType() == 7) {
            return (CSSStyleSheet)node;
        }
        ICSSNodeList list = node.getChildNodes();
        int index = 0;
        while (index < list.getLength()) {
            ICSSNode child = list.item(index);
            CSSStyleSheet result = this.findStyleSheet(child);
            if (result != null) {
                return result;
            }
            ++index;
        }
        return null;
    }

    @Override
    public String getSelectorLabel(int offset) {
        ICSSNode node = (ICSSNode)this.model.getIndexedRegion(offset);
        while (node != null) {
            if (node.getNodeType() == 1) break;
            if (node.getNodeType() == 7) {
                node = ((ICSSStyleSheet)node).getFirstChild();
                break;
            }
            node = node.getParentNode();
        }
        if (node != null) {
            for (Map.Entry<String, CSSStyleRule> rule : this.getRulesMapping().entrySet()) {
                if (!node.equals(rule.getValue())) continue;
                return rule.getKey();
            }
        }
        return null;
    }

    @Override
    public List<String> getSelectorLabels() {
        ArrayList<String> selectorLabels = new ArrayList<String>(this.getRulesMapping().keySet());
        Collections.sort(selectorLabels);
        return selectorLabels;
    }

    @Override
    public void reinit() {
        this.init();
    }

    @Override
    public void release() {
        if (this.model != null) {
            this.model.releaseFromEdit();
        }
        this.model = null;
        this.oldText = null;
    }

    @Override
    public void save() {
        try {
            String newText;
            if (this.copy) {
                IFileBuffer buffer = FileBuffers.getTextFileBufferManager().getFileBuffer(this.styleFile.getFullPath(), LocationKind.NORMALIZE);
                buffer.setDirty(false);
            }
            if (!this.oldText.equals(newText = this.model.getStructuredDocument().get())) {
                this.model.save();
                this.oldText = newText;
            }
        }
        catch (IOException e) {
            WebUiPlugin.getDefault().logError(e.getMessage());
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e.getMessage());
        }
    }

    @Override
    public void setFile(IFile file) {
        this.styleFile = file;
    }

    @Override
    public void updateCSSStyle(String selectorLabel, StyleAttributes styleAttributes) {
        CSSStyleRule rule;
        if (this.styleSheet != null && selectorLabel != null && !selectorLabel.equals("") && (rule = this.getRulesMapping().get(selectorLabel)) != null) {
            CSSStyleDeclaration declaration = rule.getStyle();
            Set<Map.Entry<String, String>> set = styleAttributes.entrySet();
            if (set.size() == 0 && declaration.getLength() > 0) {
                declaration.setCssText("");
            } else {
                for (Map.Entry<String, String> me : set) {
                    if (me.getValue() == null || me.getValue().length() == 0) {
                        declaration.removeProperty(me.getKey());
                        continue;
                    }
                    declaration.setProperty(me.getKey(), me.getValue(), "");
                }
            }
        }
    }

    @Override
    public Map<String, String> getClassProperties(String selectorLabel) {
        CSSStyleRule rule = this.getRulesMapping().get(selectorLabel);
        HashMap<String, String> styleMap = new HashMap<String, String>();
        if (rule != null) {
            CSSStyleDeclaration declaration = rule.getStyle();
            int i = 0;
            while (i < declaration.getLength()) {
                String propperty = declaration.item(i);
                String value = declaration.getPropertyValue(propperty);
                styleMap.put(propperty, value);
                ++i;
            }
        }
        return styleMap;
    }

    private void prepareModel(CSSStyleSheet styleSheet) {
        String text;
        CSSRule rule;
        CSSRuleList rules = styleSheet.getCssRules();
        if (rules != null && rules.getLength() > 0 && (rule = rules.item(rules.getLength() - 1)).getType() == 1 && (text = rule.getCssText()) != null && !text.endsWith("}")) {
            rule.setCssText(String.valueOf(text) + "\n" + "}");
        }
    }

    protected Map<String, CSSStyleRule> getRulesMapping() {
        HashMap<String, CSSStyleRule> rulesMapping = new HashMap<String, CSSStyleRule>();
        if (this.styleSheet != null) {
            CSSRuleList list = this.styleSheet.getCssRules();
            HashMap<String, Integer> frequencyMap = new HashMap<String, Integer>();
            if (list != null) {
                int i = 0;
                while (i < list.getLength()) {
                    if (list.item(i) instanceof CSSStyleRule) {
                        CSSStyleRule rule = (CSSStyleRule)list.item(i);
                        Integer freq = (Integer)frequencyMap.get(rule.getSelectorText());
                        freq = freq == null ? 1 : freq + 1;
                        frequencyMap.put(rule.getSelectorText(), freq);
                        String ruleLabel = String.valueOf(rule.getSelectorText()) + (freq > 1 ? "(" + freq + ")" : "");
                        rulesMapping.put(ruleLabel, rule);
                    }
                    ++i;
                }
            }
        }
        return rulesMapping;
    }

    @Override
    public String getCSSRuleText(String selectorLabel) {
        CSSStyleRule rule = this.getCSSStyle(selectorLabel);
        if (rule != null) {
            return rule.getCssText();
        }
        return null;
    }

    @Override
    public String getCSSStyleText(String selectorLabel) {
        CSSStyleRule rule = this.getCSSStyle(selectorLabel);
        if (rule != null) {
            return rule.getStyle().getCssText();
        }
        return null;
    }
}

